/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ValueEditor
extends HoverWindow
implements Validateable {
    private final KeyAdapter d_activateKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ValueEditor.this.nextChoice();
            }
        }

        @Override
        public void keyTyped(final KeyEvent ke) {
            switch (ke.getKeyChar()) {
                case '\t': 
                case ' ': {
                    return;
                }
            }
            final Choice choice = ValueEditor.this.getCurrentChoice();
            if (choice != null) {
                ValueEditor.this.beginEditing();
                choice.field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                choice.field.setText("");
                                choice.field.dispatchEvent(ke);
                            }
                        });
                        choice.field.removeFocusListener(this);
                    }
                });
            }
        }
    };
    private final KeyAdapter d_editorKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 9: {
                    e.consume();
                    ValueEditor.this.nextChoice();
                    break;
                }
                case 10: {
                    e.consume();
                    ValueEditor.this.endEditing(true);
                    break;
                }
                case 27: {
                    e.consume();
                    ValueEditor.this.endEditing(false);
                }
            }
        }
    };
    private final Map<String, List<Choice>> d_values;
    private String d_currKey = null;
    private int d_currChoice = Integer.MAX_VALUE;
    private boolean d_editing = false;
    private final Set<IListener> d_listeners;

    public ValueEditor(Component parent) {
        this((Window)SwingUtilities.getAncestorOfClass(Window.class, parent), parent);
    }

    public ValueEditor(Window window, Component parent) {
        super(window, parent);
        this.d_values = new HashMap<String, List<Choice>>();
        this.d_listeners = new LinkedHashSet<IListener>();
    }

    public void addListener(IListener listener) {
        this.d_listeners.remove(listener);
        this.d_listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        this.d_listeners.remove(listener);
    }

    public void addChoice(String valueKey, final Choice choice) {
        List<Choice> choices = this.d_values.get(valueKey);
        if (choices == null) {
            choices = new ArrayList<Choice>();
            this.d_values.put(valueKey, choices);
        }
        choices.add(choice);
        choice.field.addKeyListener(this.d_editorKeyListener);
        choice.field.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(ValueEditor.this.isVisible() && ValueEditor.this.isChoosing() && ValueEditor.this.isEditing())) {
                    return;
                }
                Choice c = ValueEditor.this.getCurrentChoice();
                if (c != choice) {
                    return;
                }
                if (!ValueEditor.this.validateData(false, false)) {
                    return;
                }
                for (IListener listener : new ArrayList(ValueEditor.this.d_listeners)) {
                    listener.valueEditorChanged(ValueEditor.this, false);
                }
            }
        });
        choice.field.setCommitOnValidEdit(true);
        choice.field.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public void attach() {
        super.attach();
        this.getAttachedComponent().addKeyListener(this.d_activateKeyListener);
        this.set(this.d_currKey, this.d_currChoice, this.d_editing);
    }

    @Override
    public void detach() {
        this.getAttachedComponent().removeKeyListener(this.d_activateKeyListener);
        this.set(null, Integer.MAX_VALUE, false);
        super.detach();
    }

    public <T> void setValue(T val) {
        this.setValue(val, this.getCurrentChoice());
    }

    public <T> void setValue(T val, int choiceId, boolean showChoice) {
        Choice c = (Choice)this.getChoice((int)choiceId).v2;
        if (c != null) {
            if (showChoice) {
                this.setChoice(choiceId);
            }
            this.setValue(val, c);
        }
    }

    protected <T> void setValue(T val, Choice choice) {
        if (choice != null) {
            if (choice == this.getCurrentChoice()) {
                this.endEditing(false);
            }
            choice.field.setValue(val);
            choice.lbl.setText(choice.field.getText());
            if (choice == this.getCurrentChoice()) {
                this.pack();
            }
        }
    }

    public <T> T getValue() {
        if (this.isChoosing()) {
            guiFormattedFld field = this.d_values.get((Object)this.d_currKey).get((int)this.d_currChoice).field;
            return field.getValue();
        }
        return null;
    }

    @Override
    protected void setCursorLocation(Point p) {
        super.setCursorLocation(p);
        if (this.isVisible() && !this.isChoosing()) {
            this.setVisible(false);
        }
    }

    public boolean isChoosing() {
        return this.d_currKey != null && this.d_values.containsKey(this.d_currKey) && this.d_currChoice < this.d_values.get(this.d_currKey).size();
    }

    public Choice getCurrentChoice() {
        if (!this.isChoosing()) {
            return null;
        }
        return this.d_values.get(this.d_currKey).get(this.d_currChoice);
    }

    public int getCurrentChoiceId() {
        Choice c = this.getCurrentChoice();
        if (c == null) {
            return -1;
        }
        return c.id;
    }

    public void setValueType(String key) {
        if (theUtil.equal(key, this.d_currKey)) {
            return;
        }
        this.set(key, 0, this.d_editing);
    }

    public String getCurrentValueType() {
        return this.d_currKey;
    }

    public void clear() {
        this.set(null, Integer.MAX_VALUE, false);
    }

    public void nextChoice() {
        if (!this.d_values.containsKey(this.d_currKey)) {
            return;
        }
        List<Choice> choices = this.d_values.get(this.d_currKey);
        int nextChoice = (this.d_currChoice + 1) % choices.size();
        this.set(this.d_currKey, nextChoice, this.d_editing);
    }

    protected Pair<Integer, Choice> getChoice(int id) {
        List<Choice> choices = this.d_values.get(this.d_currKey);
        if (choices == null) {
            return new Pair<Integer, Object>(-1, null);
        }
        for (int m = 0; m < choices.size(); ++m) {
            if (choices.get((int)m).id != id) continue;
            return new Pair<Integer, Choice>(m, choices.get(m));
        }
        return new Pair<Integer, Object>(-1, null);
    }

    public void setChoice(int choiceId) {
        this.set(this.d_currKey, (Integer)this.getChoice((int)choiceId).v1, this.d_editing);
    }

    protected void set(String key, int choiceIx, boolean edit) {
        if (theUtil.equal(this.d_currKey, key) && choiceIx == this.d_currChoice && this.isVisible() && edit == this.d_editing) {
            return;
        }
        this.d_currKey = key;
        this.d_currChoice = choiceIx;
        this.d_editing = edit;
        final Choice choice = this.getCurrentChoice();
        if (choice == null) {
            this.setVisible(false);
            this.getAttachedComponent().setFocusTraversalKeysEnabled(true);
            return;
        }
        this.getContentPane().removeAll();
        guiPanel panel = new guiPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = new Dimension(super.getPreferredSize());
                d.height = Math.max(choice.field.getPreferredSize().height, choice.lbl.getPreferredSize().height);
                return d;
            }
        };
        panel.setOpaque(false);
        GridBagHelper gb = new GridBagHelper(panel);
        JComponent showComp = this.d_editing ? choice.field : choice.lbl;
        String desc = "<html><b>" + String.format(Intl.intl("%s:"), choice.desc) + "</b></html>";
        gb.addRow(desc, showComp);
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setVisible(false);
        this.setFocusableWindowState(this.d_editing);
        this.setVisible(true);
        this.getAttachedComponent().setFocusTraversalKeysEnabled(this.d_values.get(this.d_currKey).size() < 2);
    }

    public void beginEditing() {
        this.set(this.d_currKey, this.d_currChoice, true);
    }

    public void endEditing(boolean commit) {
        if (!(this.isVisible() && this.isChoosing() && this.isEditing())) {
            return;
        }
        if (commit && !this.validateData(true, true)) {
            return;
        }
        this.set(this.d_currKey, this.d_currChoice, false);
        if (commit) {
            for (IListener listener : new ArrayList<IListener>(this.d_listeners)) {
                listener.valueEditorChanged(this, true);
            }
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!(this.isVisible() && this.isChoosing() && this.isEditing())) {
            return true;
        }
        Choice choice = this.getCurrentChoice();
        return choice.field.validateData(showWarn, allowModify);
    }

    public boolean isEditing() {
        return this.d_editing;
    }

    public String getStatusMessage() {
        if (this.isChoosing()) {
            Choice nextChoice;
            List<Choice> choices = this.d_values.get(this.d_currKey);
            Choice choice = choices.get(this.d_currChoice);
            String msg = choice != (nextChoice = choices.get((this.d_currChoice + 1) % choices.size())) ? String.format(Intl.intl("Type to enter <i>%s</i> or press TAB for alternatives"), choice.desc) : String.format(Intl.intl("Type to enter <i>%s</i>"), choice.desc);
            msg = "<html>&lt;" + msg + "&gt;</html>";
            return msg;
        }
        return "";
    }

    public static interface IListener {
        public void valueEditorChanged(ValueEditor var1, boolean var2);
    }

    public static class Choice {
        public final int id;
        public final String desc;
        public final guiFormattedFld field;
        public final guiLabel lbl;

        public Choice(String desc, guiFormattedFld field) {
            this(0, desc, field);
        }

        public Choice(int id, String desc, guiFormattedFld field) {
            this.id = id;
            this.desc = desc;
            this.field = field;
            this.lbl = new guiLabel();
        }
    }
}

