/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.IntVR;

public class SpinBox
extends guiPanel {
    private guiIntField d_intField;
    private JButton d_upButton;
    private JButton d_downButton;
    private UpAction d_upAction;
    private DownAction d_downAction;
    private ActionListener d_actionListener;

    private void init(int val, IntVR vr) {
        this.d_upAction = new UpAction();
        this.d_downAction = new DownAction();
        this.d_intField = new guiIntField(val, vr);
        this.d_upButton = new JButton(this.d_upAction);
        this.d_upButton.setFocusable(false);
        this.d_downButton = new JButton(this.d_downAction);
        this.d_downButton.setFocusable(false);
        this.d_intField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.d_intField.getActionMap().put("up", this.d_upAction);
        this.d_intField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.d_intField.getActionMap().put("down", this.d_downAction);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.d_intField, gbc);
        this.d_upButton.setMargin(new Insets(0, 0, 0, 0));
        this.d_downButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.d_upButton, gbc);
        gbc.gridy = 1;
        this.add((Component)this.d_downButton, gbc);
    }

    public SpinBox() {
        this.init(0, IntVR.unbounded());
    }

    public SpinBox(int val, int min, int max) {
        this.init(val, IntVR.between(min, max, true, true));
    }

    public SpinBox(int val, int columns, IntVR range) {
        this.init(val, range);
        this.d_intField.setColumns(columns);
    }

    public SpinBox(int val, int min, int max, int columns) {
        this(val, columns, IntVR.between(min, max, true, true));
    }

    public void setValue(int value) {
        int newValue = value;
        int oldValue = this.getValue();
        if (newValue != oldValue) {
            this.d_intField.setValue(newValue);
        }
    }

    public int getValue() {
        return (Integer)this.d_intField.getValue();
    }

    public void setAutoValidate(boolean autoValidate) {
        this.d_intField.setAutoValidate(autoValidate);
    }

    public void setValueRange(IntVR vr) {
        this.d_intField.setValueRange(vr);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (allowModify) {
            int val = this.getValue();
            int valC = this.d_intField.getValueRange().clampValue(val);
            if (valC != val) {
                this.setValue(valC);
                this.setModified(true);
            }
        }
        return true;
    }

    public void addActionListener(ActionListener l) {
        this.d_actionListener = AWTEventMulticaster.add(this.d_actionListener, l);
        this.d_intField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "commit");
        this.d_intField.getActionMap().put("commit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinBox.this.validateData(true, true);
                if (SpinBox.this.d_intField.isModified() && SpinBox.this.d_actionListener != null) {
                    SpinBox.this.d_actionListener.actionPerformed(new ActionEvent(SpinBox.this, 1001, null));
                    SpinBox.this.d_intField.setModified(false);
                }
            }
        });
    }

    public void removeActionListener(ActionListener l) {
        this.d_actionListener = AWTEventMulticaster.remove(this.d_actionListener, l);
        if (((ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.d_actionListener, ActionListener.class)).length == 0) {
            this.d_intField.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
            this.d_intField.getActionMap().remove("commit");
        }
    }

    private class DownAction
    extends AbstractAction {
        public DownAction() {
            super("", guiUtil.loadTeciIcon("SpinDown.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinBox.this.validateData(true, true);
            int oldValue = SpinBox.this.getValue();
            int newValue = oldValue - 1;
            if (SpinBox.this.d_intField.getValueRange().checkValue(newValue)) {
                SpinBox.this.setValue(newValue);
                if (SpinBox.this.d_actionListener != null) {
                    SpinBox.this.d_actionListener.actionPerformed(new ActionEvent(SpinBox.this, 1001, null));
                }
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        public UpAction() {
            super("", guiUtil.loadTeciIcon("SpinUp.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinBox.this.validateData(true, true);
            int oldValue = SpinBox.this.getValue();
            int newValue = oldValue + 1;
            if (SpinBox.this.d_intField.getValueRange().checkValue(newValue)) {
                SpinBox.this.setValue(newValue);
                if (SpinBox.this.d_actionListener != null) {
                    SpinBox.this.d_actionListener.actionPerformed(new ActionEvent(SpinBox.this, 1001, null));
                }
            }
        }
    }
}

