/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import thunderheadeng.gui.ASeries;
import thunderheadeng.gui.LWSeries;

public class Series
extends ASeries {
    private double[] d_x;
    private double[] d_y;

    public Series(double[] x, double[] y, String name, Color color, int markType, int lineType, int weight) {
        super(name, color, markType, lineType, weight);
        this.d_x = new double[x.length];
        this.d_y = new double[y.length];
        System.arraycopy(x, 0, this.d_x, 0, x.length);
        System.arraycopy(y, 0, this.d_y, 0, y.length);
        this.updateBounds();
    }

    public LWSeries toLWSeries() {
        return new LWSeries(Series.toIntRangeSupplier(this.d_x.length), Series.toIntFunctionSupplier(this.d_x), Series.toIntFunctionSupplier(this.d_y), this.getName(), this.getColor(), this.getMarkType(), this.getLineType(), this.getWeight());
    }

    private static Supplier<IntStream> toIntRangeSupplier(int length) {
        return () -> IntStream.range(0, length);
    }

    private static Supplier<IntToDoubleFunction> toIntFunctionSupplier(double[] arr) {
        return () -> i -> arr[i];
    }

    public void setData(double[] x, double[] y) {
        this.d_x = x;
        this.d_y = y;
        this.updateBounds();
    }

    @Override
    public IntStream getIndexes() {
        return IntStream.range(0, this.d_x.length);
    }

    @Override
    public IntToDoubleFunction getX() {
        return i -> this.d_x[i];
    }

    public double[] getXVals() {
        return this.d_x;
    }

    @Override
    public IntToDoubleFunction getY() {
        return i -> this.d_y[i];
    }

    public double[] getYVals() {
        return this.d_y;
    }

    private static class RangeProducer
    implements Supplier<IntStream> {
        private final int d_length;

        public RangeProducer(int length) {
            this.d_length = length;
        }

        @Override
        public IntStream get() {
            return IntStream.range(0, this.d_length);
        }
    }
}

