/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import thunderheadeng.gui.Application;

public class ResourcePaths {
    private final Application d_app;
    private final List<String> d_resourceDirs = new ArrayList<String>();

    public ResourcePaths(Application app, String ... dirs) {
        this.d_app = app;
        this.d_resourceDirs.addAll(Arrays.asList(dirs));
    }

    public String get(String relativeFile) {
        String idir = this.d_app.getInstallDir();
        File root = new File(idir, relativeFile);
        if (this.d_resourceDirs.isEmpty()) {
            return root.getAbsolutePath();
        }
        for (String dir : this.d_resourceDirs) {
            File f = new File(idir, dir);
            if (!(f = new File(f, relativeFile)).exists()) continue;
            return f.getAbsolutePath();
        }
        if (root.exists()) {
            return root.getAbsolutePath();
        }
        return new File(new File(idir, this.d_resourceDirs.get(0)), relativeFile).getAbsolutePath();
    }

    public void addDir(String dir) {
        if (!this.d_resourceDirs.contains(dir)) {
            this.d_resourceDirs.add(dir);
        }
    }

    public void addDirs(String ... dirs) {
        for (String dir : dirs) {
            this.addDir(dir);
        }
    }

    public void removeDir(String dir) {
        this.d_resourceDirs.remove(dir);
    }

    public List<String> getDirs() {
        return this.d_resourceDirs;
    }
}

