/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.Utils;

public class RecursiveLinkStatusListener
implements ItemListener {
    private AbstractButton d_controller;
    private ComponentGroup d_cg;
    private Container d_container;
    private boolean d_invert = false;

    public RecursiveLinkStatusListener(AbstractButton controller, ComponentGroup cg, boolean invert) {
        this.d_invert = invert;
        this.d_controller = controller;
        this.d_cg = cg;
        this.updateStatus();
    }

    public RecursiveLinkStatusListener(AbstractButton controller, ComponentGroup cg) {
        this.d_controller = controller;
        this.d_cg = cg;
        this.updateStatus();
    }

    public RecursiveLinkStatusListener(AbstractButton controller, boolean invert, Component ... components) {
        this(controller, new ComponentGroup(components), invert);
    }

    public RecursiveLinkStatusListener(AbstractButton controller, Component ... components) {
        this(controller, new ComponentGroup(components));
    }

    public RecursiveLinkStatusListener(AbstractButton controller, Container container, boolean invert) {
        this.d_invert = invert;
        this.d_controller = controller;
        this.d_container = container;
        this.updateStatus();
    }

    public RecursiveLinkStatusListener(AbstractButton controller, Container container) {
        this.d_controller = controller;
        this.d_container = container;
        this.updateStatus();
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.updateStatus();
    }

    public void updateStatus() {
        boolean selected = this.d_invert ^ this.d_controller.isSelected();
        if (this.d_cg != null) {
            this.d_cg.setEnabled(selected);
        } else if (this.d_container != null) {
            Utils.setEnabled(this.d_container, selected);
        }
    }
}

