/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.IPropEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;

public class PropEditors {

    public static class UnitDoublePropEditor
    implements IPropEditor<UnitDouble> {
        private guiLabel d_lab;
        private guiUnitDoubleField d_udField;

        public UnitDoublePropEditor(String label, Unit u, UnitDoubleVR vr) {
            this(label, new guiUnitDoubleField(u, vr));
        }

        public UnitDoublePropEditor(String label, guiUnitDoubleField fld) {
            this.d_lab = new guiLabel(label);
            this.d_udField = fld;
        }

        @Override
        public int getComponentWidth(int i) {
            return 1;
        }

        @Override
        public JComponent getEditorComponent(int i) {
            if (i == 0) {
                return this.d_lab;
            }
            if (i == 1) {
                return this.d_udField;
            }
            return null;
        }

        @Override
        public int getNumComponents() {
            return 2;
        }

        @Override
        public UnitDouble getValue() {
            return (UnitDouble)this.d_udField.getValue();
        }

        @Override
        public void setValue(UnitDouble value) {
            this.d_udField.setValue(value);
        }
    }

    public static class StringPropEditor
    implements IPropEditor<String> {
        private guiLabel d_lab;
        private guiTextField d_textField;

        public StringPropEditor(String label) {
            this.d_lab = new guiLabel(label);
            this.d_textField = new guiTextField();
        }

        @Override
        public int getComponentWidth(int i) {
            return 1;
        }

        @Override
        public JComponent getEditorComponent(int i) {
            if (i == 0) {
                return this.d_lab;
            }
            if (i == 1) {
                return this.d_textField;
            }
            return null;
        }

        @Override
        public int getNumComponents() {
            return 2;
        }

        @Override
        public String getValue() {
            return this.d_textField.getValue();
        }

        @Override
        public void setValue(String value) {
            this.d_textField.setValue(value);
        }
    }

    public static class Point3dPropEditor
    implements IPropEditor<Point3d> {
        private guiLabel d_lab;
        private Unit d_naturalUnit;
        private guiUnitDoubleField d_xField;
        private guiUnitDoubleField d_yField;
        private guiUnitDoubleField d_zField;

        public Point3dPropEditor(String label, Unit u) {
            this(label, u, guiUnitDoubleField.class);
        }

        public Point3dPropEditor(String label, Unit u, Class<? extends guiUnitDoubleField> fldType) {
            this.d_lab = new guiLabel(label);
            this.d_naturalUnit = u;
            try {
                Constructor<? extends guiUnitDoubleField> cons = fldType.getConstructor(Unit.class);
                this.d_xField = cons.newInstance(u);
                this.d_yField = cons.newInstance(u);
                this.d_zField = cons.newInstance(u);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.d_xField = new guiUnitDoubleField(u);
                this.d_yField = new guiUnitDoubleField(u);
                this.d_zField = new guiUnitDoubleField(u);
            }
        }

        @Override
        public int getComponentWidth(int i) {
            return 1;
        }

        @Override
        public JComponent getEditorComponent(int i) {
            if (i == 0) {
                return this.d_lab;
            }
            if (i == 1) {
                return this.d_xField;
            }
            if (i == 2) {
                return this.d_yField;
            }
            if (i == 3) {
                return this.d_zField;
            }
            return null;
        }

        @Override
        public int getNumComponents() {
            return 4;
        }

        @Override
        public Point3d getValue() {
            double x = ((UnitDouble)this.d_xField.getValue()).getValue(this.d_naturalUnit);
            double y = ((UnitDouble)this.d_yField.getValue()).getValue(this.d_naturalUnit);
            double z = ((UnitDouble)this.d_zField.getValue()).getValue(this.d_naturalUnit);
            return new Point3d(x, y, z);
        }

        @Override
        public void setValue(Point3d value) {
            this.d_xField.setValue(new UnitDouble(value.x, this.d_naturalUnit));
            this.d_yField.setValue(new UnitDouble(value.y, this.d_naturalUnit));
            this.d_zField.setValue(new UnitDouble(value.z, this.d_naturalUnit));
        }
    }

    public static class BoolPropEditor
    implements IPropEditor<Boolean> {
        private guiCheckBox d_check;

        public BoolPropEditor(String label) {
            this.d_check = new guiCheckBox(label);
        }

        @Override
        public int getComponentWidth(int i) {
            return 10;
        }

        @Override
        public JComponent getEditorComponent(int i) {
            return this.d_check;
        }

        @Override
        public int getNumComponents() {
            return 1;
        }

        @Override
        public Boolean getValue() {
            return this.d_check.isSelected();
        }

        @Override
        public void setValue(Boolean value) {
            this.d_check.setSelected(value);
        }
    }
}

