/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import thunderheadeng.gui.Application;

public class OutputLog {
    public static File logFile = null;
    public static OutputStream logOut = null;
    public static final PrintStream origStdOut = System.out;
    public static final PrintStream origStdErr = System.err;
    private static long t = System.currentTimeMillis();

    public static String getDefaultLogDir(String appName) {
        try {
            return Application.getAppDataDir(appName) + "log" + File.separator;
        }
        catch (Throwable t) {
            return System.getProperty("user.home");
        }
    }

    public static File createLogFile(String dir, String prefix, String extn) throws IOException {
        String datetime = Long.toString(t);
        String fn = String.format("%s%s%s", prefix, datetime, extn);
        return new File(dir, fn);
    }

    public static void begin(String appName) {
        assert (logFile == null);
        try {
            String name = String.format("%s_out", appName.toLowerCase());
            logFile = OutputLog.createLogFile(OutputLog.getDefaultLogDir(appName), name, ".log");
            logFile.getParentFile().mkdirs();
            logOut = new FileOutputStream(logFile);
            FileEchoStream echoStdOut = new FileEchoStream(origStdOut, logOut);
            System.setOut(new PrintStream(echoStdOut));
            FileEchoStream echoStdErr = new FileEchoStream(origStdErr, logOut);
            System.setErr(new PrintStream(echoStdErr));
            System.out.printf("Logging out/err to \"%s\"%n", logFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void end() {
        assert (logFile != null);
        System.setOut(origStdOut);
        System.setErr(origStdErr);
        try {
            logOut.close();
            logOut = null;
            logFile.delete();
            logFile = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class FileEchoStream
    extends FilterOutputStream {
        private OutputStream d_logOut;

        public FileEchoStream(OutputStream consoleOut, OutputStream logOut) {
            super(consoleOut);
            this.d_logOut = logOut;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.d_logOut.flush();
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.d_logOut.write(b);
        }
    }
}

