/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import thunderheadeng.gui.guiUtil;

public class NoIcon
implements Icon {
    private final Color d_color;
    private final int d_width;
    private final int d_height;

    public NoIcon(Color color, int width, int height) {
        this.d_color = color;
        this.d_width = width;
        this.d_height = height;
    }

    @Override
    public int getIconHeight() {
        return this.d_height;
    }

    @Override
    public int getIconWidth() {
        return this.d_width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color = NoIcon.choose(c, this.d_color);
        Graphics2D g2d = (Graphics2D)g;
        float size = Math.min(this.d_width, this.d_height) - 1;
        g2d.setColor(color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float lineThickness = size * 0.125f;
        float halfSize = (size -= lineThickness) * 0.5f;
        float coord = (halfSize - lineThickness * 0.5f) / (float)Math.sqrt(2.0);
        float centerx = (float)(this.d_width - 1) * 0.5f + (float)x;
        float centery = (float)(this.d_height - 1) * 0.5f + (float)y;
        g2d.setStroke(new BasicStroke(lineThickness));
        g2d.drawOval(Math.round(centerx - halfSize), Math.round(centery - halfSize), Math.round(size), Math.round(size));
        g2d.drawLine(Math.round(centerx - coord), Math.round(centery + coord), Math.round(centerx + coord), Math.round(centery - coord));
    }

    private static Color choose(Component comp, Color c) {
        if (comp.isEnabled()) {
            return c;
        }
        return new Color(guiUtil.DISABLED_FILTER.filterRGB(0, 0, c.getRGB()));
    }
}

