/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Insets;
import java.awt.Window;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import thunderheadeng.gui.guiDialog;

public class MultiLineLabel
extends JTextArea {
    public MultiLineLabel(String text) {
        super(text);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
    }

    @Override
    public void setColumns(int columns) {
        super.setColumns(columns);
    }

    public void setPreferredWidth(int width) {
        int colWidth = this.getColumnWidth();
        Insets insets = this.getInsets();
        int numCols = Math.max(0, (width - insets.left - insets.right) / colWidth);
        this.setColumns(numCols);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
    }

    public static void main(String[] argv) {
        guiDialog dlg = new guiDialog((Window)null, "Message", 16);
        dlg.getDialogPane().add(new MultiLineLabel("Now is the time for all good men to come to the aid of their party.  Now is the time for all good men to come to the aid of their party.  Now is the time for all good men to come to the aid of their party.  "));
        dlg.pack();
        dlg.setVisible(true);
    }
}

