/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Stack;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public abstract class Mediator {
    private transient Events d_events = new Events();
    private boolean d_printDebugStatements = System.getProperty("debug") != null;
    private static final Stack<ListenerResponse> s_eventResponses = new Stack();
    private static final DecimalFormat s_timeFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);

    protected void setEvents(Events events) {
        this.d_events = events;
    }

    public void setDebugPrintingEnabled(boolean enabled) {
        this.d_printDebugStatements = enabled;
    }

    public Events getEvents() {
        return this.d_events;
    }

    public boolean willFireOnResume() {
        return this.d_events.willFireOnResume();
    }

    public void pauseUpdates() {
        this.pauseUpdates(true);
    }

    public void pauseUpdates(boolean listenToEvents) {
        this.d_events.pause(listenToEvents);
    }

    public boolean isListening() {
        return this.d_events.isListening();
    }

    public boolean resumeUpdates() {
        return this.d_events.resume();
    }

    public static void debugResponseStarted(IEventObserver listener) {
        if (System.getProperty("debug") == null) {
            return;
        }
        ListenerResponse lr = new ListenerResponse(listener);
        s_eventResponses.push(lr);
        lr.startResponse();
    }

    public static void debugResponseEnded() {
        if (System.getProperty("debug") == null) {
            return;
        }
        assert (!s_eventResponses.isEmpty());
        ListenerResponse lr = s_eventResponses.pop();
        lr.endResponse();
    }

    public static void debugPrintEvents(String sourceDesc) {
        if (System.getProperty("debug") == null) {
            return;
        }
        System.out.println("----" + sourceDesc + " Responding to event...");
        System.out.flush();
    }

    public static void debugPrintElapsedTimeForEvents(String sourceDesc, double timeElapsed) {
        if (System.getProperty("debug") == null) {
            return;
        }
        String timeElapsedStr = s_timeFormat.format(timeElapsed);
        System.out.println("----" + sourceDesc + " Response to event took " + timeElapsedStr + " sec.");
        System.out.flush();
    }

    static {
        s_timeFormat.applyPattern("0.0000");
    }

    private static class ListenerResponse {
        protected long d_timeStarted;
        protected final IEventObserver d_listener;

        public ListenerResponse(IEventObserver listener) {
            this.d_listener = listener;
        }

        public void startResponse() {
            this.d_timeStarted = System.nanoTime();
            Mediator.debugPrintEvents(this.d_listener.getClass().getSimpleName());
        }

        public void endResponse() {
            long timeEnded = System.nanoTime();
            double timeElapsed = (double)(timeEnded - this.d_timeStarted) * 1.0E-9;
            Mediator.debugPrintElapsedTimeForEvents(this.d_listener.getClass().getSimpleName(), timeElapsed);
        }
    }
}

