/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class ImageFilterToBufferedImageOp
implements BufferedImageOp {
    private final RGBImageFilter d_filter;

    public ImageFilterToBufferedImageOp(RGBImageFilter filter) {
        this.d_filter = filter;
    }

    public RGBImageFilter getFilter() {
        return this.d_filter;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        assert (src.getWidth() == dest.getWidth());
        assert (src.getHeight() == dest.getHeight());
        int w = src.getWidth();
        int h = src.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int rgb = src.getRGB(x, y);
                rgb = this.d_filter.filterRGB(x, y, rgb);
                dest.setRGB(x, y, rgb);
            }
        }
        return dest;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle2D.Double(0.0, 0.0, src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), destCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

