/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Pair;

public class GridBagHelper {
    public static int REMAINING = 0;
    public static final int DEF_COL_SPACE = 6;
    public static final int DEF_ROW_SPACE = 6;
    public static final int DEF_INDENT = 18;
    public static final Anchor DEF_ANCHOR = Anchor.LEFT;
    public static final double DEF_FILL = 0.0;
    private final Container d_panel;
    public int d_colSpace;
    public int d_rowSpace;
    public int d_indent;
    public Anchor d_anchor;
    public double d_hfill;
    public double d_vfill;
    public Fill d_fill;
    private boolean d_firstRowAdded = true;
    private int d_currRow;
    private int d_currCol;
    private int d_indentLevel;
    private final Deque<int[]> d_spacingStack;
    private final Deque<Pair<Object, List<Component>>> d_groupStack = new ArrayDeque<Pair<Object, List<Component>>>();

    public GridBagHelper(Container panel, boolean setBorder, int colSpace, int rowSpace) {
        this.d_panel = panel;
        if (!(panel.getLayout() instanceof GridBagLayout)) {
            panel.setLayout(new GridBagLayout());
        }
        this.d_colSpace = colSpace;
        this.d_rowSpace = rowSpace;
        this.d_indent = 18;
        this.d_anchor = DEF_ANCHOR;
        this.d_vfill = 0.0;
        this.d_hfill = 0.0;
        this.d_fill = null;
        this.d_currCol = 0;
        this.d_currRow = 0;
        this.d_indentLevel = 0;
        this.d_spacingStack = new ArrayDeque<int[]>();
        if (setBorder) {
            this.addBorder();
        }
    }

    public GridBagHelper(Container panel) {
        this(panel, false, 6, 6);
    }

    public GridBagHelper(Container panel, boolean setBorder) {
        this(panel, setBorder, 6, 6);
    }

    public void beginGroup(Object name) {
        this.d_groupStack.addFirst(new Pair(name, new ArrayList()));
    }

    public ComponentGroup2<Component> endGroup() {
        Pair<Object, List<Component>> components = this.d_groupStack.removeFirst();
        if (this.d_panel instanceof guiPanel && components.v1 != null) {
            return ((guiPanel)this.d_panel).group(components.v1, (Collection)components.v2);
        }
        return guiUtil.group((Collection)components.v2);
    }

    public void setCurrentRow(int row) {
        this.d_currRow = row;
    }

    public int getCurrentRow() {
        return this.d_currRow;
    }

    public int getCurrentCol() {
        return this.d_currCol;
    }

    public Container getPanel() {
        return this.d_panel;
    }

    public void pushSpacing(int newColSpacing, int newRowSpacing) {
        this.d_spacingStack.push(new int[]{this.d_colSpace, this.d_rowSpace});
        if (newColSpacing >= 0) {
            this.d_colSpace = newColSpacing;
        }
        if (newRowSpacing >= 0) {
            this.d_rowSpace = newRowSpacing;
        }
    }

    public void popSpacing() {
        int[] spacing = this.d_spacingStack.pop();
        this.d_colSpace = spacing[0];
        this.d_rowSpace = spacing[0];
    }

    public void indent(boolean forward) {
        if (forward) {
            this.indent();
        } else {
            this.unindent();
        }
    }

    public void indent() {
        ++this.d_indentLevel;
    }

    public void unindent() {
        --this.d_indentLevel;
    }

    public TitleSeparator addTitle(String lbl) {
        TitleSeparator title = new TitleSeparator(lbl);
        this.addFilledRow(title);
        return title;
    }

    public void addSeparator() {
        this.addFilledRow(new JSeparator());
    }

    public void addFilledRow(Object component) {
        this.addRow(component, 1.0, REMAINING);
    }

    public void addIdentRow(Object ... components) {
        this.indent(true);
        this.addRow(components);
        this.indent(false);
    }

    public void addRowSpace(int space) {
        this.addRow(Box.createVerticalStrut(space));
    }

    public void addRow(Object ... components) {
        this.add(components);
        this.nextRow();
    }

    public void add(Object ... components) {
        int m;
        for (m = 0; m < components.length; ++m) {
            if (!(components[m] instanceof String)) continue;
            components[m] = new guiLabel((String)components[m]);
        }
        m = 0;
        while (m < components.length) {
            if (components[m] != null && !(components[m] instanceof Component)) {
                ++m;
                continue;
            }
            Component comp = (Component)components[m];
            m = this.addCol(comp, components, m + 1);
        }
    }

    public void nextRow() {
        ++this.d_currRow;
        this.d_firstRowAdded = false;
        this.d_currCol = 0;
    }

    public void addCol(Component comp, Object ... constraints) {
        this.addCol(comp, constraints, 0);
    }

    public void addCol(String lbl, Object ... contraints) {
        this.addCol((Component)new guiLabel(lbl), contraints);
    }

    public int addCol(Component comp, Object[] constraints, int constraintBegin) {
        int colLeft;
        Object mod;
        int m;
        int left = this.d_indentLevel * this.d_indent;
        int top = this.d_firstRowAdded ? 0 : this.d_rowSpace;
        Fill ofill = this.d_fill;
        double hfill = this.d_hfill;
        double vfill = this.d_vfill;
        int numCols = 1;
        int numRows = 1;
        Anchor anchor = this.d_anchor;
        for (m = constraintBegin; m < constraints.length && !((mod = constraints[m]) instanceof Component) && mod != null; ++m) {
            if (mod instanceof Anchor) {
                anchor = (Anchor)((Object)mod);
                continue;
            }
            if (mod instanceof Double) {
                hfill = (Double)mod;
                continue;
            }
            if (mod instanceof double[]) {
                hfill = ((double[])mod)[0];
                vfill = ((double[])mod)[1];
                continue;
            }
            if (mod instanceof Integer) {
                numCols = (Integer)mod;
                continue;
            }
            if (mod instanceof int[]) {
                numCols = ((int[])mod)[0];
                numRows = ((int[])mod)[1];
                continue;
            }
            if (!(mod instanceof Fill)) continue;
            ofill = (Fill)((Object)mod);
        }
        int n = colLeft = this.d_currCol == 0 ? left : this.d_colSpace;
        if (comp == null) {
            this.d_currCol += numCols;
            return m;
        }
        GridBagConstraints cons = new GridBagConstraints();
        if (ofill == null) {
            ofill = hfill == 0.0 && vfill == 0.0 ? Fill.NONE : (hfill == 0.0 ? Fill.VERTICAL : (vfill == 0.0 ? Fill.HORIZONTAL : Fill.BOTH));
        }
        switch (ofill) {
            case NONE: {
                cons.fill = 0;
                break;
            }
            case BOTH: {
                cons.fill = 1;
                break;
            }
            case VERTICAL: {
                cons.fill = 3;
                break;
            }
            default: {
                cons.fill = 2;
            }
        }
        cons.weightx = hfill;
        cons.weighty = vfill;
        switch (anchor) {
            case TOP_LEFT: {
                cons.anchor = 18;
                break;
            }
            case TOP: {
                cons.anchor = 11;
                break;
            }
            case TOP_RIGHT: {
                cons.anchor = 12;
                break;
            }
            case LEFT: {
                cons.anchor = 17;
                break;
            }
            case CENTER: {
                cons.anchor = 10;
                break;
            }
            case RIGHT: {
                cons.anchor = 13;
                break;
            }
            case BOTTOM_LEFT: {
                cons.anchor = 16;
                break;
            }
            case BOTTOM: {
                cons.anchor = 15;
                break;
            }
            case BOTTOM_RIGHT: {
                cons.anchor = 14;
            }
        }
        cons.gridx = this.d_currCol;
        cons.gridy = this.d_currRow;
        cons.gridwidth = numCols;
        cons.gridheight = numRows;
        cons.insets = new Insets(top, colLeft, 0, 0);
        this.d_panel.add(comp, cons);
        if (!this.d_groupStack.isEmpty()) {
            ((List)this.d_groupStack.peekFirst().v2).add(comp);
        }
        this.d_currCol += numCols;
        return m;
    }

    public void finalizeRows() {
        GridBagUtil.addGlue(this.d_panel);
    }

    public void addBorder() {
        this.addBorder(12, 12, 12, 12);
    }

    public void addBorder(int top, int left, int bottom, int right) {
        if (this.d_panel instanceof JComponent) {
            ((JComponent)this.d_panel).setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        }
    }

    public static enum Fill {
        NONE,
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    public static enum Anchor {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        CENTER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

