/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import thunderheadeng.gui.guiUtil;

public class ColorIcon
implements Icon {
    public static final int OPT_BORDER = 1;
    public static final int OPT_NO_TRANSPARENCY = 2;
    private final Color d_color;
    private final Dimension d_dim;
    private final int d_options;

    public ColorIcon(Color color, int width, int height, int options) {
        this.d_dim = new Dimension(width, height);
        this.d_color = color;
        this.d_options = options;
    }

    @Override
    public int getIconHeight() {
        return this.d_dim.height;
    }

    @Override
    public int getIconWidth() {
        return this.d_dim.width;
    }

    private boolean test(int option) {
        return (this.d_options & option) == option;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.d_color == null) {
            return;
        }
        Color fillColor = !this.test(2) || this.d_color.getAlpha() == 255 ? this.d_color : new Color(this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), 255);
        fillColor = ColorIcon.choose(c, fillColor);
        g.setColor(fillColor);
        g.fillRect(x, y, this.d_dim.width, this.d_dim.height);
        if (this.test(1)) {
            g.setColor(ColorIcon.choose(c, Color.BLACK));
            g.drawRect(x, y, this.d_dim.width, this.d_dim.height);
        }
    }

    private static Color choose(Component comp, Color c) {
        if (comp.isEnabled()) {
            return c;
        }
        return new Color(guiUtil.DISABLED_FILTER.filterRGB(0, 0, c.getRGB()));
    }
}

