/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;

public class CkBoxListPanel
extends guiPanel {
    private final JTree d_tree = new JTree();
    private int d_overRow;
    private int d_mouseDown;
    private int d_mouseUp;
    private boolean[] d_selected;

    public CkBoxListPanel() {
        this.d_tree.getInputMap().put(KeyStroke.getKeyStroke(65, 2), new Object());
        this.d_tree.getInputMap().put(KeyStroke.getKeyStroke(67, 2), new Object());
        this.d_overRow = -1;
        this.d_mouseDown = -1;
        this.d_mouseUp = -1;
        this.d_selected = new boolean[0];
        this.d_tree.setRootVisible(false);
        this.d_tree.setCellRenderer(new LayerCkRenderer(this.d_tree.getBackground()));
        MouseHandler mouseLogic = new MouseHandler(this.d_tree);
        this.d_tree.addMouseListener(mouseLogic);
        this.d_tree.addMouseMotionListener(mouseLogic);
        JScrollPane jsp = new JScrollPane(this.d_tree);
        jsp.setPreferredSize(new Dimension(115, 0));
        this.setLayout(new GridBagLayout());
        GridBagUtil.add(this, jsp, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
    }

    public void setItems(Object[] items) {
        this.d_selected = new boolean[items.length];
        Arrays.fill(this.d_selected, false);
        Node root = new Node("root");
        for (Object obj : items) {
            root.add(new Node(obj.toString()));
        }
        this.d_tree.setModel(new DefaultTreeModel(root));
    }

    public JTree getTree() {
        return this.d_tree;
    }

    public void setSelectedAll(boolean flag) {
        for (int i = 0; i < this.d_selected.length; ++i) {
            this.setSelected(i, flag);
        }
    }

    public void setSelected(int row, boolean flag) {
        if (this.d_selected[row] != flag) {
            this.toggleSelected(row);
        }
    }

    private void toggleSelected(int row) {
        if (0 <= row && row < this.d_selected.length) {
            this.d_selected[row] = !this.d_selected[row];
            int type = this.d_selected[row] ? 0 : 1;
            this.d_comm.touch(new EvtMessage(type, row));
        }
    }

    public boolean isSelected(int row) {
        if (row < 0 || this.d_selected.length <= row) {
            return false;
        }
        return this.d_selected[row];
    }

    public static class EvtMessage {
        public static final int TYPE_SELECTED = 0;
        public static final int TYPE_DESELECTED = 1;
        public final int type;
        public final int row;

        public EvtMessage(int type, int row) {
            this.type = type;
            this.row = row;
        }
    }

    private class LayerCkRenderer
    extends guiCheckBox
    implements TreeCellRenderer {
        public LayerCkRenderer(Color bgColor) {
            super("");
            Insets margin = this.getMargin();
            margin.left = 3;
            this.setMargin(margin);
            this.setBackground(bgColor);
            this.setBorderPaintedFlat(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setText(value.toString());
            this.getModel().setRollover(CkBoxListPanel.this.d_mouseDown != row && CkBoxListPanel.this.d_overRow == row);
            this.getModel().setArmed(CkBoxListPanel.this.d_mouseDown == row && CkBoxListPanel.this.d_overRow == row);
            this.getModel().setPressed(CkBoxListPanel.this.d_mouseDown == row && CkBoxListPanel.this.d_overRow == row);
            this.getModel().setSelected(CkBoxListPanel.this.isSelected(row));
            return this;
        }
    }

    private class MouseHandler
    implements MouseMotionListener,
    MouseListener {
        private final JTree d_tree;

        public MouseHandler(JTree tree) {
            this.d_tree = tree;
        }

        private void over(int x, int y) {
            CkBoxListPanel.this.d_overRow = this.d_tree.getRowForLocation(x, y);
            this.d_tree.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.over(e.getX(), e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.over(e.getX(), e.getY());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                CkBoxListPanel.this.d_mouseDown = this.d_tree.getRowForLocation(e.getX(), e.getY());
                CkBoxListPanel.this.d_mouseUp = -1;
                this.d_tree.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                CkBoxListPanel.this.d_mouseUp = this.d_tree.getRowForLocation(e.getX(), e.getY());
                if (CkBoxListPanel.this.d_mouseUp >= 0 && CkBoxListPanel.this.d_mouseUp == CkBoxListPanel.this.d_mouseDown) {
                    CkBoxListPanel.this.toggleSelected(CkBoxListPanel.this.d_mouseUp);
                }
                CkBoxListPanel.this.d_mouseDown = -1;
                this.d_tree.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.over(e.getX(), e.getY());
        }
    }

    private static class Node
    extends DefaultMutableTreeNode {
        public Node() {
        }

        public Node(Object o) {
            super(o);
        }

        public Node(Object o, boolean allowChildren) {
            super(o, allowChildren);
        }
    }
}

