/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import thunderheadeng.Intl;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.Command;
import thunderheadeng.gui.CommandAction;
import thunderheadeng.gui.Document;
import thunderheadeng.gui.Editor;
import thunderheadeng.gui.OrderedProperties;
import thunderheadeng.gui.ResourcePaths;
import thunderheadeng.gui.SplashScreen;
import thunderheadeng.gui.View;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiError;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiTheme;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public abstract class Application {
    public static final String PROP_SAFEMODE = "SafeMode";
    public static final TypedProp<Boolean> PROP_SHOWSPLASH = new TypedProp<Boolean>((Object)"ShowSplash", true);
    public static final TypedProp<Integer> PROP_SIZE_WIDTH = new TypedProp<Integer>((Object)"Application.size.width", -1);
    public static final TypedProp<Integer> PROP_SIZE_HEIGHT = new TypedProp<Integer>((Object)"Application.size.height", -1);
    public static final TypedProp<Integer> PROP_OFFSET_X = new TypedProp<Integer>((Object)"Application.offset.x", Integer.class);
    public static final TypedProp<Integer> PROP_OFFSET_Y = new TypedProp<Integer>((Object)"Application.offset.y", Integer.class);
    public static final TypedProp<Integer> PROP_EXTENDED_STATE = new TypedProp<Integer>((Object)"Application.extendedState", 0);
    public static final CloseAllFramesCmd CLOSE_ALL_FRAMES_CMD = new CloseAllFramesCmd();
    public static final AppQuitCommand APP_QUIT_CMD = new AppQuitCommand();
    public static final OptionsCmd OPTIONS_CMD = new OptionsCmd();
    public static final double MAIN_FRAME_RATIO = 0.7;
    private static final GraphicsConfiguration s_defGC = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final Logger LOGGER = Logger.getLogger(Application.class.getName());
    private static Application s_theApp;
    private String d_installDir;
    private final ResourcePaths d_resourcePaths;
    protected TeciProps d_props;
    private JFrame d_mainFrame;
    private String d_appName;
    protected Document d_document;
    private View d_activeView;
    private Command[] d_commands = new Command[]{APP_QUIT_CMD};
    private Vector<JFrame> d_frameList = new Vector();
    private SplashScreen d_splash;
    private final boolean d_safeMode;

    public Application(String appName, String installDir, JFrame mainFrame) {
        s_theApp = this;
        this.d_installDir = installDir;
        this.d_mainFrame = mainFrame;
        this.d_appName = appName;
        this.d_resourcePaths = new ResourcePaths(this, "lib");
        this.d_frameList.add(mainFrame);
        this.d_safeMode = false;
        this.d_props = new TeciProps();
    }

    public Application(String name, String[] cmdLineArgs) {
        this(name, cmdLineArgs, null);
    }

    public Application(String name, String[] cmdLineArgs, URL splashImg) {
        s_theApp = this;
        this.d_appName = name;
        this.d_installDir = null;
        this.d_resourcePaths = new ResourcePaths(this, "lib");
        this.readPreferences();
        this.updatePreferences(cmdLineArgs);
        boolean bl = this.d_safeMode = this.d_props.getProperty(PROP_SAFEMODE) != null;
        if (this.d_safeMode) {
            LOGGER.log(Level.INFO, "Starting in SAFE MODE");
            this.d_props.remove(PROP_SAFEMODE);
            this.loadSafeModeProps(this.d_props);
        }
        boolean showSplash = splashImg != null && this.d_props.getBoolean(PROP_SHOWSPLASH) && System.getProperty("nosplash") == null;
        this.d_splash = showSplash ? new SplashScreen(splashImg) : null;
        this.loadLibraries();
        MetalLookAndFeel.setCurrentTheme(new guiTheme());
        String lafName = System.getProperty("lafpackage", UIManager.getSystemLookAndFeelClassName());
        try {
            LOGGER.log(Level.CONFIG, "Using LaF class name: " + lafName);
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        this.d_document = this.createDocument();
        this.createDefaultFrame();
        this.d_mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (Application.this.d_splash != null) {
                    Application.this.d_splash.hideSplash();
                    Application.this.d_splash = null;
                }
                Application.this.d_mainFrame.removeWindowListener(this);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DecimalReplacer dispatcher = new DecimalReplacer();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(dispatcher);
            }
        });
    }

    public SplashScreen getSplash() {
        return this.d_splash;
    }

    public boolean isSafeMode() {
        return this.d_safeMode;
    }

    protected void loadSafeModeProps(TeciProps props) {
        props.set(PROP_SHOWSPLASH, Boolean.valueOf(false));
    }

    protected abstract void loadLibraries();

    public static void loadLib(String libName) {
        LOGGER.log(Level.FINE, "loading " + libName + "...");
        System.loadLibrary(libName);
        LOGGER.log(Level.FINE, "done");
    }

    private void createDefaultFrame() {
        guiFrame mainFrame = new guiFrame();
        this.d_frameList.add(mainFrame);
        mainFrame.setTitle(this.d_appName);
        mainFrame.setCloseCommand(APP_QUIT_CMD);
        this.loadFrameProps(mainFrame);
        mainFrame.setJMenuBar(this.createMenuBar());
        this.d_mainFrame = mainFrame;
    }

    public static Rectangle getVirtualBounds() {
        GraphicsDevice[] gs;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration[] gc;
            for (GraphicsConfiguration gci : gc = gd.getConfigurations()) {
                virtualBounds = virtualBounds.union(gci.getBounds());
            }
        }
        if (virtualBounds.width == 0 || virtualBounds.height == 0) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            return new Rectangle(d);
        }
        return virtualBounds;
    }

    protected void loadFrameProps(guiFrame frame) {
        Integer offx = this.d_props.get(PROP_OFFSET_X);
        Integer offy = this.d_props.get(PROP_OFFSET_Y);
        int width = this.d_props.getInt(PROP_SIZE_WIDTH);
        int height = this.d_props.getInt(PROP_SIZE_HEIGHT);
        int extendedState = this.d_props.getInt(PROP_EXTENDED_STATE);
        Rectangle globalBounds = null;
        if (width <= 0 || height <= 0) {
            frame.setSize(0.7);
        } else {
            if (globalBounds == null) {
                globalBounds = Application.getVirtualBounds();
            }
            width = Math.min(globalBounds.width, width);
            height = Math.min(globalBounds.height, height);
            if (width <= 0 || height <= 0) {
                frame.setSize(0.7);
            } else {
                frame.setSize(width, height);
            }
        }
        if (offx != null && offy != null) {
            if (globalBounds == null) {
                globalBounds = Application.getVirtualBounds();
            }
            int maxx = globalBounds.width - frame.getSize().width;
            int maxy = globalBounds.height - frame.getSize().height;
            int minx = 0;
            int miny = 0;
            if (offx < minx) {
                offx = minx;
            } else if (offx > maxx) {
                offx = maxx;
            }
            if (offy < miny) {
                offy = miny;
            } else if (offy > maxy) {
                offy = maxy;
            }
            frame.setLocation(offx, offy);
        } else {
            frame.center();
        }
        frame.setExtendedState(extendedState);
    }

    protected void saveFrameProps(guiFrame frame) {
        if (frame == null) {
            return;
        }
        guiFrame.FrameProps props = frame.getFrameProps();
        Rectangle bounds = props.lastBounds;
        if (bounds != null) {
            this.d_props.set(PROP_OFFSET_X, Integer.valueOf(bounds.x));
            this.d_props.set(PROP_OFFSET_Y, Integer.valueOf(bounds.y));
            this.d_props.set(PROP_SIZE_WIDTH, Integer.valueOf(bounds.width));
            this.d_props.set(PROP_SIZE_HEIGHT, Integer.valueOf(bounds.height));
        }
        this.d_props.set(PROP_EXTENDED_STATE, Integer.valueOf(props.lastExtendedState));
    }

    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    public JFrame getMainFrame() {
        return this.d_mainFrame;
    }

    public String getAppName() {
        return this.d_appName;
    }

    public String toString() {
        return this.getAppName();
    }

    public guiFrame createFrame() {
        guiFrame frame = new guiFrame();
        this.addFrame(frame);
        return frame;
    }

    public void addFrame(JFrame frame) {
        frame.setIconImages(this.d_mainFrame.getIconImages());
        this.d_frameList.add(frame);
    }

    public void addEditor(Editor ed) {
        Command[] commands = ed.getCommands();
        this.d_commands = Command.merge(this.d_commands, commands);
    }

    public void addCommand(Command c) {
        List<Command> v = Arrays.asList(this.d_commands);
        v.add(c);
        this.d_commands = v.toArray(new Command[v.size()]);
    }

    public void loadMenu(String menuFile) {
    }

    public void loadToolbar(String menuFile) {
    }

    public void setActiveView(View view) {
        this.d_activeView = view;
    }

    public View getActiveView() {
        return this.d_activeView;
    }

    public Command getCommand(String name) {
        Command cmd = null;
        for (int i = 0; i < this.d_commands.length; ++i) {
            if (!this.d_commands[i].name().equals(name)) continue;
            cmd = this.d_commands[i];
        }
        return cmd;
    }

    public void createView(Document doc) {
    }

    public Document createDocument() {
        return null;
    }

    public Document getDocument() {
        return this.d_document;
    }

    public void error(String message) {
        this.error(this.getAppName(), message);
    }

    public void error(guiError error) {
        this.error(this.getAppName(), error);
    }

    public void error(String title, final String message) {
        this.error(title, new guiError(){

            @Override
            public String getMessage() {
                return message;
            }
        });
    }

    public void error(final String title, final guiError error) {
        Runnable showMessage = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Application.this.d_mainFrame, error.getMessage(), title, 0);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                showMessage.run();
            } else {
                SwingUtilities.invokeAndWait(showMessage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void error(int errorNum) {
    }

    public final void quit() throws Exception {
        throw new Exception("This method is gone. Use the other quit() method now.");
    }

    public void quit(boolean allowCancel) {
        assert (EventQueue.isDispatchThread());
        this.savePreferences();
        System.exit(0);
    }

    public static Application getApp() {
        return s_theApp;
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return s_defGC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WaitCursorMgr> getWaitMgrs() {
        Vector<JFrame> vector = this.d_frameList;
        synchronized (vector) {
            ArrayList<WaitCursorMgr> mgrs = new ArrayList<WaitCursorMgr>(this.d_frameList.size());
            for (JFrame frame : this.d_frameList) {
                WaitCursorMgr mgr = guiUtil.getWaitMgr(frame);
                if (mgr == null) continue;
                mgrs.add(mgr);
            }
            return mgrs;
        }
    }

    public void performWaitOp(Consumer<WaitCursorMgr> op) {
        this.getWaitMgrs().stream().forEach(op);
    }

    public void beginWaitCursor() {
        this.performWaitOp(mgr -> mgr.beginWaitCursor());
    }

    public void beginWaitCursor(boolean delay) {
        this.performWaitOp(mgr -> mgr.beginWaitCursor(delay));
    }

    public void beginWaitCursor(int delay) {
        this.performWaitOp(mgr -> mgr.beginWaitCursor(delay));
    }

    public boolean isInputBlocking(Component c) {
        WaitCursorMgr mgr = guiUtil.getWaitMgr(c);
        return mgr != null ? mgr.isInputBlocked() : false;
    }

    public void endWaitCursor() {
        this.performWaitOp(mgr -> mgr.endWaitCursor());
    }

    public void removeFrame(JFrame frame) {
        this.d_frameList.remove(frame);
    }

    public JFrame getActiveFrame() {
        for (JFrame frame : this.d_frameList) {
            if (!(frame instanceof guiFrame) || ((guiFrame)frame).getView() != this.d_activeView) continue;
            return frame;
        }
        return this.d_mainFrame;
    }

    public void savePreferences() {
        if (this.d_mainFrame instanceof guiFrame) {
            this.saveFrameProps((guiFrame)this.d_mainFrame);
        }
        String filename = this.getPropertyFilename();
        try {
            File f = new File(filename);
            File parent = f.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new FileNotFoundException("Unable to create folder: " + parent);
            }
            OrderedProperties orderedProps = new OrderedProperties(this.d_props);
            orderedProps.store(new FileOutputStream(filename), null);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error saving preferences to file: " + filename);
            LOGGER.log(Level.SEVERE, e.toString(), e);
            return;
        }
    }

    public void readPreferences() {
        try {
            this.d_props = this.loadPreferences();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Error retrieving preferences: " + e.getMessage());
            LOGGER.log(Level.INFO, "Using default preferences.");
            this.d_props = new TeciProps(this.getDefaultProperties());
        }
    }

    protected TeciProps loadPreferences() throws IOException {
        String filename = this.getPropertyFilename();
        TeciProps prefs = new TeciProps(this.getDefaultProperties());
        prefs.load(new FileInputStream(filename));
        return prefs;
    }

    public void updatePreferences(String[] cmdLineArgs) {
        for (int i = 0; i < cmdLineArgs.length; ++i) {
            String arg = cmdLineArgs[i];
            if (!arg.startsWith("-D")) continue;
            String[] props = arg.substring(2).split("=");
            if (props.length == 1) {
                this.d_props.setProperty(props[0], "");
                continue;
            }
            if (props.length != 2) continue;
            this.d_props.setProperty(props[0], props[1]);
        }
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public String getPreference(String name) {
        return this.d_props.getProperty(name);
    }

    public Integer getIntPreference(String name) {
        String pref = this.getPreference(name);
        if (pref == null) {
            return null;
        }
        try {
            int value = Integer.parseInt(pref);
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getBooleanPreference(String name) {
        return Boolean.valueOf(this.getPreference(name));
    }

    public TeciProps getPrefs() {
        return this.d_props;
    }

    public void setPreference(String name, String value) {
        this.d_props.setProperty(name, value);
    }

    public void setBooleanPreference(String name, boolean value) {
        this.setPreference(name, Boolean.valueOf(value).toString());
    }

    public String getWorkingDir() {
        return this.getPreference("WorkingDir");
    }

    public void setWorkingDir(String dir) {
        this.setPreference("WorkingDir", dir);
    }

    public String getResourceFile(String relativeFile) {
        return this.d_resourcePaths.get(relativeFile);
    }

    public ResourcePaths getResourcePaths() {
        return this.d_resourcePaths;
    }

    protected String getPropertyFilename() {
        String dir = Application.getPrefsFilename(this.getAppDataDir(), this.getAppName());
        LOGGER.log(Level.INFO, "Using properties file: " + dir);
        return dir;
    }

    public static String getPrefsFilename(String appDataDir, String appName) {
        return appDataDir + appName + ".props";
    }

    public static String getPrefsFilename(String appName) {
        return Application.getPrefsFilename(Application.getAppDataDir(appName), appName);
    }

    public static String getPrefsProgramDataFilename(String appName) {
        return Application.getPrefsFilename(Application.getEnvDir(appName, "PROGRAMDATA"), appName);
    }

    public String getAppDataDir() {
        return Application.getAppDataDir(this.getAppName());
    }

    public static String getAppDataDir(String appName) {
        return Application.getEnvDir(appName, "APPDATA");
    }

    public String getProgramDataDir() {
        return this.getProgramDataDir(this.getAppName());
    }

    public String getProgramDataDir(String appName) {
        return Application.getEnvDir("Application Data" + File.separator + appName, "ALLUSERSPROFILE");
    }

    private static String getEnvDir(String appName, String envKey) {
        String dirSep = File.separator;
        String env = System.getenv(envKey);
        if (env == null) {
            throw new NullPointerException("Unable to locate APPDATA folder.");
        }
        return env + dirSep + appName + dirSep;
    }

    public abstract boolean isInstallFolder(File var1);

    private String findInstallFolder() {
        String applicationDir = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        LOGGER.log(Level.INFO, "Code Source: " + applicationDir);
        try {
            applicationDir = URLDecoder.decode(applicationDir, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        if (applicationDir.endsWith(".jar")) {
            applicationDir = new File(applicationDir).getParent();
        } else {
            applicationDir = applicationDir + this.getClass().getName().replace('.', '/');
            applicationDir = new File(applicationDir).getParent();
        }
        for (File currentDir = new File(applicationDir); currentDir != null; currentDir = currentDir.getParentFile()) {
            if (!this.isInstallFolder(currentDir)) continue;
            return currentDir.getPath();
        }
        return null;
    }

    public String getInstallDir() {
        if (this.d_installDir == null) {
            this.d_installDir = this.findInstallFolder();
            LOGGER.log(Level.INFO, "Install Folder: " + this.d_installDir);
        }
        return this.d_installDir;
    }

    public static class OptionsCmd
    extends AbstractCommand {
        public OptionsCmd() {
            super("Options...", "graphics/Preferences16.gif");
        }

        @Override
        public void execute() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public String helpText() {
            return "Edit application options.";
        }
    }

    public static class AppQuitCommand
    extends CommandAction {
        public AppQuitCommand() {
            super(Intl.intl("Exit"), "");
            this.putValue("ShortDescription", "Exit");
            this.putValue("LongDescription", "Exit the application.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Application.getApp().quit(true);
        }
    }

    public static class CloseAllFramesCmd
    extends AbstractCommand {
        public CloseAllFramesCmd() {
            super("Close all windows", "");
        }

        @Override
        public void execute() {
            super.execute();
            Application app = Application.getApp();
            int max = app.d_frameList.size();
            for (int i = max - 1; i >= 0; --i) {
                JFrame frame = (JFrame)app.d_frameList.get(i);
                if (frame == app.d_mainFrame || !(frame instanceof guiFrame) || ((guiFrame)frame).close()) continue;
                this.d_breakCommandChain = true;
                return;
            }
        }
    }

    private static class DecimalReplacer
    implements KeyEventDispatcher {
        private Character d_currentChar = null;

        private DecimalReplacer() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            switch (e.getID()) {
                case 401: {
                    if (e.getKeyCode() == 110) {
                        this.d_currentChar = Character.valueOf(DecimalReplacer.getDecimalSep());
                        break;
                    }
                    this.d_currentChar = null;
                    break;
                }
                case 402: {
                    if (e.getKeyCode() != 110) break;
                    this.d_currentChar = null;
                    break;
                }
                case 400: {
                    if (this.d_currentChar == null) break;
                    e.setKeyChar(this.d_currentChar.charValue());
                }
            }
            return false;
        }

        private static char getDecimalSep() {
            NumberFormat nf = NumberFormat.getInstance();
            DecimalFormatSymbols symbols = ((DecimalFormat)nf).getDecimalFormatSymbols();
            return symbols.getDecimalSeparator();
        }
    }
}

