/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.util.function.IntToDoubleFunction;
import java.util.stream.IntStream;
import thunderheadeng.gui.ISeries;

public abstract class ASeries
implements ISeries {
    private String d_name;
    private Color d_color;
    private int d_markType;
    private int d_lineType;
    private int d_weight;
    private int d_id;
    private double d_minX;
    private double d_minY;
    private double d_maxX;
    private double d_maxY;
    private static int s_maxId = 0;

    public ASeries(String name, Color color, int markType, int lineType, int weight) {
        this.d_name = name;
        this.d_color = color;
        this.d_markType = markType;
        this.d_lineType = lineType;
        this.d_weight = weight;
        this.d_id = s_maxId++;
        this.resetBounds();
    }

    protected void resetBounds() {
        this.d_maxY = Double.NaN;
        this.d_minY = Double.NaN;
        this.d_maxX = Double.NaN;
        this.d_minX = Double.NaN;
    }

    protected boolean getBoundsValid() {
        return !Double.isNaN(this.d_minX);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    public void setName(String name) {
        this.d_name = name;
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color c) {
        this.d_color = c;
    }

    @Override
    public int getMarkType() {
        return this.d_markType;
    }

    @Override
    public int getLineType() {
        return this.d_lineType;
    }

    public void setLineType(int lineType) {
        this.d_lineType = lineType;
    }

    @Override
    public int getWeight() {
        return this.d_weight;
    }

    @Override
    public int getId() {
        return this.d_id;
    }

    protected void updateBounds() {
        IntToDoubleFunction x = this.getX();
        IntToDoubleFunction y = this.getY();
        this.d_minX = ASeries.min(this.getIndexes(), x);
        this.d_maxX = ASeries.max(this.getIndexes(), x);
        this.d_minY = ASeries.min(this.getIndexes(), y);
        this.d_maxY = ASeries.max(this.getIndexes(), y);
    }

    @Override
    public double getMinX() {
        return this.d_minX;
    }

    @Override
    public double getMaxX() {
        return this.d_maxX;
    }

    @Override
    public double getMinY() {
        return this.d_minY;
    }

    @Override
    public double getMaxY() {
        return this.d_maxY;
    }

    private static double min(IntStream indexes, IntToDoubleFunction a) {
        return indexes.mapToDouble(a).min().orElse(Double.MAX_VALUE);
    }

    private static double max(IntStream indexes, IntToDoubleFunction a) {
        return indexes.mapToDouble(a).max().orElse(-1.7976931348623157E308);
    }
}

