/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class TranslateXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;
    public final double z;

    public TranslateXform(Tuple3d vec) {
        this(vec.x, vec.y, vec.z);
    }

    public TranslateXform(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TranslateXform && ((TranslateXform)obj).x == this.x && ((TranslateXform)obj).y == this.y && ((TranslateXform)obj).z == this.z;
    }

    public int hashCode() {
        return 0x123498FE ^ Double.hashCode(this.x) + Double.hashCode(this.y) + Double.hashCode(this.z);
    }

    @Override
    public Matrix4d toMatrix(boolean modifiable) {
        return new Matrix4d(1.0, 0.0, 0.0, this.x, 0.0, 1.0, 0.0, this.y, 0.0, 0.0, 1.0, this.z, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public TransformInfo getInfo() {
        return new TransformInfo((ITransform)this, false);
    }

    @Override
    public ITransform concatenate(ITransform xform) {
        if (xform instanceof TranslateXform) {
            TranslateXform txform = (TranslateXform)xform;
            return new TranslateXform(this.x + txform.x, this.y + txform.y, this.z + txform.z);
        }
        return ITransform.super.concatenate(xform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return new TranslateXform(-this.x, -this.y, -this.z);
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d p) {
                p.x += TranslateXform.this.x;
                p.y += TranslateXform.this.y;
                p.z += TranslateXform.this.z;
            }

            @Override
            public void transform(Vector3d v) {
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public String toString() {
        return String.format("Translate: (%s, %s, %s)", Double.toString(this.x), Double.toString(this.y), Double.toString(this.z));
    }
}

