/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.ConcatTransform;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MirrorXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TranslateXform;

public class TransformUtil {
    public static final IdentityXform IDENTITY = IdentityXform.INSTANCE;
    public static final TransformInfo IDENTITY_INFO = IDENTITY.getInfo();
    public static final Predicate<ITransform> SCALING_FILTER = txform -> !(txform instanceof TranslateXform) && !(txform instanceof RotateXform) && !(txform instanceof MirrorXform) && !txform.isIdentity();

    public static ITransform rotate(double x, double y, double z, double angle) {
        if (angle == 0.0) {
            return IDENTITY;
        }
        return new RotateXform(x, y, z, angle);
    }

    public static ITransform rotate(AxisAngle4d rotation) {
        if (rotation.angle == 0.0) {
            return IDENTITY;
        }
        return new RotateXform(rotation);
    }

    public static ITransform rotate(Quat4d rotation) {
        if (rotation.w == 1.0) {
            return IDENTITY;
        }
        return new RotateXform(rotation);
    }

    public static ITransform scale(double sx, double sy, double sz) {
        if (sx == 1.0 && sy == 1.0 && sz == 1.0) {
            return IDENTITY;
        }
        return new ScaleXform(sx, sy, sz);
    }

    public static ITransform translate(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return IDENTITY;
        }
        return new TranslateXform(x, y, z);
    }

    public static ITransform mirror(Plane3d plane) {
        return new MirrorXform(plane);
    }

    public static void iterateLastToFirst(ITransform xform, Consumer<ITransform> consumer) {
        if (xform instanceof ConcatTransform) {
            ConcatTransform cxform = (ConcatTransform)xform;
            TransformUtil.iterateLastToFirst(cxform.left, consumer);
            TransformUtil.iterateLastToFirst(cxform.right, consumer);
            return;
        }
        consumer.accept(xform);
    }

    public static void iterateFirstToLast(ITransform xform, Consumer<ITransform> consumer) {
        if (xform instanceof ConcatTransform) {
            ConcatTransform cxform = (ConcatTransform)xform;
            TransformUtil.iterateFirstToLast(cxform.right, consumer);
            TransformUtil.iterateFirstToLast(cxform.left, consumer);
            return;
        }
        consumer.accept(xform);
    }

    public static ITransform findTransformLastToFirst(ITransform xform, Predicate<ITransform> test) {
        ITransform[] result = new ITransform[]{null};
        try {
            TransformUtil.iterateLastToFirst(xform, txform -> {
                if (test.test((ITransform)txform)) {
                    iTransformArray[0] = txform;
                    throw new CancellationException();
                }
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }
}

