/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.util.Map;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.util.ListMap;

public class TransformInfo {
    public final ITransform xform;
    private Matrix4d d_matrix;
    private Double d_determinant;
    private Boolean d_isIdentity;
    private Boolean d_hasNegativeScale;
    private Map<IDOF, Boolean> d_dofCompatibility;
    private Boolean d_isInvertible;

    protected TransformInfo(ITransform xform) {
        this(xform, null);
    }

    public TransformInfo(Matrix4d matrix) {
        this((ITransform)new MatrixXform(matrix), matrix);
    }

    protected TransformInfo(ITransform xform, Matrix4d matrix) {
        this.xform = xform;
        this.d_matrix = matrix;
    }

    protected TransformInfo(ITransform xform, boolean hasNegativeScale) {
        this.xform = xform;
        this.d_matrix = null;
        this.d_hasNegativeScale = hasNegativeScale;
    }

    public synchronized Matrix4d getMatrix() {
        if (this.d_matrix == null) {
            this.d_matrix = this.xform.toMatrix(false);
        }
        return this.d_matrix;
    }

    public synchronized double getDeterminant() {
        if (this.d_determinant == null) {
            this.d_determinant = this.getMatrix().determinant();
        }
        return this.d_determinant;
    }

    public synchronized boolean isIdentity() {
        if (this.d_isIdentity == null) {
            this.d_isIdentity = this.xform.isIdentity();
        }
        return this.d_isIdentity;
    }

    public synchronized boolean isInvertible() {
        if (this.d_isInvertible == null) {
            this.d_isInvertible = this.xform.isInvertible();
        }
        return this.d_isInvertible;
    }

    public synchronized boolean isAccepted(IDOF dof) {
        if (dof == IDOF.FREE) {
            return true;
        }
        if (this.d_dofCompatibility == null) {
            this.d_dofCompatibility = new ListMap<IDOF, Boolean>();
        }
        return this.d_dofCompatibility.computeIfAbsent(dof, d -> d.accept(this));
    }

    public TransformInfo concatenate(ITransform xform) {
        ITransform newXform = this.xform.concatenate(xform);
        if (newXform == this.xform) {
            return this;
        }
        return newXform.getInfo();
    }

    public synchronized boolean hasNegativeScale() {
        if (this.d_hasNegativeScale == null) {
            double det = this.getDeterminant();
            this.d_hasNegativeScale = Double.isNaN(det) ? false : det < 0.0;
        }
        return this.d_hasNegativeScale;
    }

    public AABox getBounds(IGeom geom, AABox bounds) {
        return GeomUtil.getTransformedBounds(this, geom, bounds);
    }
}

