/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;

public class ScaleXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;
    public final double z;

    public ScaleXform(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ScaleXform && ((ScaleXform)obj).x == this.x && ((ScaleXform)obj).y == this.y && ((ScaleXform)obj).z == this.z;
    }

    public int hashCode() {
        return 0x239FA83 ^ Double.hashCode(this.x) + Double.hashCode(this.y) + Double.hashCode(this.z);
    }

    @Override
    public Matrix4d toMatrix(boolean modifiable) {
        return new Matrix4d(this.x, 0.0, 0.0, 0.0, 0.0, this.y, 0.0, 0.0, 0.0, 0.0, this.z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public ITransform concatenate(ITransform xform) {
        if (xform instanceof ScaleXform) {
            ScaleXform sxform = (ScaleXform)xform;
            return new ScaleXform(this.x * sxform.x, this.y * sxform.y, this.z * sxform.z);
        }
        return ITransform.super.concatenate(xform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        if (!this.isInvertible()) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible scale transform: contains 0 scaling factor."));
        }
        return new ScaleXform(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    @Override
    public boolean isInvertible() {
        return this.x != 0.0 && this.y != 0.0 && this.z != 0.0;
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d p) {
                p.x *= ScaleXform.this.x;
                p.y *= ScaleXform.this.y;
                p.z *= ScaleXform.this.z;
            }

            @Override
            public void transform(Vector3d v) {
                v.x *= ScaleXform.this.x;
                v.y *= ScaleXform.this.y;
                v.z *= ScaleXform.this.z;
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.x == 1.0 && this.y == 1.0 && this.z == 1.0;
    }

    public String toString() {
        return String.format("Scale: (%s, %s, %s)", Double.toString(this.x), Double.toString(this.y), Double.toString(this.z));
    }
}

