/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class RotateXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Quat4d rotation;

    public RotateXform(double x, double y, double z, double angle) {
        this(new AxisAngle4d(x, y, z, angle));
    }

    public RotateXform(AxisAngle4d rotation) {
        this(RotateXform.toQuat(rotation));
    }

    public RotateXform(Quat4d rotation) {
        this.rotation = rotation;
    }

    private static Quat4d toQuat(AxisAngle4d rotation) {
        Quat4d result = new Quat4d();
        result.set(rotation);
        return result;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RotateXform && ((RotateXform)obj).rotation.equals((Tuple4d)this.rotation);
    }

    public int hashCode() {
        return 0x239FA83 ^ this.rotation.hashCode();
    }

    @Override
    public Matrix4d toMatrix(boolean modifiable) {
        Matrix4d mat = new Matrix4d();
        mat.set(this.rotation);
        return mat;
    }

    @Override
    public TransformInfo getInfo() {
        return new TransformInfo((ITransform)this, false);
    }

    public double getAngle() {
        return 2.0 * Math.acos(this.rotation.w);
    }

    public Vector3d getAxis() {
        return this.getAxis(this.getAngle());
    }

    private Vector3d getAxis(double angle) {
        double invSinAngle = 1.0 / Math.sin(angle);
        return new Vector3d(this.rotation.x * invSinAngle, this.rotation.y * invSinAngle, this.rotation.z * invSinAngle);
    }

    public AxisAngle4d getAxisAngle() {
        double angle = this.getAngle();
        Vector3d axis = this.getAxis(angle);
        return new AxisAngle4d(axis, angle);
    }

    @Override
    public ITransform concatenate(ITransform xform) {
        if (xform instanceof RotateXform) {
            RotateXform rxform = (RotateXform)xform;
            Quat4d newRot = new Quat4d(this.rotation);
            newRot.mul(rxform.rotation);
            return new RotateXform(newRot);
        }
        return ITransform.super.concatenate(xform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        try {
            Quat4d inverted = new Quat4d(this.rotation);
            inverted.inverse();
            return new RotateXform(inverted);
        }
        catch (Throwable t) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible rotation transform."));
        }
    }

    @Override
    public boolean isInvertible() {
        try {
            this.invert();
            return true;
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d p) {
                this.transform((Tuple3d)p);
            }

            @Override
            public void transform(Vector3d v) {
                this.transform((Tuple3d)v);
            }

            private void transform(Tuple3d v) {
                double tw = -RotateXform.this.rotation.x * v.x - RotateXform.this.rotation.y * v.y - RotateXform.this.rotation.z * v.z;
                double tx = RotateXform.this.rotation.w * v.x + RotateXform.this.rotation.y * v.z - RotateXform.this.rotation.z * v.y;
                double ty = RotateXform.this.rotation.w * v.y - RotateXform.this.rotation.x * v.z + RotateXform.this.rotation.z * v.x;
                double tz = RotateXform.this.rotation.w * v.z + RotateXform.this.rotation.x * v.y - RotateXform.this.rotation.y * v.x;
                v.x = -tw * RotateXform.this.rotation.x + tx * RotateXform.this.rotation.w - ty * RotateXform.this.rotation.z + tz * RotateXform.this.rotation.y;
                v.y = -tw * RotateXform.this.rotation.y + tx * RotateXform.this.rotation.z + ty * RotateXform.this.rotation.w - tz * RotateXform.this.rotation.x;
                v.z = -tw * RotateXform.this.rotation.z - tx * RotateXform.this.rotation.y + ty * RotateXform.this.rotation.x + tz * RotateXform.this.rotation.w;
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.rotation.w == 1.0;
    }

    public String toString() {
        Vector3d axis = this.getAxis();
        double angle = this.getAngle();
        return String.format("Rotate: %s %s deg", axis, Double.toString(Math.toDegrees(angle)));
    }
}

