/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.MappedIterator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;

public interface IGeomNode {
    public static final int OPT_FLATTEN_GEOM_GROUPS = 1;
    public static final int OPT_EXCLUDE_ROOT_XFORM = 2;

    public ITransform getLocalTransform();

    public IGeom getLocalGeom();

    public IPropertySet getLocalElements();

    public Collection<? extends IGeomNode> getChildren();

    default public IGeomNode transform(TransformInfo xform) {
        ITransform thisXform = this.getLocalTransform();
        ITransform newXform = xform.xform.concatenate(thisXform);
        if (newXform == thisXform) {
            return this;
        }
        IGeomNode baked = GeomNodeUtil.bakeIfRecommended(xform, this);
        if (baked != this) {
            return baked;
        }
        return GeomNodeUtil.newNode(newXform, this.getLocalGeom(), this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode quickTransform(TransformInfo xform) {
        ITransform thisXform = this.getLocalTransform();
        ITransform newXform = xform.xform.concatenate(thisXform);
        if (newXform == thisXform) {
            return this;
        }
        return GeomNodeUtil.newNode(newXform, this.getLocalGeom(), this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode applyLocalGeom(IGeom geom) {
        if (geom == this.getLocalGeom()) {
            return this;
        }
        return GeomNodeUtil.newNode(this.getLocalTransform(), geom, this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode applyLocalTransform(ITransform xform) {
        if (xform == this.getLocalTransform()) {
            return this;
        }
        return GeomNodeUtil.newNode(xform, this.getLocalGeom(), this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode applyLocalElements(IPropertySet elements) {
        if (elements == this.getLocalElements()) {
            return this;
        }
        return GeomNodeUtil.newNode(this.getLocalTransform(), this.getLocalGeom(), elements, this.getChildren());
    }

    default public AABox getBoundingBox(AABox bounds) {
        TransformInfo ti = this.getLocalTransform().getInfo();
        AABox btransformer = GeomUtil.getBoundsTransformer(ti, bounds);
        this.getLocalGeom().getBoundingBox(btransformer);
        for (IGeomNode iGeomNode : this.getChildren()) {
            iGeomNode.getBoundingBox(btransformer);
        }
        return bounds;
    }

    default public IGeomNode flatten(int options) {
        return GeomNodeUtil.flatten(this, options);
    }

    default public IGeomNode flatten() {
        return this.flatten(0);
    }

    default public IGeomNode bakeIfRecommended() {
        return GeomNodeUtil.bakeIfRecommended(TransformUtil.IDENTITY_INFO, this);
    }

    default public List<Pair<TransformInfo, IGeom>> quickFlatten(int options) {
        return GeomNodeUtil.quickFlatten(this, options);
    }

    default public List<Pair<TransformInfo, IGeom>> quickFlatten() {
        return this.quickFlatten(0);
    }

    default public <T> IElemSource<T> getElements(Elements.ElemProp<T> prop) {
        return (IElemSource)this.getLocalElements().get(prop);
    }

    default public int getNumPrims(int types) {
        int count = this.getLocalGeom().getNumPrims(types);
        for (IGeomNode iGeomNode : this.getChildren()) {
            count += iGeomNode.getNumPrims(types);
        }
        return count;
    }

    default public IDOF getDOF() {
        return GeomNodeUtil.getDOF(this);
    }

    default public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    default public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        GeomNodeUtil.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Deprecated
    default public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        return false;
    }

    default public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        GeomNodeUtil.pickBox(this, source, filter, region, isects);
    }

    default public <T> IGeomNode applyElements(Elements.ElemProp<T> prop, BiFunction<Integer, IElemSource<T>, IElemSource<T>> replaceElem) {
        return GeomNodeUtil.applyElements(prop, this, replaceElem);
    }

    default public IGeomNode applyUVElements(String uvSet, BiFunction<Integer, IElemSource<Point2d>, IElemSource<Point2d>> replaceElem) {
        return GeomNodeUtil.applyUVElements(uvSet, this, replaceElem);
    }

    default public IGeomNode initUVElements(IElemSource<Point2d> defuv) {
        return this.applyUniformProp(Elements.UV, Collections.singletonMap("teciuv0x193fa", defuv));
    }

    default public IGeomNode applyDefaultUVElements(IElemSource<Point2d> defuv) {
        return this.applyDefaultUVElements(() -> defuv);
    }

    default public IGeomNode applyDefaultUVElements(Supplier<IElemSource<Point2d>> defuv) {
        return this.applyProp(Elements.UV, (node, uvset) -> {
            if (uvset.isEmpty()) {
                return Collections.singletonMap("teciuv0x193fa", defuv.get());
            }
            ListMap newuvset = new ListMap(uvset);
            newuvset.put("teciuv0x193fa", defuv.get());
            return newuvset;
        });
    }

    default public IGeomNode applyUVElements(TriFunction<String, Integer, IElemSource<Point2d>, IElemSource<Point2d>> replaceElem) {
        return GeomNodeUtil.applyUVElements(this, replaceElem);
    }

    default public <T> IGeomNode applyProp(IPropertySet.Prop<T> prop, BiFunction<IGeomNode, T, T> newVal) {
        return GeomNodeUtil.applyProp(prop, this, newVal);
    }

    default public <T> IGeomNode applyUniformProp(IPropertySet.Prop<T> prop, T newVal) {
        return GeomNodeUtil.applyUniformProp(prop, this, newVal);
    }

    default public <T> IGeomNode prune() {
        return GeomNodeUtil.prune(this);
    }

    default public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        GeomNodeUtil.find(this, test, result);
    }

    default public void getAll(IResult<? super IPrimitive> result) {
        GeomNodeUtil.getAll(this, result);
    }

    default public IGeomNode modify(Function<IGeom, IGeom> geomOp, Function<IPropertySet, IPropertySet> elementOp) {
        return GeomNodeUtil.modify(this, geomOp, elementOp);
    }

    default public Iterator<IGeomNode> flatIterator() {
        return new GeomNodeUtil.FlatIterator(this);
    }

    default public Iterator<IGeom> flatGeomIterator() {
        return new MappedIterator<IGeomNode, IGeom>(this.flatIterator(), n -> n.getLocalGeom());
    }

    default public Iterator<IPropertySet> flatElemIterator() {
        return new MappedIterator<IGeomNode, IPropertySet>(this.flatIterator(), n -> n.getLocalElements());
    }

    default public <T> Iterator<IElemSource<T>> flatElemIterator(Elements.ElemProp<T> type) {
        return new MappedIterator<IGeomNode, IElemSource>(this.flatIterator(), n -> n.getElements(type));
    }

    default public Iterator<Map<String, IElemSource<Point2d>>> flatUVIterator() {
        return new MappedIterator<IGeomNode, Map>(this.flatIterator(), n -> n.getLocalElements().get(Elements.UV));
    }

    default public Iterator<IElemSource<Point2d>> flatUVIterator(String uvSet) {
        return new MappedIterator<IGeomNode, IElemSource>(this.flatIterator(), n -> n.getLocalElements().get(Elements.UV).getOrDefault(uvSet, Elements.NO_UV));
    }

    default public Iterator<ITransform> flatTransformIterator() {
        return new MappedIterator<IGeomNode, ITransform>(this.flatIterator(), n -> n.getLocalTransform());
    }
}

