/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.node;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeGroup;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CachedSupplier;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TriFunction;

public class GeomNodeUtil {
    public static final IGeomNode EMPTY_NODE = new GeomNodeLeaf(TransformUtil.IDENTITY, EmptyGeom.INSTANCE, Elements.NONE);

    public static GeomNodeLeaf newNode(IGeom geom) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(TransformUtil.IDENTITY, geom, Elements.NONE, Collections.emptyList());
    }

    public static GeomNodeLeaf newNode(ITransform xform, IGeom geom) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(xform, geom, Elements.NONE, Collections.emptyList());
    }

    public static GeomNodeLeaf newNode(ITransform xform, IGeom geom, IPropertySet elements) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(xform, geom, elements, Collections.emptyList());
    }

    public static GeomNodeLeaf newNode(IGeom geom, IPropertySet elements) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(TransformUtil.IDENTITY, geom, elements, Collections.emptyList());
    }

    public static GeomNodeGroup newNode(ITransform transform, Collection<? extends IGeomNode> children) {
        return (GeomNodeGroup)GeomNodeUtil.newNode(transform, EmptyGeom.INSTANCE, Elements.NONE, children);
    }

    public static GeomNodeGroup newNode(Collection<? extends IGeomNode> children) {
        return (GeomNodeGroup)GeomNodeUtil.newNode(TransformUtil.IDENTITY, EmptyGeom.INSTANCE, Elements.NONE, children);
    }

    public static IGeomNode newNode(ITransform xform, IGeom geom, IPropertySet elements, Collection<? extends IGeomNode> children) {
        if (children.isEmpty()) {
            if (geom == EmptyGeom.INSTANCE) {
                return EMPTY_NODE;
            }
            return new GeomNodeLeaf(xform, geom, elements);
        }
        return new GeomNodeGroup(xform, geom, elements, children);
    }

    public static IGeomNode flatten(IGeomNode node, int options) {
        boolean applyTransform;
        boolean bl = applyTransform = !GeomNodeUtil.test(options, 2);
        if (node.getChildren().isEmpty() && (!applyTransform || node.getLocalTransform().isIdentity())) {
            return node;
        }
        TransformInfo rootXform = applyTransform ? node.getLocalTransform().getInfo() : TransformUtil.IDENTITY_INFO;
        int geomXformOpts = 1;
        if (node.getChildren().isEmpty()) {
            IGeom newGeom = node.getLocalGeom().transform(rootXform, geomXformOpts);
            IPropertySet newElements = Elements.transform(node.getLocalElements(), rootXform);
            return GeomNodeUtil.newNode(newGeom, newElements);
        }
        ArrayList<IGeom> geomList = new ArrayList<IGeom>();
        ElementsBuilder elementBuilder = new ElementsBuilder();
        GeomNodeUtil.flatten(rootXform, node, geomList, elementBuilder, geomXformOpts);
        IGeom geom = GeomUtil.group(geomList);
        IPropertySet elements = elementBuilder.finish();
        ITransform xform = applyTransform ? TransformUtil.IDENTITY : rootXform.xform;
        return GeomNodeUtil.newNode(xform, geom, elements, Collections.emptyList());
    }

    private static void flatten(TransformInfo ti, IGeomNode node, List<IGeom> geoms, ElementsBuilder elements, int geomXformOpts) {
        IGeom thisGeom = node.getLocalGeom();
        if (thisGeom != EmptyGeom.INSTANCE && (thisGeom = thisGeom.transform(ti, geomXformOpts)) != EmptyGeom.INSTANCE) {
            geoms.add(thisGeom);
            int primCount = thisGeom.getNumPrims(7);
            elements.add(node.getLocalElements(), primCount);
        }
        for (IGeomNode iGeomNode : node.getChildren()) {
            TransformInfo childXform = ti.concatenate(iGeomNode.getLocalTransform());
            GeomNodeUtil.flatten(childXform, iGeomNode, geoms, elements, geomXformOpts);
        }
    }

    public static void pickBox(IGeomNode node, Object source, IIsectFilter filter, ConvexHull region, final IBoxCollector isects) throws CancelledException {
        IBoxCollector xformedIsects;
        UnaryOperator convertGetPointAndNormal;
        ITransform thisXform = node.getLocalTransform();
        if (!thisXform.isIdentity()) {
            try {
                ITransform ixform = thisXform.invert();
                region = region.transform(ixform.toMatrix(false));
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
                return;
            }
            convertGetPointAndNormal = f -> {
                Matrix4d mat = thisXform.toMatrix(false);
                return () -> GeomNodeUtil.lambda$null$161((Supplier)f, mat);
            };
            xformedIsects = new IBoxCollector(){

                @Override
                public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal) throws CancelledException {
                    isects.addFace(obj, primIx, (Supplier)convertGetPointAndNormal.apply(getPointAndNormal));
                }

                @Override
                public void addNonFace(Object obj) throws CancelledException {
                    isects.addNonFace(obj);
                }
            };
        } else {
            convertGetPointAndNormal = f -> f;
            xformedIsects = isects;
        }
        final IElemSource<Elements.Orient> orients = node.getElements(Elements.ORIENT);
        IBoxCollector localIsects = new IBoxCollector(){

            @Override
            public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal) throws CancelledException {
                Supplier<Pair<Point3d, Vector3d>> newPAN = () -> {
                    Pair pair = (Pair)getPointAndNormal.get();
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)orients.getPrimElement(primIx)));
                    if (orient == Elements.Orient.CW) {
                        return new Pair(pair.v1, Util3D.negate((Vector3d)pair.v2));
                    }
                    return pair;
                };
                xformedIsects.addFace(obj, primIx, newPAN);
            }

            @Override
            public void addNonFace(Object obj) throws CancelledException {
                xformedIsects.addNonFace(obj);
            }
        };
        node.getLocalGeom().pickBox(source, filter, region, localIsects);
        Collection<? extends IGeomNode> children = node.getChildren();
        if (children.isEmpty()) {
            return;
        }
        int poffset = node.getLocalGeom().getNumPrims(7);
        for (IGeomNode iGeomNode : children) {
            final int primOffset = poffset;
            IBoxCollector childIsects = new IBoxCollector(){

                @Override
                public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal) throws CancelledException {
                    isects.addFace(obj, primOffset + primIx, (Supplier)convertGetPointAndNormal.apply(getPointAndNormal));
                }

                @Override
                public void addNonFace(Object obj) throws CancelledException {
                    isects.addNonFace(obj);
                }
            };
            GeomNodeUtil.pickBox(iGeomNode, source, filter, region, childIsects);
            poffset += iGeomNode.getNumPrims(7);
        }
    }

    public static void pickPoints(IGeomNode node, IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        IIsectCollector newCollector;
        ITransform thisXform = node.getLocalTransform();
        if (!thisXform.isIdentity()) {
            IIsectCollector xformCollector;
            Matrix4d ixform;
            try {
                ixform = thisXform.invert().toMatrix(false);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
                return;
            }
            rayBegin = Util3D.xform(ixform, rayBegin);
            rayEnd = Util3D.xform(ixform, rayEnd);
            rayDirN = Util3D.xform(ixform, rayDirN);
            rayDirN.normalize();
            final TransformInfo xform = node.getLocalTransform().getInfo();
            final Matrix4d mat = xform.getMatrix();
            final IIsectCollector baseIsects = isects;
            isects = xformCollector = new IIsectCollector(){

                @Override
                public void addNonFace(Object obj, Point3d p, GeomType type) {
                    p = Util3D.xform(mat, p);
                    baseIsects.addNonFace(obj, p, type);
                }

                @Override
                public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                    p = Util3D.xform(mat, p);
                    Supplier<Vector3d> norm = () -> Util3D.xform(mat, (Vector3d)getNormal.get());
                    Supplier<IFace> prim = getPrim == null ? null : () -> ((IFace)getPrim.get()).transform(xform, 0);
                    baseIsects.addFace(obj, p, primIx, prim, norm);
                }

                @Override
                public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                    p = Util3D.xform(mat, p);
                    prim = prim.transform(xform, 0);
                    baseIsects.addInfinite(obj, p, type, prim);
                }

                @Override
                public TaskProgress getProgress() {
                    return baseIsects.getProgress();
                }
            };
            tester = new XformTester(tester, xform);
        }
        final IElemSource<Elements.Orient> orients = node.getElements(Elements.ORIENT);
        final IIsectCollector baseIsects = isects;
        isects = newCollector = new IIsectCollector(){

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type) {
                baseIsects.addNonFace(obj, p, type);
            }

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                Supplier<Vector3d> norm = () -> {
                    Vector3d n2 = (Vector3d)getNormal.get();
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)orients.getPrimElement(primIx)));
                    if (orient == Elements.Orient.CW) {
                        n2 = Util3D.negate(n2);
                    }
                    return n2;
                };
                CachedSupplier<IFace> prim = getPrim == null ? null : () -> {
                    IFace face = (IFace)getPrim.get();
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)orients.getPrimElement(primIx)));
                    if (orient == Elements.Orient.CW) {
                        face = face.flipOrient();
                    }
                    return face;
                };
                prim = prim == null ? null : new CachedSupplier<IFace>(prim);
                baseIsects.addFace(obj, p, primIx, prim, norm);
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                baseIsects.addInfinite(obj, p, type, prim);
            }

            @Override
            public TaskProgress getProgress() {
                return baseIsects.getProgress();
            }
        };
        node.getLocalGeom().pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        Collection<? extends IGeomNode> children = node.getChildren();
        if (children.isEmpty()) {
            return;
        }
        int poffset = node.getLocalGeom().getNumPrims(7);
        for (IGeomNode iGeomNode : children) {
            final IIsectCollector childIsects = isects;
            final int primOffset = poffset;
            IIsectCollector newIsects = new IIsectCollector(){

                @Override
                public void addNonFace(Object obj, Point3d p, GeomType type) {
                    childIsects.addNonFace(obj, p, type);
                }

                @Override
                public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                    childIsects.addFace(obj, p, primOffset + primIx, getPrim, getNormal);
                }

                @Override
                public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                    childIsects.addInfinite(obj, p, type, prim);
                }

                @Override
                public TaskProgress getProgress() {
                    return childIsects.getProgress();
                }
            };
            GeomNodeUtil.pickPoints(iGeomNode, newIsects, filter, source, rayBegin, rayEnd, rayDirN, tester);
            poffset += iGeomNode.getNumPrims(7);
        }
    }

    public static IDOF getDOF(IGeomNode node) {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        GeomNodeUtil.getDOF(node, dofs);
        return IDOF.group(dofs);
    }

    private static void getDOF(IGeomNode node, Set<IDOF> dofs) {
        dofs.add(node.getLocalGeom().getDOF());
        for (IGeomNode iGeomNode : node.getChildren()) {
            GeomNodeUtil.getDOF(iGeomNode, dofs);
        }
    }

    public static <T> IGeomNode applyUniformProp(IPropertySet.Prop<T> prop, IGeomNode node, T newVal) {
        BiFunction<IGeomNode, Object, Object> nfunc = (n, oldVal) -> newVal;
        return GeomNodeUtil.applyProp(prop, node, nfunc);
    }

    public static <T> IGeomNode applyProp(IPropertySet.Prop<T> prop, IGeomNode node, BiFunction<IGeomNode, T, T> newVal) {
        boolean childrenModified;
        T oval;
        IGeomNode nval;
        IPropertySet elements;
        IPropertySet newElements = elements = node.getLocalElements();
        if (node.getLocalGeom() != EmptyGeom.INSTANCE && !Objects.equals(nval = newVal.apply(node, (IGeomNode)(oval = newElements.get(prop))), oval)) {
            newElements = Elements.copyOf(node.getLocalElements());
            newElements.setIfNotDefault(prop, nval);
            newElements = Elements.finalizeElements(newElements);
        }
        boolean elementsModified = newElements != elements;
        elements = newElements;
        Collection<? extends IGeomNode> children = node.getChildren();
        ArrayList<? extends IGeomNode> newChildren = null;
        int ix = 0;
        for (IGeomNode iGeomNode : node.getChildren()) {
            IGeomNode newChild = GeomNodeUtil.applyProp(prop, iGeomNode, newVal);
            if (newChild != iGeomNode) {
                if (newChildren == null) {
                    newChildren = new ArrayList<IGeomNode>(children);
                }
                newChildren.set(ix, newChild);
            }
            ++ix;
        }
        boolean bl = childrenModified = newChildren != null;
        if (childrenModified) {
            children = newChildren;
        }
        if (!elementsModified && !childrenModified) {
            return node;
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), node.getLocalGeom(), elements, children);
    }

    public static <T> IGeomNode applyElements(Elements.ElemProp<T> prop, IGeomNode node, BiFunction<Integer, IElemSource<T>, IElemSource<T>> replaceElem) {
        return GeomNodeUtil.applyElements((IElemSource)prop.defVal, n -> (IElemSource)n.getLocalElements().get(prop), (n, elements, newVal) -> elements.setIfNotDefault(prop, newVal), node, replaceElem);
    }

    public static IGeomNode applyUVElements(IGeomNode node, TriFunction<String, Integer, IElemSource<Point2d>, IElemSource<Point2d>> replaceElem) {
        int[] foffset = new int[]{0};
        return GeomNodeUtil.applyProp(Elements.UV, node, (n, uvsets) -> {
            ListMap<String, IElemSource<Point2d>> newUVSets = null;
            int nprims = n.getLocalGeom().getNumPrims(7);
            for (Map.Entry entry : uvsets.entrySet()) {
                String uvset = (String)entry.getKey();
                IElemSource<Point2d> newuv = Elements.replaceElements(nprims, (IElemSource)entry.getValue(), Elements.NO_UV, (i, oe) -> (IElemSource)replaceElem.apply(uvset, foffset[0] + i, (IElemSource<Point2d>)oe));
                if (newuv == entry.getValue()) continue;
                if (newUVSets == null) {
                    newUVSets = new ListMap<String, IElemSource<Point2d>>((Map<String, IElemSource<Point2d>>)uvsets);
                }
                newUVSets.put(uvset, newuv);
            }
            nArray[0] = foffset[0] + nprims;
            return newUVSets == null ? uvsets : newUVSets;
        });
    }

    public static IGeomNode applyUVElements(String uvSet, IGeomNode node, BiFunction<Integer, IElemSource<Point2d>, IElemSource<Point2d>> replaceElem) {
        return GeomNodeUtil.applyElements(Elements.NO_UV, n -> {
            IElemSource<Point2d> elems = n.getLocalElements().get(Elements.UV).get(uvSet);
            return elems != null ? elems : Elements.NO_UV;
        }, (n, elements, newVal) -> {
            ListMap<String, IElemSource<Point2d>> newMap = new ListMap<String, IElemSource<Point2d>>(n.getLocalElements().get(Elements.UV));
            if (newVal != Elements.NO_UV) {
                newMap.put(uvSet, (IElemSource<Point2d>)newVal);
            } else {
                newMap.remove(uvSet);
            }
            elements.setIfNotDefault(Elements.UV, newMap);
        }, node, replaceElem);
    }

    private static <T> IGeomNode applyElements(IElemSource<T> defVal, Function<IGeomNode, IElemSource<T>> getter, TriConsumer<IGeomNode, IPropertySet, IElemSource<T>> setter, IGeomNode node, BiFunction<Integer, IElemSource<T>, IElemSource<T>> replaceElem) {
        boolean childrenModified;
        IElemSource<IGeomNode> oldElSrc;
        IElemSource<IGeomNode> newElSrc;
        IPropertySet elements = node.getLocalElements();
        boolean elementsModified = false;
        IGeom geom = node.getLocalGeom();
        int nprims = geom.getNumPrims(7);
        if (nprims > 0 && (newElSrc = Elements.replaceElements(nprims, oldElSrc = getter.apply(node), defVal, replaceElem)) != oldElSrc) {
            elementsModified = true;
            elements = GeomNodeUtil.applyElementsVal(setter, node, elements, newElSrc);
        }
        int offset = nprims;
        ArrayList<IGeomNode> newChildren = null;
        int cix = 0;
        Collection<? extends IGeomNode> children = node.getChildren();
        for (IGeomNode iGeomNode : children) {
            int foffset;
            IGeomNode newChild = GeomNodeUtil.applyElements(defVal, getter, setter, iGeomNode, (arg_0, arg_1) -> GeomNodeUtil.lambda$applyElements$176(replaceElem, foffset = offset, arg_0, arg_1));
            if (newChild != iGeomNode || newChildren != null) {
                if (newChildren == null) {
                    newChildren = new ArrayList<IGeomNode>(children.size());
                    Iterator<? extends IGeomNode> childit = children.iterator();
                    for (int m = 0; m < cix; ++m) {
                        newChildren.add(childit.next());
                    }
                }
                newChildren.add(newChild);
            }
            offset += iGeomNode.getNumPrims(7);
            ++cix;
        }
        boolean bl = childrenModified = newChildren != null;
        if (!elementsModified && !childrenModified) {
            return node;
        }
        if (childrenModified) {
            children = newChildren;
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), node.getLocalGeom(), elements, children);
    }

    private static <T> IPropertySet applyElementsVal(TriConsumer<IGeomNode, IPropertySet, T> setter, IGeomNode node, IPropertySet elements, T newVal) {
        elements = Elements.copyOf(elements);
        setter.accept(node, elements, newVal);
        return Elements.finalizeElements(elements);
    }

    public static IGeomNode prune(IGeomNode node) {
        if (node == EMPTY_NODE) {
            return node;
        }
        boolean modified = false;
        ArrayList<IGeomNode> prunedChildren = new ArrayList<IGeomNode>(node.getChildren().size());
        for (IGeomNode iGeomNode : node.getChildren()) {
            IGeomNode prunedChild = GeomNodeUtil.prune(iGeomNode);
            if (prunedChild == EMPTY_NODE) {
                modified = true;
                continue;
            }
            modified |= prunedChild != iGeomNode;
            prunedChildren.add(prunedChild);
        }
        if (!modified) {
            return node;
        }
        if (node.getLocalGeom() == EmptyGeom.INSTANCE && prunedChildren.size() == 1) {
            TransformInfo ti = node.getLocalTransform().getInfo();
            IGeomNode iGeomNode = (IGeomNode)prunedChildren.get(0);
            return iGeomNode.transform(ti);
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), node.getLocalGeom(), node.getLocalElements(), prunedChildren);
    }

    public static void find(IGeomNode node, ITest<AABox> test, IResult<? super IPrimitive> result) {
        ITransform thisXform = node.getLocalTransform();
        if (!thisXform.isIdentity()) {
            TransformInfo mat = node.getLocalTransform().getInfo();
            test = new XformTester(test, mat);
            result = new XformResult(result, mat);
        }
        node.getLocalGeom().find(test, result);
        for (IGeomNode iGeomNode : node.getChildren()) {
            iGeomNode.find(test, result);
        }
    }

    public static void getAll(IGeomNode node, IResult<? super IPrimitive> result) {
        node.flatten().getLocalGeom().getAll(result);
    }

    public static IGeomNode modify(IGeomNode node, Function<IGeom, IGeom> geomOp, Function<IPropertySet, IPropertySet> elementOp) {
        IGeom oldGeom = node.getLocalGeom();
        IPropertySet oldElem = node.getLocalElements();
        IGeom newGeom = geomOp.apply(oldGeom);
        IPropertySet newElem = elementOp.apply(oldElem);
        Collection<? extends IGeomNode> oldChildren = node.getChildren();
        ArrayList<IGeomNode> newChildren = null;
        int ix = 0;
        for (IGeomNode iGeomNode : oldChildren) {
            IGeomNode newChild;
            if (iGeomNode != (newChild = iGeomNode.modify(geomOp, elementOp)) || newChildren != null) {
                if (newChildren == null) {
                    newChildren = new ArrayList<IGeomNode>(oldChildren.size());
                    Iterator<? extends IGeomNode> childit = oldChildren.iterator();
                    for (int m = 0; m < ix; ++m) {
                        newChildren.add(childit.next());
                    }
                }
                newChildren.add(newChild);
            }
            ++ix;
        }
        if (oldGeom == newGeom && oldElem == newElem && newChildren == null) {
            return node;
        }
        if (newChildren != null) {
            oldChildren = newChildren;
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), newGeom, newElem, oldChildren);
    }

    public static List<Pair<TransformInfo, IGeom>> quickFlatten(IGeomNode node, int options) {
        ArrayList<Pair<TransformInfo, IGeom>> result = new ArrayList<Pair<TransformInfo, IGeom>>();
        GeomNodeUtil.quickFlatten(node, options, result);
        return result;
    }

    public static void quickFlatten(IGeomNode node, int options, List<Pair<TransformInfo, IGeom>> result) {
        GeomNodeUtil.quickFlatten(TransformUtil.IDENTITY, node, options, result);
    }

    private static void quickFlatten(ITransform parentXform, IGeomNode node, int options, List<Pair<TransformInfo, IGeom>> result) {
        ITransform xform = parentXform.concatenate(node.getLocalTransform());
        TransformInfo ti = xform.getInfo();
        if (GeomNodeUtil.test(options, 1) && node.getLocalGeom() instanceof GeomGroup) {
            for (IGeom iGeom : GeomUtil.flatten(node.getLocalGeom())) {
                result.add(new Pair<TransformInfo, IGeom>(ti, iGeom));
            }
        } else {
            result.add(new Pair<TransformInfo, IGeom>(ti, node.getLocalGeom()));
        }
        for (IGeomNode iGeomNode : node.getChildren()) {
            GeomNodeUtil.quickFlatten(xform, iGeomNode, options, result);
        }
    }

    public static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static IGeomNode bakeIfRecommended(TransformInfo parentXform, IGeomNode node) {
        if (node.isLeaf() && (node.getLocalGeom().getRetainingDOF() != IDOF.FREE || node.getLocalGeom().getBakeTransform() || node.getLocalTransform().isIdentity())) {
            TransformInfo wti = parentXform.concatenate(node.getLocalTransform());
            if (wti.isIdentity()) {
                return node;
            }
            IGeom lgeom = node.getLocalGeom();
            if (wti.isAccepted(lgeom.getRetainingDOF())) {
                IGeom newGeom = node.getLocalGeom().transform(wti, 1);
                IPropertySet newElem = Elements.transform(node.getLocalElements(), wti);
                return GeomNodeUtil.newNode(newGeom, newElem);
            }
        }
        return node;
    }

    private static /* synthetic */ IElemSource lambda$applyElements$176(BiFunction biFunction, int n, Integer i, IElemSource oel) {
        return (IElemSource)biFunction.apply(n + i, oel);
    }

    private static /* synthetic */ Pair lambda$null$161(Supplier supplier, Matrix4d matrix4d) {
        Pair pair = (Pair)supplier.get();
        return new Pair<Point3d, Vector3d>(Util3D.xform(matrix4d, (Point3d)pair.v1), Util3D.xform(matrix4d, (Vector3d)pair.v2));
    }

    protected static class FlatIterator
    implements Iterator<IGeomNode> {
        private final IGeomNode node;
        private Iterator<? extends IGeomNode> childIt;
        private Iterator<? extends IGeomNode> childItemIt;

        public FlatIterator(IGeomNode node) {
            this.node = node;
            this.childIt = null;
            this.childItemIt = null;
        }

        @Override
        public boolean hasNext() {
            return this.childItemIt == null || this.childItemIt.hasNext();
        }

        @Override
        public IGeomNode next() {
            if (this.childIt == null) {
                IGeomNode next = this.node;
                this.childIt = this.node.getChildren().iterator();
                if (this.childIt.hasNext()) {
                    IGeomNode child = this.childIt.next();
                    this.childItemIt = child.flatIterator();
                    assert (this.childItemIt.hasNext());
                } else {
                    this.childItemIt = Collections.emptyIterator();
                }
                return next;
            }
            IGeomNode next = this.childItemIt.next();
            if (!this.childItemIt.hasNext() && this.childIt.hasNext()) {
                IGeomNode nextChild = this.childIt.next();
                this.childItemIt = nextChild.flatIterator();
                assert (this.childItemIt.hasNext());
            }
            return next;
        }
    }

    private static class XformResult
    implements IResult<IPrimitive> {
        private final TransformInfo d_xform;
        private final IResult<? super IPrimitive> d_base;

        public XformResult(IResult<? super IPrimitive> base, TransformInfo xform) {
            this.d_xform = xform;
            this.d_base = base;
        }

        @Override
        public void mark(IPrimitive obj, Containment ctmt) {
            obj = obj.transform(this.d_xform, 0);
            this.d_base.mark(obj, ctmt);
        }
    }

    private static class XformTester
    implements ITest<AABox> {
        private final ITest<AABox> base;
        private final TransformInfo xform;

        public XformTester(ITest<AABox> base, TransformInfo xform) {
            this.base = base;
            this.xform = xform;
        }

        @Override
        public Containment test(AABox bb) {
            AABox xformbb = new AABox(bb);
            xformbb.transformEq(this.xform.getMatrix());
            return this.base.test(xformbb);
        }
    }
}

