/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementBuilders;
import thunderheadeng.geometry.objs.elem.ElementFlattened;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LWPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class Elements {
    public static final IPropertySet NONE = new DefElements();
    public static final String DEFAULT_UVSET_NAME = "teciuv0x193fa";
    public static final IElemSource<Point2d> NO_UV = new EmptyElem<Point2d>(new Point2d(0.0, 0.0));
    public static final IElemSource<Vector3d> NO_NORMAL = new EmptyElem<Vector3d>(new Vector3d(0.0, 0.0, 1.0));
    public static final IElemSource<Boolean> ALL_CREASE = new UniformDefault<Boolean>(Boolean.TRUE);
    public static final IElemSource<Boolean> NO_CREASE = new UniformDefault<Boolean>(Boolean.FALSE);
    public static final IElemSource<Orient> CCW = new UniformDefault<Orient>((Object)Orient.CCW);
    public static final IElemSource<Orient> CW = new UniformDefault<Orient>((Object)Orient.CW);
    public static final ElemProp<Vector3d> NORMAL = new ElemProp<Vector3d>(1, Vector3d.class, NO_NORMAL);
    public static final ElemProp<Boolean> CREASE = new ElemProp<Boolean>(2, Boolean.class, ALL_CREASE);
    public static final ElemProp<Orient> ORIENT = new ElemProp<Orient>(3, Orient.class, CCW);
    public static final ElemProp<Point2d> UV_DIFFUSE = new ElemProp<Point2d>(4, Point2d.class, NO_UV);
    public static final IPropertySet.Prop<Map<String, IElemSource<Point2d>>> UV = new IPropertySet.Prop(5, Collections.emptyMap());
    public static final List<ElemProp<?>> FIXED = Arrays.asList(NORMAL, CREASE, ORIENT);
    private static final List<IPropertySet.Prop<?>> ALL = new ArrayList();
    private static final double CREASE_FROM_NORMAL_DOT_TOL;

    public static IPropertySet newElements(IElemSource<Point2d> uv, IElemSource<Vector3d> normal, IElemSource<Boolean> crease, IElemSource<Orient> orient) {
        IPropertySet result = Elements.newElements();
        if (uv != null) {
            result.setIfNotDefault(UV, Elements.newUVMap("uvset", uv));
        }
        if (normal != null) {
            result.setIfNotDefault(NORMAL, normal);
        }
        if (crease != null) {
            result.setIfNotDefault(CREASE, crease);
        }
        if (orient != null) {
            result.setIfNotDefault(ORIENT, orient);
        }
        return Elements.finalizeElements(result);
    }

    private static ListMap<String, IElemSource<Point2d>> newUVMap(Object ... args) {
        assert (args.length % 2 == 0);
        ListMap<String, IElemSource<Point2d>> map = new ListMap<String, IElemSource<Point2d>>();
        for (int m = 0; m < args.length; m += 2) {
            map.put((String)args[m], (IElemSource)args[m + 1]);
        }
        return map;
    }

    public static IPropertySet newElements(Object ... args) {
        return Elements.newElements(Arrays.asList(args));
    }

    public static IPropertySet newElements(List<?> args) {
        assert (args.size() % 2 == 0);
        IPropertySet result = Elements.newElements();
        ListMap<String, IElemSource> uvMap = null;
        for (int m = 0; m < args.size(); m += 2) {
            Object key = args.get(m);
            Object val = args.get(m + 1);
            if (key instanceof String) {
                if (uvMap == null) {
                    uvMap = new ListMap<String, IElemSource>();
                }
                uvMap.put((String)key, (IElemSource)val);
                continue;
            }
            IPropertySet.Prop prop = (IPropertySet.Prop)args.get(m);
            result.setIfNotDefault(prop, val);
        }
        if (uvMap != null) {
            result.setIfNotDefault(UV, uvMap);
        }
        return Elements.finalizeElements(result);
    }

    public static IPropertySet fixLegacy(IPropertySet elems) {
        if (!elems.isDefined(UV_DIFFUSE)) {
            return elems;
        }
        IElemSource duv = (IElemSource)elems.get(UV_DIFFUSE);
        elems = Elements.copyOf(elems);
        elems.remove(UV_DIFFUSE);
        ListMap<String, IElemSource<Point2d>> uv = new ListMap<String, IElemSource<Point2d>>(elems.get(UV));
        uv.put("uvset", duv);
        elems.setIfNotDefault(UV, uv);
        return Elements.finalizeElements(elems);
    }

    public static IPropertySet newElements() {
        return new LWPropertySet();
    }

    public static IPropertySet makeMutable(IPropertySet elements) {
        if (elements == NONE) {
            return Elements.newElements();
        }
        return elements;
    }

    public static IPropertySet copyOf(IPropertySet elements) {
        IPropertySet newElementSet = Elements.newElements();
        newElementSet.merge(elements, ALL);
        return newElementSet;
    }

    public static IPropertySet finalizeElements(IPropertySet elements) {
        if (elements instanceof PropertySet && ((PropertySet)elements).size() == 0) {
            return NONE;
        }
        for (IPropertySet.Prop<?> prop : ALL) {
            if (elements.get(prop) == prop.defVal) continue;
            return elements;
        }
        return NONE;
    }

    private static boolean normalsEqual(Vector3d v1, Vector3d v2) {
        return v1.dot(v2) >= CREASE_FROM_NORMAL_DOT_TOL;
    }

    public static IElemSource<Vector3d> generateNormals(IGeom geom, IElemSource<Orient> faceOrients, boolean smooth) {
        int nfaces = Elements.getAllFaceCount(geom);
        if (nfaces == 0) {
            return NO_NORMAL;
        }
        List<IFace> faces = GeomUtil.explode(geom, IFace.class);
        if (smooth) {
            LinkedHashMap<Point3d, Pair> normals = new LinkedHashMap<Point3d, Pair>();
            Function<Point3d, Pair> newNormal = p -> new Pair<Integer, Vector3d>(normals.size(), new Vector3d());
            int vertsPerPrim = 0;
            for (int m = 0; m < faces.size(); ++m) {
                IFace face = faces.get(m);
                int nPolyVerts = -1;
                if (face instanceof IPolygon) {
                    IPolygon poly = (IPolygon)face;
                    nPolyVerts = PolyUtil.getNumVerts(poly);
                    boolean ccw = faceOrients.getPrimElement(m) == Orient.CCW;
                    Vector3d normal = poly.getNormal(ccw);
                    for (Point3d vert : PolyUtil.getAllVerts(poly, false)) {
                        ((Vector3d)normals.computeIfAbsent(vert, newNormal).v2).add((Tuple3d)normal);
                    }
                }
                if (vertsPerPrim == 0) {
                    vertsPerPrim = nPolyVerts;
                    continue;
                }
                if (vertsPerPrim == nPolyVerts) continue;
                vertsPerPrim = -1;
            }
            for (Pair normal : normals.values()) {
                ((Vector3d)normal.v2).normalize();
            }
            if (normals.isEmpty()) {
                return NO_NORMAL;
            }
            Vector3d n1 = (Vector3d)((Pair)normals.values().iterator().next()).v2;
            if (normals.values().stream().allMatch(p -> Elements.normalsEqual((Vector3d)p.v2, n1))) {
                return new ElementUniform<Vector3d>(n1);
            }
            if (vertsPerPrim > 0) {
                Vector3d[] normalArr = new Vector3d[normals.size()];
                int ix = 0;
                for (Pair normal : normals.values()) {
                    normalArr[ix++] = (Vector3d)normal.v2;
                }
                if (theUtil.isUniform(normalArr)) {
                    return new ElementUniform<Vector3d>(normalArr[0]);
                }
                int[] indices = new int[nfaces * vertsPerPrim];
                ix = 0;
                for (IFace face : faces) {
                    assert (face instanceof IPolygon);
                    IPolygon poly = (IPolygon)face;
                    for (Point3d vert : PolyUtil.getAllVerts(poly, false)) {
                        Pair pair = (Pair)normals.get(vert);
                        indices[ix++] = (Integer)pair.v1;
                    }
                }
                return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, normalArr, indices, vertsPerPrim);
            }
            ElementBuilder<Vector3d> builder = ElementBuilders.normal();
            for (IFace face : faces) {
                if (face instanceof IPolygon) {
                    IPolygon poly = (IPolygon)face;
                    Point3d[] pverts = PolyUtil.getAllVerts(poly, false);
                    Vector3d[] fnorms = new Vector3d[pverts.length];
                    for (int m = 0; m < pverts.length; ++m) {
                        fnorms[m] = (Vector3d)((Pair)normals.get((Object)pverts[m])).v2;
                    }
                    IElemSource<Vector3d> fsrc = theUtil.isUniform(fnorms) ? new ElementUniform<Vector3d>(fnorms[0]) : new ElementPoly<Vector3d>(fnorms);
                    builder.add(fsrc, 1);
                    continue;
                }
                builder.add(NO_NORMAL, 1);
            }
            return builder.finish();
        }
        Vector3d[] normals = new Vector3d[nfaces];
        int vertsPerPrim = 0;
        int ix = 0;
        for (int m = 0; m < faces.size(); ++m) {
            IFace face = faces.get(m);
            int nPolyVerts = -1;
            if (face instanceof IPolygon) {
                IPolygon poly = (IPolygon)face;
                nPolyVerts = PolyUtil.getNumVerts(poly);
                boolean ccw = faceOrients.getPrimElement(m) == Orient.CCW;
                normals[ix] = poly.getNormal(ccw);
            } else {
                normals[ix] = GeomConstants.VEC3D_ZPOS;
            }
            if (vertsPerPrim == 0) {
                vertsPerPrim = nPolyVerts;
            } else if (vertsPerPrim != nPolyVerts) {
                vertsPerPrim = -1;
            }
            ++ix;
        }
        Vector3d n1 = normals[0];
        if (theUtil.isUniform(normals, Elements::normalsEqual)) {
            return new ElementUniform<Vector3d>(n1);
        }
        if (vertsPerPrim > 0) {
            return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM, normals, vertsPerPrim);
        }
        ElementBuilder<Vector3d> builder = ElementBuilders.normal();
        for (int m = 0; m < nfaces; ++m) {
            builder.add(new ElementUniform<Vector3d>(normals[m]), 1);
        }
        return builder.finish();
    }

    public static IElemSource<Vector3d> generateNormals(Mesh mesh, IElemSource<Orient> faceOrients, boolean smooth) {
        return Elements.generateNormals(mesh, faceOrients, smooth ? Math.PI : 0.0);
    }

    public static IElemSource<Vector3d> generateNormals(Mesh mesh, IElemSource<Orient> faceOrients, double creaseAngle) {
        boolean smooth;
        if (!Elements.isFaceType(mesh.primtype)) {
            return NO_NORMAL;
        }
        int vertsPerPrim = Mesh.getNumVertsPerElement(mesh.primtype);
        boolean faceted = creaseAngle == 0.0;
        boolean bl = smooth = creaseAngle >= Math.PI;
        if (faceted || smooth) {
            int numNorms = faceted ? mesh.indices.length / vertsPerPrim : mesh.vertices.length;
            Vector3d[] normals = new Vector3d[numNorms];
            if (smooth) {
                for (int m = 0; m < mesh.vertices.length; ++m) {
                    normals[m] = new Vector3d(0.0, 0.0, 0.0);
                }
            }
            Point3d[] buffer = new Point3d[vertsPerPrim];
            List<Point3d> plist = Arrays.asList(buffer);
            int m = 0;
            int pix = 0;
            while (m < mesh.indices.length) {
                for (int n = 0; n < vertsPerPrim; ++n) {
                    buffer[n] = mesh.vertices[mesh.indices[m + n]];
                }
                boolean ccw = faceOrients.getPrimElement(pix) == Orient.CCW;
                Vector3d normal = Util3D.simplePolygonNormal(plist, ccw);
                if (normal == null) {
                    normal = GeomConstants.VEC3D_ZPOS;
                }
                if (smooth) {
                    for (int n = 0; n < vertsPerPrim; ++n) {
                        normals[mesh.indices[m + n]].add((Tuple3d)normal);
                    }
                } else {
                    normals[m / vertsPerPrim] = normal;
                }
                m += vertsPerPrim;
                ++pix;
            }
            if (smooth) {
                for (m = 0; m < mesh.vertices.length; ++m) {
                    normals[m].normalize();
                }
                return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, normals, mesh.indices, vertsPerPrim);
            }
            return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM, normals, ElementMesh.DIRECT, vertsPerPrim);
        }
        Vector3d[] faceNormals = new Vector3d[mesh.indices.length / vertsPerPrim];
        Point3d[] buffer = new Point3d[vertsPerPrim];
        List<Point3d> plist = Arrays.asList(buffer);
        int m = 0;
        int pix = 0;
        while (m < mesh.indices.length) {
            for (int n = 0; n < vertsPerPrim; ++n) {
                int vix = mesh.indices[m + n];
                buffer[n] = mesh.vertices[vix];
            }
            boolean ccw = faceOrients.getPrimElement(pix) == Orient.CCW;
            Vector3d normal = Util3D.simplePolygonNormal(plist, ccw);
            if (normal == null) {
                normal = GeomConstants.VEC3D_ZPOS;
            }
            faceNormals[pix] = normal;
            m += vertsPerPrim;
            ++pix;
        }
        double minDot = Math.cos(creaseAngle);
        List[] allVertNormals = new List[mesh.vertices.length];
        NormalCount[] whichNormals = new NormalCount[mesh.indices.length];
        int m2 = 0;
        int pix2 = 0;
        while (m2 < mesh.indices.length) {
            Vector3d faceNormal = faceNormals[pix2];
            for (int n = 0; n < vertsPerPrim; ++n) {
                int vix = mesh.indices[m2 + n];
                ArrayList<NormalCount> vertNormals = allVertNormals[vix];
                if (vertNormals == null) {
                    allVertNormals[vix] = vertNormals = new ArrayList<NormalCount>(5);
                    NormalCount count = new NormalCount(faceNormal);
                    vertNormals.add(count);
                    whichNormals[m2 + n] = count;
                    continue;
                }
                NormalCount bestNormal = null;
                double bestDot = minDot;
                for (NormalCount adjNormal : vertNormals) {
                    double dot = adjNormal.protoNormal.dot(faceNormal);
                    if (!theUtil.ge(dot, bestDot, 1.0E-6)) continue;
                    adjNormal.normalSum.add((Tuple3d)faceNormal);
                    ++adjNormal.count;
                    bestNormal = adjNormal;
                    bestDot = dot;
                }
                if (bestNormal == null) {
                    bestNormal = new NormalCount(faceNormal);
                    vertNormals.add(bestNormal);
                }
                whichNormals[m2 + n] = bestNormal;
            }
            m2 += vertsPerPrim;
            ++pix2;
        }
        for (List vertNormals : allVertNormals) {
            for (NormalCount n : vertNormals) {
                n.normalSum.normalize();
            }
        }
        Vector3d[] normals = new Vector3d[mesh.indices.length];
        for (int m3 = 0; m3 < mesh.indices.length; ++m3) {
            normals[m3] = whichNormals[m3].normalSum;
        }
        return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, normals, vertsPerPrim);
    }

    private static boolean isFaceType(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static IElemSource<Orient> fixFaceOrients(Mesh mesh, IElemSource<Orient> faceOrients, IPropsSrc props) {
        if (!Elements.isFaceType(mesh.primtype)) {
            return faceOrients;
        }
        int nfaces = mesh.getNumPrims(1);
        BitSet closed = new BitSet(nfaces);
        ArrayDeque<Integer> open = new ArrayDeque<Integer>();
        Map<IxEdge, List<int[]>> faceAdjancency = Elements.getFaceAdjacency(mesh);
        int nvertsPerPrim = mesh.getNumVertsPerPrim();
        ElementMesh<Orient> orientMesh = faceOrients.generate(Orient.class, mesh.getPrimitives(), faceOrients, props, nvertsPerPrim, false);
        Orient[] result = (Orient[])theUtil.toArray(orientMesh.subList(0, nfaces));
        int[] f1edge = new int[2];
        int[] f2edge = new int[2];
        TriIntAndObjConsumer<int[]> getEdge = (fix, foffset, eix, edge) -> {
            int e1 = mesh.indices[foffset + eix];
            int e2 = mesh.indices[foffset + (eix + 1) % nvertsPerPrim];
            Orient orient = result[fix];
            if (orient != Orient.CCW) {
                int t = e1;
                e1 = e2;
                e2 = t;
            }
            edge[0] = e1;
            edge[1] = e2;
        };
        while (closed.cardinality() != nfaces) {
            int seed = closed.nextClearBit(0);
            open.push(seed);
            closed.set(seed);
            while (!open.isEmpty()) {
                int face = (Integer)open.pop();
                int f1offset = face * nvertsPerPrim;
                for (int m = 0; m < nvertsPerPrim; ++m) {
                    getEdge.accept(face, f1offset, m, f1edge);
                    IxEdge edge2 = new IxEdge(f1edge[0], f1edge[1]);
                    List<int[]> adjFaces = faceAdjancency.get(edge2);
                    assert (adjFaces != null);
                    if (adjFaces.size() > 2) continue;
                    for (int[] adjFace : adjFaces) {
                        int face2 = adjFace[0];
                        if (face2 == face || closed.get(face2)) continue;
                        closed.set(face2);
                        int f2offset = face2 * nvertsPerPrim;
                        getEdge.accept(face2, f2offset, adjFace[1], f2edge);
                        if (f1edge[0] == f2edge[0] && f1edge[1] == f2edge[1]) {
                            result[face2] = result[face2].flip();
                        }
                        open.push(face2);
                    }
                }
            }
        }
        if (theUtil.isUniform(result)) {
            return new ElementUniform<Orient>(result[0]);
        }
        return new ElementMesh<Orient>(ElementMesh.Mapping.PER_PRIM, result, nvertsPerPrim);
    }

    private static Map<IxEdge, List<int[]>> getFaceAdjacency(Mesh mesh) {
        HashMap<IxEdge, List<int[]>> adjFaces = new HashMap<IxEdge, List<int[]>>();
        Function<IxEdge, List> newList = i -> new ArrayList();
        int vertsPerPrim = mesh.getNumVertsPerPrim();
        int m = 0;
        int pix = 0;
        while (m < mesh.indices.length) {
            int n = 0;
            while (n < vertsPerPrim) {
                int i1 = mesh.indices[m + n];
                int i2 = mesh.indices[m + (n + 1) % vertsPerPrim];
                IxEdge ie = new IxEdge(i1, i2);
                List faces = adjFaces.computeIfAbsent(ie, newList);
                faces.add(new int[]{pix, n++});
            }
            m += vertsPerPrim;
            ++pix;
        }
        return adjFaces;
    }

    public static IElemSource<Boolean> generateCreasesFromNormals(Mesh mesh, IPropsSrc props, IElemSource<Vector3d> normalSrc, IElemSource<Orient> faceOrients) {
        ElementMesh<Vector3d> normals = normalSrc.generate(Vector3d.class, mesh, faceOrients, props);
        if (normals == null) {
            return ALL_CREASE;
        }
        Map<IxEdge, List<int[]>> adjFaces = Elements.getFaceAdjacency(mesh);
        int vertsPerPrim = mesh.getNumVertsPerPrim();
        Boolean[] creases = new Boolean[mesh.indices.length];
        int genCount = 0;
        int creaseCount = 0;
        for (int m = 0; m < mesh.indices.length; m += vertsPerPrim) {
            for (int n = 0; n < vertsPerPrim; ++n) {
                int i1 = mesh.indices[m + n];
                int i2 = mesh.indices[m + (n + 1) % vertsPerPrim];
                IxEdge ie = new IxEdge(i1, i2);
                List<int[]> faces = adjFaces.get(ie);
                int[] fv0 = faces.get(0);
                if (fv0[1] != n || fv0[0] != m / vertsPerPrim) {
                    creases[m + n] = Boolean.FALSE;
                    continue;
                }
                Boolean crease = Boolean.FALSE;
                if (faces.size() == 1) {
                    crease = Boolean.TRUE;
                } else if (normals.mapping != ElementMesh.Mapping.ALL_SAME) {
                    Vector3d n0 = normals.getPrimVertElement(fv0[0], fv0[1]);
                    for (int o = 1; o < faces.size(); ++o) {
                        Vector3d n1;
                        int fv1v;
                        int[] fv1 = faces.get(o);
                        int fv1offset = fv1[0] * vertsPerPrim;
                        int fv1i = mesh.indices[fv1offset + (fv1v = fv1[1])];
                        if (fv1i != i1 && (fv1i = mesh.indices[fv1offset + (fv1v = (fv1[1] + 1) % vertsPerPrim)]) != i1) {
                            fv1v = (fv1[1] + vertsPerPrim - 1) % vertsPerPrim;
                            fv1i = mesh.indices[fv1offset + fv1v];
                            assert (fv1i == i1);
                        }
                        if (Elements.normalsEqual(n0, n1 = normals.getPrimVertElement(fv1[0], fv1v))) continue;
                        crease = Boolean.TRUE;
                        break;
                    }
                }
                ++genCount;
                if (crease.booleanValue()) {
                    ++creaseCount;
                }
                creases[m + n] = crease;
            }
        }
        if (genCount == creaseCount) {
            return ALL_CREASE;
        }
        if (creaseCount == 0) {
            return NO_CREASE;
        }
        return new ElementMesh<Boolean>(ElementMesh.Mapping.PER_PRIM_VERTEX, creases, ElementMesh.DIRECT, vertsPerPrim);
    }

    private static int getAllFaceCount(IGeom geom) {
        int nfaces = geom.getNumPrims(1);
        if (nfaces == 0 || geom.getNumPrims(7) != nfaces) {
            return 0;
        }
        return nfaces;
    }

    public static <T extends IPrimitive> void processSimilarPolys(List<T> prims, TriConsumer<List<T>, Integer, Integer> processor) {
        Function<IPrimitive, Integer> getVertCount = face -> {
            if (face instanceof IPolygon) {
                return PolyUtil.getNumVerts((IPolygon)face);
            }
            return 0;
        };
        theUtil.groupSequentialMatches(prims, getVertCount, processor);
    }

    public static <T extends IPrimitive> void processPolys(List<T> prims, TriConsumer<List<T>, Integer, Boolean> processor) {
        Function<IPrimitive, Boolean> getIsPoly = prim -> prim instanceof IPolygon;
        theUtil.groupSequentialMatches(prims, getIsPoly, processor);
    }

    public static IElemSource<Boolean> generateCreasesFromNormals(IGeom geom, IPropsSrc props, IElemSource<Vector3d> normalSrc, IElemSource<Orient> orientSrc) {
        if (normalSrc == NO_NORMAL) {
            return (IElemSource)Elements.CREASE.defVal;
        }
        int nfaces = Elements.getAllFaceCount(geom);
        if (nfaces == 0) {
            return (IElemSource)Elements.CREASE.defVal;
        }
        List faces = GeomUtil.explode(geom, IFace.class);
        LinkedHashMap edgeNormals = new LinkedHashMap();
        Function<PEdge, Map> newMap = i -> new ListMap();
        Function<Point3d, List> newNormList = i -> new ArrayList();
        Elements.processSimilarPolys(faces, (ufaces, m, nfverts) -> {
            if (nfverts == 0) {
                return;
            }
            int ucount = ufaces.size();
            IPropsSrc uprops = props.subset((int)m, ucount);
            IElemSource<Vector3d> unormals = normalSrc.subset((int)m, ucount);
            IElemSource<Orient> uorients = orientSrc.subset((int)m, ucount);
            if (unormals == NO_NORMAL) {
                return;
            }
            ElementMesh<Vector3d> normals = unormals.generate(Vector3d.class, (List<IPolygon>)ufaces, uorients, uprops, (int)nfverts, false);
            for (int polyix = 0; polyix < ufaces.size(); ++polyix) {
                IFace face = (IFace)ufaces.get(polyix);
                assert (face instanceof IPolygon);
                IPolygon poly = (IPolygon)face;
                int poffset = 0;
                for (int n = 0; n < poly.getNumLoops(); ++n) {
                    int nlverts = poly.getNumPoints(n);
                    for (int o = 0; o < nlverts; ++o) {
                        int e1 = o;
                        int e2 = (o + 1) % nlverts;
                        Point3d i1 = poly.getPoint(n, e1);
                        Point3d i2 = poly.getPoint(n, e2);
                        PEdge ie = new PEdge(i1, i2);
                        Map avertNorms = (Map)edgeNormals.computeIfAbsent(ie, newMap);
                        List vertNorms1 = (List)avertNorms.computeIfAbsent(i1, newNormList);
                        List vertNorms2 = (List)avertNorms.computeIfAbsent(i2, newNormList);
                        vertNorms1.add(normals.getPrimVertElement(polyix, poffset + e1));
                        vertNorms2.add(normals.getPrimVertElement(polyix, poffset + e2));
                    }
                    poffset += nlverts;
                }
            }
        });
        BiPredicate<Vector3d, Vector3d> nequals = Elements::normalsEqual;
        ElementBuilder<Boolean> builder = ElementBuilders.crease();
        Elements.processSimilarPolys(faces, (ufaces, m, nfverts) -> {
            if (nfverts == 0) {
                builder.add(ALL_CREASE, ufaces.size());
                return;
            }
            Boolean[] creases = new Boolean[ufaces.size() * nfverts];
            int ix = 0;
            for (int polyix = 0; polyix < ufaces.size(); ++polyix) {
                IFace face = (IFace)ufaces.get(polyix);
                assert (face instanceof IPolygon);
                IPolygon poly = (IPolygon)face;
                for (int n = 0; n < poly.getNumLoops(); ++n) {
                    int nlverts = poly.getNumPoints(n);
                    for (int o = 0; o < nlverts; ++o) {
                        Boolean crease;
                        Point3d i2;
                        Point3d i1 = poly.getPoint(n, o);
                        PEdge ie = new PEdge(i1, i2 = poly.getPoint(n, (o + 1) % nlverts));
                        Map avertNorms = (Map)edgeNormals.get(ie);
                        if (avertNorms == null) {
                            crease = Boolean.TRUE;
                        } else {
                            List i1Norms = (List)avertNorms.get(i1);
                            List i2Norms = (List)avertNorms.get(i2);
                            crease = i1Norms.size() == 1 || !theUtil.isUniform(i1Norms, nequals) || !theUtil.isUniform(i2Norms, nequals);
                        }
                        creases[ix++] = crease;
                    }
                }
            }
            IElemSource<Boolean> ucreases = theUtil.isUniform(creases) ? (creases[0] == Boolean.TRUE ? ALL_CREASE : NO_CREASE) : new ElementMesh<Boolean>(ElementMesh.Mapping.PER_PRIM_VERTEX, (ElemT[])creases, (int)nfverts);
            builder.add(ucreases, ufaces.size());
        });
        return builder.finish();
    }

    public static IElemSource<Boolean> generateCreasesFromFacets(IGeom geom, IPropsSrc props, IElemSource<Orient> faceOrients) {
        IElemSource<Vector3d> normals = Elements.generateNormals(geom, faceOrients, false);
        IElemSource<Boolean> creases = Elements.generateCreasesFromNormals(geom, props, normals, faceOrients);
        return creases;
    }

    public static <T> ElementMesh<T> combine(Class<T> type, Collection<Pair<ElementMesh<T>, Integer>> meshes, int numPrims, int vertsPerPrim) {
        if (meshes.size() == 1) {
            return (ElementMesh)meshes.iterator().next().v1;
        }
        Object[] newElements = (Object[])Array.newInstance(type, numPrims * vertsPerPrim);
        int ix = 0;
        for (Pair<ElementMesh<T>, Integer> pair : meshes) {
            ElementMesh mesh = (ElementMesh)pair.v1;
            int numMeshPrims = (Integer)pair.v2;
            for (int m = 0; m < numMeshPrims; ++m) {
                for (int n = 0; n < vertsPerPrim; ++n) {
                    newElements[ix++] = mesh.getPrimVertElement(m, n);
                }
            }
        }
        return new ElementMesh<Object>(ElementMesh.Mapping.PER_PRIM_VERTEX, newElements, vertsPerPrim);
    }

    public static <T> ElementMesh<T> toMesh(Class<T> type, List<T> elems, int vertsPerPrim, boolean optimize) {
        if (elems instanceof ElementMesh) {
            return (ElementMesh)elems;
        }
        if (!optimize) {
            return new ElementMesh<T>(ElementMesh.Mapping.PER_PRIM_VERTEX, theUtil.toArray(elems, type), vertsPerPrim);
        }
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        Function<Object, Integer> ixfunc = e -> map.size();
        int[] ixes = new int[elems.size()];
        int ix = 0;
        for (T elem : elems) {
            int eix = map.computeIfAbsent(elem, ixfunc);
            ixes[ix++] = eix;
        }
        if (map.size() == 1) {
            return new ElementMesh<T>(ElementMesh.Mapping.ALL_SAME, theUtil.toArray(elems, type), vertsPerPrim);
        }
        return new ElementMesh(ElementMesh.Mapping.PER_PRIM_VERTEX, theUtil.toArray(map.keySet(), type), ixes, vertsPerPrim);
    }

    public static boolean transformEq(IPropertySet elements, TransformInfo ti) {
        IElemSource<Vector3d> newNormals;
        if (elements == NONE || ti.isIdentity()) {
            return false;
        }
        UnaryOperator normalOp = v -> {
            Matrix4d mat = ti.getMatrix();
            Vector3d result = Util3D.xform(mat, v);
            Util3D.safeNormalize(result, 0.0);
            return result;
        };
        boolean modified = false;
        IElemSource normals = (IElemSource)elements.get(NORMAL);
        if (normals != (newNormals = normals.transform(Vector3d.class, normalOp))) {
            elements.set(NORMAL, newNormals);
            modified = true;
        }
        if (ti.hasNegativeScale()) {
            IElemSource<Orient> newOrients;
            UnaryOperator orientOp = o -> o.flip();
            IElemSource orients = (IElemSource)((Object)elements.get(ORIENT));
            if (orients != (newOrients = orients.transform(Orient.class, orientOp))) {
                elements.set(ORIENT, newOrients);
                modified = true;
            }
        }
        return modified;
    }

    public static IPropertySet transform(IPropertySet elements, TransformInfo ti) {
        if (ti.isIdentity()) {
            return elements;
        }
        IPropertySet newElements = Elements.copyOf(elements);
        if (!Elements.transformEq(newElements, ti)) {
            return elements;
        }
        return newElements;
    }

    public static IPropertySet getPrimElements(IPropertySet elements, int prim) {
        IPropertySet pelems = Elements.newElements();
        for (ElemProp<?> eprop : FIXED) {
            IElemSource pel = ((IElemSource)elements.get(eprop)).getPrimSource(prim);
            pelems.setIfNotDefault(eprop, pel);
        }
        ListMap<String, IElemSource<Point2d>> uvs = new ListMap<String, IElemSource<Point2d>>();
        for (Map.Entry<String, IElemSource<Point2d>> entry : elements.get(UV).entrySet()) {
            uvs.put(entry.getKey(), entry.getValue().getPrimSource(prim));
        }
        pelems.setIfNotDefault(UV, uvs);
        return Elements.finalizeElements(pelems);
    }

    public static <T> ElementFlattened<T> decompress(IElemSource<T> obj, int primOffset, int numPrims, boolean newArray) {
        if (obj instanceof ElementFlattened) {
            IElemSource<ElemT>[] prims = ((ElementFlattened)obj).getArray();
            assert (prims.length == numPrims);
            return newArray ? new ElementFlattened(Arrays.copyOf(prims, prims.length)) : (ElementFlattened)obj;
        }
        Iterator<IElemSource<T>> it = obj.getPrimIterator(primOffset);
        IElemSource[] prims = new IElemSource[numPrims];
        for (int m = 0; m < numPrims; ++m) {
            prims[m] = it.next();
        }
        return new ElementFlattened(prims);
    }

    public static <T> IElemSource<T> compress(ElemProp<T> type, IElemSource<T> ... prims) {
        ElementBuilder<T> builder = new ElementBuilder<T>((IElemSource)type.defVal);
        for (IElemSource<T> prim : prims) {
            builder.add(prim, 1);
        }
        return builder.finish();
    }

    public static <T> IElemSource<T> compress(ElemProp<T> type, IElemSource<T> obj) {
        if (obj instanceof ElementFlattened) {
            return Elements.compress(type, ((ElementFlattened)obj).getArray());
        }
        return obj;
    }

    public static IPropertySet subset(IPropertySet elems, int begin, int length) {
        if (length == 0) {
            return NONE;
        }
        IPropertySet e = Elements.newElements();
        for (ElemProp<?> prop : FIXED) {
            e.setIfNotDefault(prop, ((IElemSource)elems.get(prop)).subset(begin, length));
        }
        ListMap<String, IElemSource<Point2d>> uvs = new ListMap<String, IElemSource<Point2d>>();
        for (Map.Entry<String, IElemSource<Point2d>> entry : elems.get(UV).entrySet()) {
            uvs.put(entry.getKey(), entry.getValue().subset(begin, length));
        }
        e.setIfNotDefault(UV, uvs);
        return Elements.finalizeElements(e);
    }

    public static <T> IElemSource<T> replaceElements(int nprims, IElemSource<T> elements, IElemSource<T> defVal, BiFunction<Integer, IElemSource<T>, IElemSource<T>> replaceElem) {
        if (nprims > 0) {
            ElementBuilder<T> elBuilder = null;
            IElemSource<T> oldElSrc = elements;
            Iterator<IElemSource<T>> oldElIt = oldElSrc.getPrimIterator(0);
            for (int m = 0; m < nprims; ++m) {
                IElemSource<T> newSrc;
                IElemSource<T> oldSrc = oldElIt.next();
                if (oldSrc == (newSrc = replaceElem.apply(m, oldSrc)) && elBuilder == null) continue;
                if (elBuilder == null) {
                    elBuilder = new ElementBuilder<T>(defVal);
                    elBuilder.add(oldElSrc.subset(0, m), m);
                }
                elBuilder.add(newSrc, 1);
            }
            if (elBuilder != null) {
                elements = elBuilder.finish();
            }
        }
        return elements;
    }

    static {
        ALL.addAll(FIXED);
        ALL.add(UV);
        CREASE_FROM_NORMAL_DOT_TOL = Math.cos(Math.toRadians(1.0));
    }

    private static class EmptyElem<ElemT>
    extends ElementUniform<ElemT>
    implements Serializable {
        static final long serialVersionUID = 1L;

        public EmptyElem(ElemT defVal) {
            super(defVal);
        }

        @Override
        public EmptyElem<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
            return this;
        }

        @Override
        public IElemSource<ElemT> subset(int begin, int length) {
            return this;
        }

        @Override
        public IElemSource<ElemT> getPrimSource(int ix) {
            return this;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.element instanceof Point2d) {
                return NO_UV;
            }
            if (this.element instanceof Vector3d) {
                return NO_NORMAL;
            }
            return this;
        }
    }

    @Deprecated
    private static class EmptyDefault<ElemT>
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Class<ElemT> d_type;

        private EmptyDefault() {
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.d_type.equals(Point2d.class)) {
                return NO_UV;
            }
            if (this.d_type.equals(Vector3d.class)) {
                return NO_NORMAL;
            }
            assert (false);
            return this;
        }
    }

    private static class UniformDefault<ElemT>
    extends ElementUniform<ElemT> {
        static final long serialVersionUID = 1L;

        private UniformDefault(ElemT defElem) {
            super(defElem);
        }

        private Object readResolve() throws ObjectStreamException {
            return UniformDefault.optimize(this);
        }

        @Override
        public ElementUniform<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
            IElemSource result = super.transform((Class)type, (UnaryOperator)xform);
            return UniformDefault.optimize(result);
        }

        private static <ElemT> ElementUniform<ElemT> optimize(ElementUniform<ElemT> eu) {
            if (eu.element == Boolean.FALSE) {
                return (ElementUniform)NO_CREASE;
            }
            if (eu.element == Boolean.TRUE) {
                return (ElementUniform)ALL_CREASE;
            }
            if (eu.element == Orient.CCW) {
                return (ElementUniform)CCW;
            }
            if (eu.element == Orient.CW) {
                return (ElementUniform)CW;
            }
            return eu;
        }
    }

    private static class PEdge {
        public final Point3d i1;
        public final Point3d i2;

        public PEdge(Point3d i1, Point3d i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int hashCode() {
            return this.i1.hashCode() + this.i2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PEdge)) {
                return false;
            }
            PEdge e = (PEdge)obj;
            return this.i1.equals((Tuple3d)e.i1) && this.i2.equals((Tuple3d)e.i2) || this.i1.equals((Tuple3d)e.i2) && this.i2.equals((Tuple3d)e.i1);
        }
    }

    private static class IxEdge {
        public final int i1;
        public final int i2;

        public IxEdge(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IxEdge)) {
                return false;
            }
            IxEdge e = (IxEdge)obj;
            return this.i1 == e.i1 && this.i2 == e.i2 || this.i1 == e.i2 && this.i2 == e.i1;
        }
    }

    private static interface TriIntAndObjConsumer<T> {
        public void accept(int var1, int var2, int var3, T var4);
    }

    private static class NormalCount {
        public final Vector3d protoNormal;
        public final Vector3d normalSum;
        public int count;

        public NormalCount(Vector3d initNormal) {
            this.protoNormal = initNormal;
            this.normalSum = new Vector3d(initNormal);
            this.count = 1;
        }
    }

    public static class ElemProp<ElemT>
    extends IPropertySet.Prop<IElemSource<ElemT>> {
        public final Class<ElemT> type;

        public ElemProp(Object key, Class<ElemT> type, IElemSource<ElemT> emptyVal) {
            super(key, emptyVal);
            this.type = type;
        }
    }

    private static class DefElements
    extends PropertySet {
        static final long serialVersionUID = 1L;

        private DefElements() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NONE;
        }

        @Override
        public <T> void set(IPropertySet.Prop<T> prop, T val) {
        }

        @Override
        public <T> void remove(IPropertySet.Prop<T> prop) {
        }
    }

    public static enum Orient {
        CCW,
        CW;


        public Orient flip() {
            switch (this) {
                case CCW: {
                    return CW;
                }
            }
            return CCW;
        }

        public boolean isCCW() {
            return this == CCW;
        }
    }
}

