/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.theUtil;

public class ElementUniform<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public final ElemT element;

    public ElementUniform(ElemT element) {
        this.element = element;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ElementUniform && Objects.equals(((ElementUniform)obj).element, this.element);
    }

    @Override
    public IElemSource<ElemT> subset(int begin, int length) {
        return this;
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int ix) {
        return this;
    }

    @Override
    public ElemT getPrimVertElement(int primix, int vix) {
        return this.element;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
        if (this.equals(source)) {
            return this;
        }
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
        return this.postConcatenate(source);
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getNumPrims() {
        return -1;
    }

    @Override
    public ElementUniform<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
        Object newElem = xform.apply(this.element);
        if (newElem == this.element) {
            return this;
        }
        return new ElementUniform(newElem);
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props, int vertsPerPrim, boolean optimize) {
        return this.generate(type, vertsPerPrim);
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> type, IPrimitive source, Elements.Orient sourceOrient, Mesh mesh, IPrimProps primProps) {
        return this.generate(type, mesh.getNumVertsPerPrim());
    }

    private ElementMesh<ElemT> generate(Class<ElemT> type, int vertsPerPrim) {
        Object[] elements = (Object[])Array.newInstance(type, 1);
        elements[0] = this.element;
        return new ElementMesh<Object>(ElementMesh.Mapping.ALL_SAME, elements, vertsPerPrim);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
        return new UniformList(prims);
    }

    private class UniformList
    extends AbstractList<ElemT> {
        private final List<? extends IPrimitive> d_prims;
        private Integer d_size = null;

        public UniformList(List<? extends IPrimitive> prims) {
            this.d_prims = prims;
        }

        @Override
        public ElemT get(int index) {
            return ElementUniform.this.element;
        }

        @Override
        public synchronized int size() {
            if (this.d_size == null) {
                int vcount = 0;
                for (IPolygon prim : theUtil.filter(this.d_prims, IPolygon.class)) {
                    vcount += prim.getNumVerts();
                }
                this.d_size = vcount;
            }
            return this.d_size;
        }
    }
}

