/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.FlattenedList;

public class ElementSubList<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    private final IElemSource<ElemT> d_baseList;
    private final int d_offset;
    private final int d_length;

    public ElementSubList(IElemSource<ElemT> baseList, int offset, int length) {
        this.d_baseList = baseList;
        this.d_offset = offset;
        this.d_length = length;
    }

    public IElemSource<ElemT> getBaseSource() {
        return this.d_baseList;
    }

    public int getOffset() {
        return this.d_offset;
    }

    public int getEnd() {
        return this.d_offset + this.d_length;
    }

    @Override
    public int getNumPrims() {
        return this.d_length;
    }

    @Override
    public ElemT getPrimVertElement(int primix, int vix) {
        return this.d_baseList.getPrimVertElement(this.d_offset + primix, vix);
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int ix) {
        return this.d_baseList.getPrimSource(ix + this.d_offset);
    }

    @Override
    public IElemSource<ElemT> subset(int begin, int length) {
        if (begin == 0 && length == this.d_length) {
            return this;
        }
        return this.d_baseList.subset(begin + this.d_offset, length);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
        assert (prims.size() == this.d_length);
        return new FlattenedList(new EList(type, prims, primOrients, props));
    }

    @Override
    public IElemSource<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
        IElemSource<ElemT> newSource = this.d_baseList.transform(type, xform);
        return newSource == this.d_baseList ? this : new ElementSubList<ElemT>(newSource, this.d_offset, this.d_length);
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
        if (source instanceof ElementSubList && ((ElementSubList)source).d_baseList == this.d_baseList && ((ElementSubList)source).d_offset == this.d_offset + this.d_length) {
            return this.d_baseList.subset(this.d_offset, this.d_length + ((ElementSubList)source).d_length);
        }
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
        if (source instanceof ElementSubList && ((ElementSubList)source).d_baseList == this.d_baseList && this.d_offset == ((ElementSubList)source).getEnd()) {
            return this.d_baseList.subset(((ElementSubList)source).d_offset, ((ElementSubList)source).d_length + this.d_length);
        }
        return null;
    }

    @Override
    public boolean isComposite() {
        return this.d_baseList.isComposite();
    }

    @Override
    public Iterator<IElemSource<ElemT>> getPrimIterator(int offset) {
        return new PrimIt(offset);
    }

    private class EList
    extends AbstractList<List<ElemT>> {
        private final Class<ElemT> type;
        private final List<? extends IPolygon> prims;
        private final IElemSource<Elements.Orient> primOrients;
        private final IPropsSrc props;

        public EList(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
            this.type = type;
            this.prims = prims;
            this.primOrients = primOrients;
            this.props = props;
        }

        @Override
        public int size() {
            return ElementSubList.this.d_length;
        }

        @Override
        public List<ElemT> get(int index) {
            return ElementSubList.this.d_baseList.getPrimSource(ElementSubList.this.d_offset + index).generate(this.type, this.prims.subList(index, index + 1), this.primOrients.getPrimSource(index), (IPropsSrc)new UniformProps(this.props.get(index)));
        }

        @Override
        public Iterator<List<ElemT>> iterator() {
            return new It();
        }

        private class It
        implements Iterator<List<ElemT>> {
            private final Iterator<IElemSource<ElemT>> elemit;
            private final Iterator<? extends IPolygon> polyit;
            private final Iterator<IPrimProps> propit;
            private final Iterator<IElemSource<Elements.Orient>> orientit;

            private It() {
                this.elemit = ElementSubList.this.d_baseList.getPrimIterator(ElementSubList.this.d_offset);
                this.polyit = EList.this.prims.iterator();
                this.propit = EList.this.props.iterator();
                this.orientit = EList.this.primOrients.getPrimIterator();
            }

            @Override
            public boolean hasNext() {
                return this.polyit.hasNext();
            }

            @Override
            public List<ElemT> next() {
                return this.elemit.next().generate(EList.this.type, Collections.singletonList(this.polyit.next()), this.orientit.next(), (IPropsSrc)new UniformProps(this.propit.next()));
            }
        }
    }

    private class PrimIt
    implements Iterator<IElemSource<ElemT>> {
        private final Iterator<IElemSource<ElemT>> elemit;
        private int ix;

        private PrimIt(int offset) {
            this.ix = offset;
            this.elemit = ElementSubList.this.d_baseList.getPrimIterator(ElementSubList.this.d_offset + this.ix);
        }

        @Override
        public boolean hasNext() {
            return this.ix < ElementSubList.this.d_length;
        }

        @Override
        public IElemSource<ElemT> next() {
            IElemSource next = this.elemit.next();
            ++this.ix;
            return next;
        }
    }
}

