/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.ElementSubList;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.RepeatedList;
import thunderheadeng.util.theUtil;

public class ElementMesh<ElemT>
extends AbstractList<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int[] DIRECT = new int[0];
    public final Mapping mapping;
    public final ElemT[] elements;
    public final int[] indices;
    public final int vertsPerPrim;

    public ElementMesh(Mapping mapping, ElemT[] elements, int vertsPerPrim) {
        this(mapping, elements, DIRECT, vertsPerPrim);
    }

    public ElementMesh(Mapping mapping, ElemT[] elements, int[] indices, int vertsPerPrim) {
        this.mapping = mapping;
        this.elements = elements;
        this.indices = indices.length == 0 ? DIRECT : indices;
        this.vertsPerPrim = vertsPerPrim;
        assert (this.dataConsistent());
    }

    private boolean dataConsistent() {
        int numPrimElements;
        if (this.mapping != Mapping.PER_PRIM_VERTEX) {
            return true;
        }
        switch (this.indices.length) {
            case 0: {
                numPrimElements = this.elements.length;
                break;
            }
            default: {
                numPrimElements = this.indices.length;
            }
        }
        return numPrimElements % this.vertsPerPrim == 0;
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public IElemSource<ElemT> optimize(Class<ElemT> type) {
        int ucount;
        if (this.mapping == Mapping.ALL_SAME) {
            ElemT elem = this.getPrimVertElement(0, 0);
            return new ElementUniform<ElemT>(elem);
        }
        switch (this.indices.length) {
            case 0: {
                ucount = theUtil.getUniformCount(this.elements, 0, this.elements.length, Objects::equals);
                break;
            }
            default: {
                ucount = ElementMesh.getUniformCount(this.indices, 0, this.indices.length);
            }
        }
        int numPrims = this.getNumPrims();
        if (ucount == numPrims * this.vertsPerPrim) {
            ElemT elem = this.getPrimVertElement(0, 0);
            return new ElementUniform<ElemT>(elem);
        }
        Mapping mapping = this.mapping;
        Object[] elements = this.elements;
        int[] indices = this.indices;
        if (mapping == Mapping.PER_PRIM_VERTEX) {
            int m;
            boolean facesUniform = true;
            for (m = 0; m < numPrims; m += ucount) {
                switch (indices.length) {
                    case 0: {
                        ucount = theUtil.getUniformCount(elements, m, numPrims - m, Objects::equals);
                        break;
                    }
                    default: {
                        ucount = ElementMesh.getUniformCount(indices, m, numPrims - m);
                    }
                }
                if (ucount == this.vertsPerPrim) continue;
                facesUniform = false;
                break;
            }
            if (facesUniform) {
                switch (indices.length) {
                    case 0: {
                        elements = (Object[])Array.newInstance(type, numPrims);
                        for (m = 0; m < numPrims; ++m) {
                            elements[m] = this.getPrimVertElement(m, 0);
                        }
                        break;
                    }
                    default: {
                        int[] newIndices = new int[numPrims];
                        for (int m2 = 0; m2 < numPrims; ++m2) {
                            newIndices[m2] = indices[m2 * this.vertsPerPrim];
                        }
                        indices = newIndices;
                    }
                }
                mapping = Mapping.PER_PRIM;
            }
        }
        if (indices.length > 0 && theUtil.isSequential(indices, 0, indices.length)) {
            indices = DIRECT;
        }
        if (elements == this.elements && indices == this.indices && mapping == this.mapping) {
            return this;
        }
        return new ElementMesh<ElemT>(mapping, elements, indices, this.vertsPerPrim);
    }

    private static <T> int getUniformCount(int[] arr, int offset, int length) {
        if (length <= 1) {
            return length;
        }
        int first = arr[0];
        int end = offset + length;
        for (int m = offset; m < end; ++m) {
            if (first == arr[m]) continue;
            return m - offset;
        }
        return length;
    }

    @Override
    public ElemT getPrimVertElement(int primIx, int vix) {
        int lix;
        switch (this.mapping) {
            case ALL_SAME: {
                lix = 0;
                break;
            }
            case PER_PRIM: {
                lix = primIx;
                break;
            }
            case PER_PRIM_VERTEX: {
                lix = primIx * this.vertsPerPrim + vix;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getElement(lix);
    }

    @Override
    public ElemT get(int index) {
        int lix;
        switch (this.mapping) {
            case ALL_SAME: {
                lix = 0;
                break;
            }
            case PER_PRIM: {
                lix = index / this.vertsPerPrim;
                break;
            }
            case PER_PRIM_VERTEX: {
                lix = index;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getElement(lix);
    }

    private ElemT getElement(int primIx, int gvix) {
        int lix;
        switch (this.mapping) {
            case ALL_SAME: {
                lix = 0;
                break;
            }
            case PER_PRIM: {
                lix = primIx;
                break;
            }
            case PER_PRIM_VERTEX: {
                lix = gvix;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getElement(lix);
    }

    private ElemT getElement(int localix) {
        switch (this.indices.length) {
            case 0: {
                return this.elements[localix];
            }
        }
        return this.elements[this.indices[localix]];
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int primIx) {
        if (this.mapping == Mapping.ALL_SAME) {
            return this;
        }
        return new Prim(this, primIx);
    }

    @Override
    public Iterator<IElemSource<ElemT>> getPrimIterator(int offset) {
        return new PrimIt(offset);
    }

    @Override
    public IElemSource<ElemT> subset(int begin, int length) {
        if (this.mapping == Mapping.ALL_SAME || begin == 0 && length == this.getNumPrims()) {
            return this;
        }
        if (length == 1) {
            return this.getPrimSource(begin);
        }
        return new ElementSubList(this, begin, length);
    }

    @Override
    public ElementMesh<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
        ElemT[] newElements = theUtil.lazyTransform(this.elements, type, xform);
        return newElements == this.elements ? this : new ElementMesh<ElemT>(this.mapping, newElements, this.indices, this.vertsPerPrim);
    }

    @Override
    public int getNumPrims() {
        switch (this.mapping) {
            case ALL_SAME: {
                return -1;
            }
            case PER_PRIM: {
                switch (this.indices.length) {
                    case 0: {
                        return this.elements.length;
                    }
                }
                return this.indices.length;
            }
        }
        switch (this.indices.length) {
            case 0: {
                return this.elements.length / this.vertsPerPrim;
            }
        }
        return this.indices.length / this.vertsPerPrim;
    }

    public int getNumVerts() {
        switch (this.mapping) {
            case ALL_SAME: {
                return -1;
            }
            case PER_PRIM: {
                switch (this.indices.length) {
                    case 0: {
                        return this.elements.length * this.vertsPerPrim;
                    }
                }
                return this.indices.length * this.vertsPerPrim;
            }
        }
        switch (this.indices.length) {
            case 0: {
                return this.elements.length;
            }
        }
        return this.indices.length;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props, int vertsPerPrim, boolean optimize) {
        assert (this.canGenerate(prims, vertsPerPrim));
        return this;
    }

    @Override
    public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
        assert (prims.stream().allMatch(p -> p.getNumVerts() == this.vertsPerPrim));
        assert (this.canGenerate(prims, this.vertsPerPrim));
        return this;
    }

    private boolean canGenerate(List<? extends IPrimitive> prims, int vertsPerPrim) {
        switch (this.mapping) {
            case ALL_SAME: {
                return true;
            }
            case PER_PRIM: {
                return prims.size() == this.getNumPrims();
            }
            case PER_PRIM_VERTEX: {
                return vertsPerPrim == this.vertsPerPrim && prims.size() == this.getNumPrims();
            }
        }
        return false;
    }

    @Override
    public int size() {
        int nverts = this.getNumVerts();
        return nverts == -1 ? Integer.MAX_VALUE : nverts;
    }

    @Override
    public Iterator<ElemT> iterator() {
        return new ElemIt();
    }

    private class PrimIt
    implements Iterator<IElemSource<ElemT>> {
        private int pix;
        private int vix;
        private final int numPrims;

        public PrimIt(int begin) {
            this.pix = begin;
            this.vix = begin * ElementMesh.this.vertsPerPrim;
            this.numPrims = ElementMesh.this.getNumPrims();
        }

        @Override
        public boolean hasNext() {
            return this.pix < this.numPrims;
        }

        @Override
        public Prim next() {
            Prim next = new Prim(ElementMesh.this, this.pix, this.vix);
            ++this.pix;
            this.vix += ElementMesh.this.vertsPerPrim;
            return next;
        }
    }

    private static class PrimElemIt<ElemT>
    implements Iterator<ElemT> {
        private final ElementMesh<ElemT> mesh;
        private final int prim;
        private int vix;
        private final int vend;

        public PrimElemIt(ElementMesh<ElemT> mesh, int prim, int vbegin) {
            this.mesh = mesh;
            this.prim = prim;
            this.vix = vbegin;
            this.vend = vbegin + mesh.vertsPerPrim;
        }

        @Override
        public boolean hasNext() {
            return this.vix < this.vend;
        }

        @Override
        public ElemT next() {
            Object next;
            int eix;
            switch (this.mesh.mapping) {
                case ALL_SAME: {
                    eix = 0;
                    break;
                }
                case PER_PRIM: {
                    eix = this.prim;
                    break;
                }
                case PER_PRIM_VERTEX: {
                    eix = this.vix;
                    break;
                }
                default: {
                    return null;
                }
            }
            switch (this.mesh.indices.length) {
                case 0: {
                    next = this.mesh.elements[eix];
                    break;
                }
                default: {
                    next = this.mesh.elements[this.mesh.indices[eix]];
                }
            }
            ++this.vix;
            return next;
        }
    }

    public static class Prim<ElemT>
    extends AbstractList<ElemT>
    implements IElemSource<ElemT>,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ElementMesh<ElemT> mesh;
        public final int prim;
        public final int vbegin;

        public Prim(ElementMesh<ElemT> mesh, int prim) {
            this(mesh, prim, prim * mesh.vertsPerPrim);
        }

        public Prim(ElementMesh<ElemT> mesh, int prim, int vbegin) {
            this.mesh = mesh;
            this.prim = prim;
            this.vbegin = vbegin;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public IElemSource<ElemT> subset(int begin, int length) {
            return this;
        }

        @Override
        public IElemSource<ElemT> getPrimSource(int ix) {
            return this;
        }

        @Override
        public ElemT getPrimVertElement(int primix, int vix) {
            return this.mesh.getPrimVertElement(this.prim, vix);
        }

        @Override
        public int getNumPrims() {
            return -1;
        }

        @Override
        public IElemSource<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
            assert (false);
            IElemSource newMesh = this.mesh.transform((Class)type, (UnaryOperator)xform);
            if (newMesh == this.mesh) {
                return this;
            }
            return new Prim<ElemT>(newMesh, this.prim, this.vbegin);
        }

        @Override
        public ElementMesh<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props, int vertsPerPrim, boolean optimize) {
            assert (vertsPerPrim == this.mesh.vertsPerPrim);
            return this.generate(this.prim, this.vbegin, prims.size());
        }

        @Override
        public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
            assert (!prims.isEmpty());
            assert (prims.stream().allMatch(p -> p.getNumVerts() == this.mesh.vertsPerPrim));
            if (prims.size() == 1) {
                return this;
            }
            return new RepeatedList(this, prims.size());
        }

        private ElementMesh<ElemT> generate(int primIx, int vbegin, int count) {
            switch (this.mesh.mapping) {
                case ALL_SAME: {
                    return this.mesh;
                }
                case PER_PRIM: {
                    int ix = this.mesh.indices.length > 0 ? this.mesh.indices[primIx] : primIx;
                    int[] ixes = new int[count];
                    Arrays.fill(ixes, ix);
                    return new ElementMesh(Mapping.ALL_SAME, this.mesh.elements, ixes, this.mesh.vertsPerPrim);
                }
                case PER_PRIM_VERTEX: {
                    int vBegin = vbegin;
                    int[] newIxes = new int[this.mesh.vertsPerPrim * count];
                    int n = 0;
                    while (n < newIxes.length) {
                        for (int m = 0; m < this.mesh.vertsPerPrim; ++m) {
                            int ix = vBegin + m;
                            newIxes[n++] = this.mesh.indices.length > 0 ? this.mesh.indices[ix] : ix;
                        }
                    }
                    return new ElementMesh(Mapping.PER_PRIM_VERTEX, this.mesh.elements, newIxes, this.mesh.vertsPerPrim);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public Iterator<ElemT> iterator() {
            return new PrimElemIt<ElemT>(this.mesh, this.prim, this.vbegin);
        }

        @Override
        public ElemT get(int index) {
            int eix;
            switch (this.mesh.mapping) {
                case ALL_SAME: {
                    eix = 0;
                    break;
                }
                case PER_PRIM: {
                    eix = this.prim;
                    break;
                }
                case PER_PRIM_VERTEX: {
                    eix = this.vbegin + index;
                    break;
                }
                default: {
                    return null;
                }
            }
            switch (this.mesh.indices.length) {
                case 0: {
                    return this.mesh.elements[eix];
                }
            }
            return this.mesh.elements[this.mesh.indices[eix]];
        }

        @Override
        public int size() {
            return this.mesh.vertsPerPrim;
        }

        @Override
        public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
            if (source instanceof Prim && ((Prim)source).mesh == this.mesh && ((Prim)source).prim == this.prim + 1) {
                return this.mesh.subset(this.prim, 2);
            }
            if (source instanceof ElementSubList && ((ElementSubList)source).getBaseSource() == this.mesh && ((ElementSubList)source).getOffset() == this.prim + 1) {
                return this.mesh.subset(this.prim, ((ElementSubList)source).getNumPrims() + 1);
            }
            return null;
        }

        @Override
        public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
            if (source instanceof Prim && ((Prim)source).mesh == this.mesh && ((Prim)source).prim == this.prim - 1) {
                return this.mesh.subset(this.prim - 1, 2);
            }
            if (source instanceof ElementSubList && ((ElementSubList)source).getBaseSource() == this.mesh && ((ElementSubList)source).getEnd() == this.prim) {
                return this.mesh.subset(((ElementSubList)source).getOffset(), ((ElementSubList)source).getNumPrims() + 1);
            }
            return null;
        }

        @Override
        public boolean isComposite() {
            return false;
        }
    }

    private class ElemIt
    implements Iterator<ElemT> {
        private int primix = 0;
        private int vix = 0;
        private int nextVEnd;
        private final int vend;

        public ElemIt() {
            this.nextVEnd = ElementMesh.this.vertsPerPrim;
            int nverts = ElementMesh.this.getNumVerts();
            this.vend = nverts == -1 ? Integer.MAX_VALUE : nverts;
        }

        @Override
        public boolean hasNext() {
            return this.vix < this.vend;
        }

        @Override
        public ElemT next() {
            Object next = ElementMesh.this.getElement(this.primix, this.vix);
            ++this.vix;
            if (this.vix >= this.nextVEnd) {
                ++this.primix;
                this.nextVEnd = this.vix + ElementMesh.this.vertsPerPrim;
            }
            return next;
        }
    }

    public static enum Mapping {
        PER_PRIM_VERTEX,
        PER_PRIM,
        ALL_SAME;

    }
}

