/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementSubList;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.FlattenedList;
import thunderheadeng.util.theUtil;

public class ElementFlattened<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    private final IElemSource<ElemT>[] d_prims;

    public ElementFlattened(IElemSource<ElemT>[] prims) {
        this.d_prims = prims;
        assert (Stream.of(prims).noneMatch(p -> p instanceof ElementMesh && ((ElementMesh)p).getNumPrims() > 1));
    }

    public IElemSource<ElemT>[] getArray() {
        return this.d_prims;
    }

    @Override
    public int getNumPrims() {
        return this.d_prims.length;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public ElementFlattened<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
        IElemSource[] newSources = theUtil.lazyTransform(this.d_prims, IElemSource.class, prim -> prim.transform(type, xform));
        return newSources == this.d_prims ? this : new ElementFlattened<ElemT>(newSources);
    }

    @Override
    public IElemSource<ElemT> subset(int begin, int length) {
        if (begin == 0 && length == this.d_prims.length) {
            return this;
        }
        if (length == 1) {
            return this.getPrimSource(begin);
        }
        return new ElementSubList(this, begin, length);
    }

    @Override
    public IElemSource getPrimSource(int ix) {
        return this.d_prims[ix];
    }

    @Override
    public ElemT getPrimVertElement(int primix, int vix) {
        return this.d_prims[primix].getPrimVertElement(0, vix);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
        assert (prims.size() == this.d_prims.length);
        return new FlattenedList(new EList(type, prims, props, primOrients));
    }

    private class EList
    extends AbstractList<List<ElemT>> {
        private final List<? extends IPolygon> d_primList;
        private final Class<ElemT> d_type;
        private final IPropsSrc d_props;
        private final IElemSource<Elements.Orient> d_primOrients;

        private EList(Class<ElemT> type, List<? extends IPolygon> prims, IPropsSrc props, IElemSource<Elements.Orient> orients) {
            this.d_type = type;
            this.d_primList = prims;
            this.d_props = props;
            this.d_primOrients = orients;
        }

        @Override
        public List<ElemT> get(int index) {
            IPrimProps prop = this.d_props.get(index);
            return ElementFlattened.this.d_prims[index].generate(this.d_type, this.d_primList.subList(index, index + 1), this.d_primOrients.subset(index, index + 1), (IPropsSrc)new UniformProps(prop));
        }

        @Override
        public int size() {
            return ElementFlattened.this.d_prims.length;
        }

        @Override
        public Iterator<List<ElemT>> iterator() {
            return new It();
        }

        private class It
        implements Iterator<List<ElemT>> {
            private Iterator<? extends IPolygon> primit;
            private Iterator<IPrimProps> propit;
            private Iterator<IElemSource<Elements.Orient>> orientit;
            private int d_ix;

            private It() {
                this.primit = EList.this.d_primList.iterator();
                this.propit = EList.this.d_props.iterator();
                this.orientit = EList.this.d_primOrients.getPrimIterator();
                this.d_ix = 0;
            }

            @Override
            public boolean hasNext() {
                return this.d_ix < ElementFlattened.this.d_prims.length;
            }

            @Override
            public List<ElemT> next() {
                List next = ElementFlattened.this.d_prims[this.d_ix].generate(EList.this.d_type, Collections.singletonList(this.primit.next()), this.orientit.next(), (IPropsSrc)new UniformProps(this.propit.next()));
                ++this.d_ix;
                return next;
            }
        }
    }
}

