/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.AExtrudeHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyCurve;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class WallGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    private static final double NONLINEAR_CURVE_TOL = 0.001;
    public final ICurve refCurve;
    public final Alignment alignment;
    public final double thickness;
    public final double height;
    private transient Point3d[] d_refCurveVerts;
    public static final IDOF DOF = new IDOF(){

        @Override
        public boolean accept(TransformInfo ti) {
            Predicate<ScaleXform> stest;
            Predicate<RotateXform> rtest;
            Predicate<TranslateXform> ttest = Predicates.alwaysTrue();
            return GeomUtil.testTransforms(ti.xform, ttest, mir -> theUtil.eq0(mir.plane.z, 1.0E-9), rtest = r -> GeomUtil.isZRotation(r, 1.0E-9), stest = s -> s.x == s.y && s.z >= 0.0, o -> o.isIdentity()) || GeomUtil.testTransforms(ti.getMatrix(), ttest, rtest, stest);
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Rotation may only be about the Z-axis."));
        }

        public String toString() {
            return "WallGeom.DOF";
        }
    };

    public WallGeom(ICurve refCurve, Alignment alignment, double thickness, double height) {
        this.refCurve = refCurve;
        this.alignment = alignment;
        this.thickness = thickness;
        this.height = height;
        this.d_refCurveVerts = null;
    }

    @Override
    public WallGeom optimize(IPointOptimizer pool) {
        ICurve opCurve = this.refCurve.optimize(pool);
        if (opCurve == this.refCurve) {
            return this;
        }
        return new WallGeom(opCurve, this.alignment, this.thickness, this.height);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.generateVerts());
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return DOF;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        if (GeomUtil.test(options, 1) && ti.isAccepted(DOF)) {
            ICurve newCurve = this.refCurve.transform(ti, options);
            Matrix4d mat = ti.getMatrix();
            Vector3d up = new Vector3d(0.0, 0.0, this.height);
            mat.transform(up);
            assert (up.z >= 0.0 && theUtil.eq0(up.x, 1.0E-6 * up.z) && theUtil.eq0(up.y, 1.0E-6 * up.z));
            double newHeight = up.z;
            Vector3d x = new Vector3d(this.thickness, 0.0, 0.0);
            mat.transform(x);
            double newThickness = x.length();
            Alignment newAlign = this.alignment;
            if (this.alignment != Alignment.CENTER) {
                Vector3d y = new Vector3d(0.0, this.thickness, 0.0);
                mat.transform(y);
                Vector3d xcy = Util3D.cross(x, y);
                if (xcy.z < 0.0) {
                    switch (this.alignment) {
                        case LEFT: {
                            newAlign = Alignment.RIGHT;
                            break;
                        }
                        case RIGHT: {
                            newAlign = Alignment.LEFT;
                        }
                    }
                }
            }
            return new WallGeom(newCurve, newAlign, newThickness, newHeight);
        }
        return this.toMesh(ti.getMatrix());
    }

    public boolean isWrapped() {
        return this.refCurve.isClosed();
    }

    private boolean looksWrapped() {
        if (this.isWrapped()) {
            return true;
        }
        Point3d[] refVerts = this.getReferenceVerts();
        return refVerts.length >= 3 && refVerts[0].epsilonEquals((Tuple3d)refVerts[refVerts.length - 1], 1.0E-9);
    }

    public Mesh toMesh(Matrix4d xform) {
        int offset;
        int m;
        int offset2;
        int offset1;
        int m2;
        Point3d[] refVerts = this.getReferenceVerts();
        if (refVerts.length == 0) {
            return new Mesh(new Point3d[0], new int[0], 3, 4);
        }
        Point3d[] points = this.generateVerts(refVerts);
        if (xform != null) {
            for (Point3d p : points) {
                xform.transform(p);
            }
        }
        int numFaces = this.getNumPrims(1);
        int[] ixes = new int[numFaces * 4];
        int iix = 0;
        int[] bottom = this.getFaceRange(Face.BOTTOM, numFaces);
        int[] top = this.getFaceRange(Face.TOP, numFaces);
        int[] side1 = this.getFaceRange(Face.SIDE1, numFaces);
        int[] side2 = this.getFaceRange(Face.SIDE2, numFaces);
        int[] endcap1 = this.getFaceRange(Face.ENDCAP_START, numFaces);
        int[] endcap2 = this.getFaceRange(Face.ENDCAP_END, numFaces);
        int foffset = refVerts.length * 2;
        int[] side = this.alignment == Alignment.RIGHT ? side1 : side2;
        iix = side[0] * 4;
        for (m2 = 0; m2 < side[1]; ++m2) {
            offset1 = m2 << 1;
            offset2 = offset1 + foffset;
            ixes[iix++] = offset1 + 1;
            ixes[iix++] = offset1 + 3;
            ixes[iix++] = offset2 + 3;
            ixes[iix++] = offset2 + 1;
        }
        side = this.alignment == Alignment.RIGHT ? side2 : side1;
        iix = side[0] * 4;
        for (m2 = 0; m2 < side[1]; ++m2) {
            offset1 = m2 << 1;
            offset2 = offset1 + foffset;
            ixes[iix++] = offset1 + 2;
            ixes[iix++] = offset1;
            ixes[iix++] = offset2;
            ixes[iix++] = offset2 + 2;
        }
        iix = bottom[0] * 4;
        for (m = 0; m < bottom[1]; ++m) {
            offset = m << 1;
            ixes[iix++] = offset + 1;
            ixes[iix++] = offset;
            ixes[iix++] = offset + 2;
            ixes[iix++] = offset + 3;
        }
        iix = top[0] * 4;
        for (m = 0; m < top[1]; ++m) {
            offset = (m << 1) + foffset;
            ixes[iix++] = offset;
            ixes[iix++] = offset + 1;
            ixes[iix++] = offset + 3;
            ixes[iix++] = offset + 2;
        }
        if (endcap1[1] > 0) {
            iix = endcap1[0] * 4;
            ixes[iix++] = 0;
            ixes[iix++] = 1;
            ixes[iix++] = 1 + foffset;
            ixes[iix++] = foffset;
        }
        if (endcap2[1] > 0) {
            iix = endcap2[0] * 4;
            ixes[iix++] = foffset - 1;
            ixes[iix++] = foffset - 2;
            ixes[iix++] = foffset * 2 - 2;
            ixes[iix++] = foffset * 2 - 1;
        }
        return new Mesh(points, ixes, 3, 4);
    }

    public int[] getFaceRange(Face face) {
        int numFaces = this.getNumPrims(1);
        return this.getFaceRange(face, numFaces);
    }

    protected int[] getFaceRange(Face face, int numFaces) {
        if (numFaces == 0) {
            return new int[]{0, 0};
        }
        if (numFaces == 2) {
            switch (face) {
                case ENDCAP_START: {
                    return new int[]{0, 1};
                }
                case ENDCAP_END: {
                    return new int[]{1, 1};
                }
            }
            return new int[]{0, 0};
        }
        int numEndcaps = this.getNumEndcaps();
        int numSegs = (numFaces - numEndcaps) / 4;
        switch (face) {
            case SIDE1: {
                return new int[]{0, numSegs};
            }
            case SIDE2: {
                return new int[]{numSegs, numSegs};
            }
            case ENDCAP_START: {
                return new int[]{numSegs * 2, numEndcaps / 2};
            }
            case ENDCAP_END: {
                return new int[]{numSegs * 2 + 1, numEndcaps / 2};
            }
            case BOTTOM: {
                return new int[]{numSegs * 2 + numEndcaps, numSegs};
            }
            case TOP: {
                return new int[]{numSegs * 3 + numEndcaps, numSegs};
            }
        }
        return null;
    }

    public int getNumEndcaps() {
        return this.isWrapped() ? 0 : 2;
    }

    @Override
    public int getNumPrims(int types) {
        if (GeomUtil.test(types, 1)) {
            int numVerts = this.getReferenceVerts().length;
            if (numVerts == 0) {
                return 0;
            }
            return (numVerts - 1) * 4 + this.getNumEndcaps();
        }
        return 0;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        if (this.getNumPrims(1) != 6) {
            return false;
        }
        Point3d p1 = null;
        Point3d p2 = null;
        if (!(this.refCurve instanceof ILinearCurve) || ((ILinearCurve)this.refCurve).getNumVerts() != 2) {
            return false;
        }
        p1 = ((ILinearCurve)this.refCurve).getVert(0);
        p2 = ((ILinearCurve)this.refCurve).getVert(1);
        if (parentXform != null && !parentXform.isIdentity()) {
            Matrix4d mat = parentXform.getMatrix();
            p1 = Util3D.xform(mat, p1);
            p2 = Util3D.xform(mat, p2);
        }
        return theUtil.eq(p1.z, p2.z, 1.0E-6) && (theUtil.eq(p1.x, p2.x, 1.0E-6) || theUtil.eq(p1.y, p2.y, 1.0E-6));
    }

    @Override
    public boolean isShell() {
        return this.thickness <= 1.0E-6 || this.height <= 1.0E-6;
    }

    public Point3d[] generateVerts() {
        Point3d[] refVerts = this.getReferenceVerts();
        return this.generateVerts(refVerts);
    }

    protected Point3d[] generateVerts(Point3d ... refVerts) {
        if (refVerts.length == 0) {
            return new Point3d[0];
        }
        if (refVerts.length == 1) {
            Point3d p = refVerts[0];
            return new Point3d[]{new Point3d(p.x, p.y + this.thickness, p.z), new Point3d(p), new Point3d(p.x, p.y + this.thickness, p.z + this.height), new Point3d(p.x, p.y, p.z + this.height)};
        }
        Point3d[] verts = new Point3d[refVerts.length * 2 * 2];
        int vix = 0;
        int numSegs = refVerts.length - 1;
        Vector3d[] dirs2d = new Vector3d[numSegs];
        for (int m = 0; m < numSegs; ++m) {
            Point3d p1 = refVerts[m];
            Point3d p2 = refVerts[m + 1];
            dirs2d[m] = WallGeom.vectorN2d(p1, p2);
        }
        boolean wrapped = this.looksWrapped();
        for (int m = 0; m < numSegs; ++m) {
            Vector3d nextDir2d;
            Point3d p1 = refVerts[m];
            Point3d p2 = refVerts[m + 1];
            Vector3d dir2d = dirs2d[m];
            Point3d[] offsets = this.getOffsetPoints(p1, p2);
            if (m == 0) {
                verts[vix++] = new Point3d(offsets[0]);
                verts[vix++] = new Point3d(offsets[1]);
            }
            Vector3d isectDir = null;
            if ((wrapped || m < numSegs - 1) && !theUtil.eq(Math.abs(dir2d.dot(nextDir2d = dirs2d[(m + 1) % numSegs])), 1.0, 1.0E-6)) {
                Vector3d nextNormal = Util3D.add(dir2d, (Tuple3d)nextDir2d);
                nextNormal.normalize();
                isectDir = nextNormal;
            }
            if (isectDir == null) {
                isectDir = new Vector3d(dir2d);
            }
            double temp = isectDir.x;
            isectDir.x = -isectDir.y;
            isectDir.y = temp;
            double[] prox1 = Inter3D.lineLineProximityT(p2, isectDir, offsets[0], dir2d, 1.0E-6);
            double[] prox2 = Inter3D.lineLineProximityT(p2, isectDir, offsets[1], dir2d, 1.0E-6);
            Point3d p1b = prox1 != null ? Util3D.linePoint(p2, isectDir, prox1[0]) : new Point3d(p2);
            Point3d p2b = prox2 != null ? Util3D.linePoint(p2, isectDir, prox2[0]) : new Point3d(p2);
            verts[vix++] = p1b;
            verts[vix++] = p2b;
            if (!wrapped || m != numSegs - 1) continue;
            verts[0] = new Point3d(p1b);
            verts[1] = new Point3d(p2b);
        }
        Vector3d extrudeVec = new Vector3d(0.0, 0.0, this.height);
        int halfCount = verts.length / 2;
        assert (vix == halfCount);
        for (int m = 0; m < halfCount; ++m) {
            Point3d offset;
            Point3d p = verts[m];
            verts[m + halfCount] = offset = Util3D.add(p, (Tuple3d)extrudeVec);
        }
        return verts;
    }

    private static boolean equal2d(Point3d p1, Point3d p2) {
        return p1.x == p2.x && p1.y == p2.y;
    }

    private static Vector3d vectorN2d(Point3d p1, Point3d p2) {
        Vector3d v = new Vector3d(p2.x - p1.x, p2.y - p1.y, 0.0);
        v.normalize();
        return v;
    }

    private Point3d[] getOffsetPoints(Point3d a, Point3d b) {
        Vector3d thick;
        double d_errTol = 1.0E-15;
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        if (Math.abs(dx) < 1.0E-15 && Math.abs(dy) < 1.0E-15) {
            thick = new Vector3d(1.0, 0.0, 0.0);
        } else {
            thick = new Vector3d(-dy, dx, 0.0);
            thick.normalize();
        }
        switch (this.alignment) {
            case LEFT: {
                thick.scale(this.thickness);
                return new Point3d[]{Util3D.add(a, (Tuple3d)thick), a};
            }
            case RIGHT: {
                thick.scale(this.thickness);
                return new Point3d[]{a, Util3D.sub(a, (Tuple3d)thick)};
            }
        }
        thick.scale(this.thickness * 0.5);
        return new Point3d[]{Util3D.add(a, (Tuple3d)thick), Util3D.sub(a, (Tuple3d)thick)};
    }

    private Point3d[] getReferenceVerts() {
        ArrayList<Point3d> refVerts;
        if (this.d_refCurveVerts != null) {
            return this.d_refCurveVerts;
        }
        List<ILinearCurve> linear = this.toLinear(this.refCurve);
        if (!linear.isEmpty()) {
            refVerts = new ArrayList<Point3d>();
            for (ILinearCurve lc : linear) {
                for (int m = 0; m < lc.getNumVerts(); ++m) {
                    refVerts.add(lc.getVert(m));
                }
            }
        } else {
            Mesh segMesh = this.refCurve.getSegments(0.001);
            if (segMesh.indices.length == 0) {
                return new Point3d[0];
            }
            refVerts = new ArrayList(segMesh.indices.length / 2 - 1);
            Point3d prev = null;
            for (int m = 0; m < segMesh.indices.length; m += 2) {
                Point3d p = segMesh.vertices[segMesh.indices[m]];
                if (prev == null || !WallGeom.equal2d(prev, p)) {
                    refVerts.add(p);
                }
                prev = p;
            }
            Point3d last = segMesh.vertices[segMesh.indices[segMesh.indices.length - 1]];
            if (prev == null || !WallGeom.equal2d(prev, last)) {
                refVerts.add(last);
            }
        }
        this.d_refCurveVerts = refVerts.toArray(new Point3d[refVerts.size()]);
        return this.d_refCurveVerts;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        prims.add(this.toMesh(null));
        return prims;
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        if (filter.acceptGeomType(source, GeomType.FACE) || filter.acceptGeomType(source, GeomType.FACE_EDGE) || filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
            Mesh mesh = this.toMesh(null);
            mesh.pickBox(source, filter, region, isects);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (filter.acceptGeomType(source, GeomType.FACE) || filter.acceptGeomType(source, GeomType.FACE_EDGE) || filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
            Mesh mesh = this.toMesh(null);
            mesh.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        this.toMesh(null).find(test, result);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        this.toMesh(null).getAll(result);
    }

    private List<ILinearCurve> toLinear(ICurve curve) {
        ArrayList<ILinearCurve> curves = new ArrayList<ILinearCurve>();
        if (!this.toLinear(curve, curves)) {
            return Collections.emptyList();
        }
        return curves;
    }

    private boolean toLinear(ICurve curve, List<ILinearCurve> curves) {
        if (curve instanceof ILinearCurve) {
            curves.add((ILinearCurve)curve);
            return true;
        }
        if (curve instanceof PolyCurve) {
            PolyCurve pc = (PolyCurve)curve;
            for (ICurve c : pc.curves) {
                if (this.toLinear(c, curves)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<? extends IHandle> arrayList;
        Face[] extrudeFaces;
        Face[] faceArray;
        List<ILinearCurve> linearCurves = this.toLinear(this.refCurve);
        if (linearCurves.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IHandle> handles = new ArrayList<IHandle>();
        BiConsumer<ILinearCurve, Boolean> addCurveHandles = (manipCurve, bottom) -> {
            for (IHandle iHandle : manipCurve.generateManipHandles()) {
                handles.add(new VertHandle(this, iHandle, (boolean)bottom));
            }
        };
        for (ILinearCurve iLinearCurve : linearCurves) {
            addCurveHandles.accept(iLinearCurve, true);
            addCurveHandles.accept(iLinearCurve.transform(TransformUtil.translate(0.0, 0.0, this.height).getInfo(), 1), false);
        }
        if (this.alignment == Alignment.CENTER) {
            Face[] faceArray2 = new Face[2];
            faceArray2[0] = Face.SIDE1;
            faceArray = faceArray2;
            faceArray2[1] = Face.SIDE2;
        } else {
            Face[] faceArray3 = new Face[1];
            faceArray = faceArray3;
            faceArray3[0] = Face.SIDE1;
        }
        for (Face extrudeFace : extrudeFaces = faceArray) {
            int[] faceRange = this.getFaceRange(extrudeFace);
            for (int m = faceRange[0]; m < faceRange[0] + faceRange[1]; ++m) {
                handles.add(new ThicknessHandle(this, m));
            }
        }
        handles.add(new HeightHandle(this, Face.BOTTOM));
        handles.add(new HeightHandle(this, Face.TOP));
        if (this.refCurve instanceof IManipulatable && !this.isWrapped() && !(arrayList = new ArrayList<IHandle>(((IManipulatable)((Object)this.refCurve)).generateManipHandles())).isEmpty()) {
            handles.add(new EndcapHandle(this, Face.ENDCAP_START, (IHandle)arrayList.get(0)));
            handles.add(new EndcapHandle(this, Face.ENDCAP_END, (IHandle)arrayList.get(arrayList.size() - 1)));
        }
        return handles;
    }

    private static class VertHandle
    implements IHandle {
        private WallGeom geom;
        private final IHandle handle;
        private final boolean bottom;

        public VertHandle(WallGeom geom, IHandle handle, boolean bottom) {
            this.geom = geom;
            this.handle = handle;
            this.bottom = bottom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof VertHandle && ((VertHandle)obj).handle.equals(this.handle) && ((VertHandle)obj).bottom == this.bottom;
        }

        @Override
        public IGeomNode getGeom() {
            return this.handle.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.handle.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.handle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            Object mod = this.handle.modify(newLoc);
            this.geom = this.modify(mod);
            return this.geom;
        }

        @Override
        public Object end() {
            this.geom = this.modify(this.handle.end());
            return this.geom;
        }

        protected WallGeom modify(Object mod) {
            if (mod instanceof ICurve) {
                ICurve curve = (ICurve)mod;
                if (!this.bottom) {
                    curve = curve.transform(TransformUtil.translate(0.0, 0.0, -this.geom.height).getInfo(), 1);
                }
                return new WallGeom(curve, this.geom.alignment, this.geom.thickness, this.geom.height);
            }
            return this.geom;
        }
    }

    private static class HeightHandle
    extends AExtrudeHandle<WallGeom> {
        private final Face d_face;

        public HeightHandle(WallGeom geom, Face face) {
            super(geom);
            this.d_face = face;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof HeightHandle && ((HeightHandle)obj).d_face == this.d_face;
        }

        @Override
        public IGeomNode getGeom() {
            int[] fRange = ((WallGeom)this.getManipGeom()).getFaceRange(this.d_face);
            Mesh mesh = ((WallGeom)this.getManipGeom()).toMesh(null);
            ArrayList<IPrimitive> faces = new ArrayList<IPrimitive>(fRange[1]);
            for (int m = fRange[0]; m < fRange[0] + fRange[1]; ++m) {
                faces.add(mesh.getPrimitive(m));
            }
            return GeomNodeUtil.newNode(GeomUtil.group(faces));
        }

        @Override
        protected WallGeom extrude(WallGeom geom, Vector3d extrudeDir, double t) throws ManipException {
            if (this.d_face == Face.TOP) {
                double newHeight = geom.height + t;
                if (newHeight < 0.0) {
                    newHeight = 0.0;
                }
                return new WallGeom(geom.refCurve, geom.alignment, geom.thickness, newHeight);
            }
            if (t > geom.height) {
                t = geom.height;
            }
            double newHeight = geom.height - t;
            TransformInfo xform = TransformUtil.translate(0.0, 0.0, t).getInfo();
            ICurve newCurve = geom.refCurve.transform(xform, 1);
            return new WallGeom(newCurve, geom.alignment, geom.thickness, newHeight);
        }

        @Override
        protected Vector3d getExtrudeDir(WallGeom geom) {
            return GeomConstants.VEC3D_ZPOS;
        }
    }

    private static class EndcapHandle
    implements IHandle {
        private WallGeom d_geom;
        private final Face d_face;
        private final IHandle d_refHandle;
        private Point3d t_pickLoc;

        public EndcapHandle(WallGeom geom, Face face, IHandle refHandle) {
            this.d_geom = geom;
            this.d_face = face;
            this.d_refHandle = refHandle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof EndcapHandle && ((EndcapHandle)obj).d_face == this.d_face;
        }

        @Override
        public IGeomNode getGeom() {
            int[] range = this.d_geom.getFaceRange(this.d_face);
            assert (range[1] == 1);
            return GeomNodeUtil.newNode(this.d_geom.toMesh(null).getPrimitive(range[0]));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            ISnapConstraint refConstraint = this.d_refHandle.getConstraint(handleLoc);
            if (refConstraint != null) {
                return refConstraint;
            }
            IPolygon face = (IPolygon)this.getGeom().getLocalGeom();
            return new LineConstraint(handleLoc, face.getNormal(true));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_pickLoc = handleLoc;
            IGeom refGeom = this.d_refHandle.getGeom().flatten().getLocalGeom();
            if (refGeom instanceof Point) {
                handleLoc = ((Point)refGeom).loc;
            }
            this.d_refHandle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            IGeom refGeom = this.d_refHandle.getGeom().flatten().getLocalGeom();
            if (refGeom instanceof Point) {
                Vector3d vec = Util3D.vector(this.t_pickLoc, newLoc);
                newLoc = Util3D.add(((Point)refGeom).loc, (Tuple3d)vec);
                this.t_pickLoc = Util3D.add(this.t_pickLoc, (Tuple3d)vec);
            }
            Object mod = this.d_refHandle.modify(newLoc);
            this.d_geom = this.finalize(mod);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.finalize(this.d_refHandle.end());
            this.t_pickLoc = null;
            return this.d_geom;
        }

        private WallGeom finalize(Object refMod) {
            if (refMod instanceof ICurve) {
                return new WallGeom((ICurve)refMod, this.d_geom.alignment, this.d_geom.thickness, this.d_geom.height);
            }
            return this.d_geom;
        }
    }

    private static class ThicknessHandle
    extends AExtrudeHandle<WallGeom> {
        private final int d_faceIx;

        public ThicknessHandle(WallGeom geom, int face) {
            super(geom);
            this.d_faceIx = face;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof ThicknessHandle && ((ThicknessHandle)obj).d_faceIx == this.d_faceIx;
        }

        @Override
        public IGeomNode getGeom() {
            Mesh mesh = ((WallGeom)this.getManipGeom()).toMesh(null);
            return GeomNodeUtil.newNode(mesh.getPrimitive(this.d_faceIx));
        }

        @Override
        protected Vector3d getExtrudeDir(WallGeom geom) {
            Mesh mesh = ((WallGeom)this.getManipGeom()).toMesh(null);
            Quad face = (Quad)mesh.getPrimitive(this.d_faceIx);
            return face.getNormal(true);
        }

        @Override
        protected WallGeom extrude(WallGeom geom, Vector3d extrudeDir, double t) throws ManipException {
            if (geom.alignment == Alignment.CENTER) {
                t *= 2.0;
            }
            double newThickness = geom.thickness + t;
            Alignment newAlign = geom.alignment;
            if (newThickness < 0.0) {
                newAlign = geom.alignment.opposite();
                newThickness = -newThickness;
            }
            return new WallGeom(geom.refCurve, newAlign, newThickness, geom.height);
        }
    }

    public static enum Face {
        SIDE1,
        SIDE2,
        BOTTOM,
        TOP,
        ENDCAP_START,
        ENDCAP_END;

    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;


        Alignment opposite() {
            switch (this) {
                case LEFT: {
                    return RIGHT;
                }
                case RIGHT: {
                    return LEFT;
                }
            }
            return CENTER;
        }
    }
}

