/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class Triangle
extends AFace
implements IPolygon {
    private static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;

    public Triangle(Point3d p1, Point3d p2, Point3d p3) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    @Override
    public Triangle optimize(IPointOptimizer pool) {
        Point3d np1 = pool.getExisting(this.p1);
        Point3d np2 = pool.getExisting(this.p2);
        Point3d np3 = pool.getExisting(this.p3);
        return np1 != this.p1 || np2 != this.p2 || np3 != this.p3 ? new Triangle(np1, np2, np3) : this;
    }

    @Override
    public Triangle flipOrient() {
        return new Triangle(this.p3, this.p2, this.p1);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.p1);
        aabb.add(this.p2);
        aabb.add(this.p3);
        return aabb;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public Triangle transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        return new Triangle(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2), Util3D.xform(xform, this.p3));
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int loop) {
        return 3;
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        switch (ix) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
        }
        return null;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
        PolyUtil.getBoundary(boundary, this);
    }

    @Override
    public Vector3d getNormalIfValid(boolean ccw) {
        return Util3D.simplePolygonNormal(Arrays.asList(this.p1, this.p2, this.p3), ccw, 0.0);
    }

    @Override
    public Plane3d getPlane(boolean ccw) {
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(this.p1, this.p2, this.p3), ccw, 0.0);
        if (plane != null) {
            return plane;
        }
        return new Plane3d(GeomConstants.VEC3D_ZERO, this.p1);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean ccw) {
        return Util3D.simplePolygonPlane(Arrays.asList(this.p1, this.p2, this.p3), ccw, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        Point3d[] verts = new Point3d[]{this.p1, this.p2, this.p3};
        int[] ixes = new int[]{0, 1, 2};
        return new Pair<Mesh, Boolean>(new Mesh(verts, ixes, 2), ccw);
    }

    @Override
    public Supplier<Point3d> getPointGenerator(Random r) {
        return () -> Util3D.getRandomPointInTri(this.p1, this.p2, this.p3, r);
    }
}

