/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AreaUtil;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Spline2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ShapeGeom
implements IGeom {
    static final long serialVersionUID = 1L;
    public final transient Shape shape;
    public final Matrix4d lwXform;
    private transient SoftReference<Matrix4d> d_wlXform;

    public ShapeGeom(Shape shape, Matrix4d lwXform) {
        this.shape = shape;
        this.lwXform = lwXform;
    }

    public ShapeGeom(Shape shape, Plane3d plane) {
        this(shape, Util.getLocalToWorldXform(plane));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ShapeUtil.writeShape(out, this.shape);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Shape shape = ShapeUtil.readShape(in);
        try {
            theUtil.assignFinalField(this, ShapeGeom.class, "shape", shape);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static Matrix4d invert(Matrix4d xform) {
        Matrix4d invert = new Matrix4d(xform);
        invert.invert();
        return invert;
    }

    public Matrix4d getWLXform() {
        Matrix4d wlxform;
        Matrix4d matrix4d = wlxform = this.d_wlXform != null ? this.d_wlXform.get() : null;
        if (wlxform == null) {
            wlxform = ShapeGeom.invert(this.lwXform);
            this.d_wlXform = new SoftReference<Matrix4d>(wlxform);
        }
        return wlxform;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public IGeom optimize(IPointOptimizer pool) {
        return this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        AABox box = ShapeUtil.getBounds(this.shape, this.lwXform);
        aabb.add(box);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.INVERTIBLE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.INVERTIBLE;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d newXform = new Matrix4d(ti.getMatrix());
        newXform.mul(this.lwXform);
        return new ShapeGeom(this.shape, newXform);
    }

    @Override
    public int getNumPrims(int types) {
        if (this.shape instanceof Area) {
            return (types & 1) != 0 ? 1 : 0;
        }
        if ((types & 2) != 0) {
            int numCurves = 0;
            int currNumSegments = 0;
            double[] coords = new double[6];
            PathIterator it = this.shape.getPathIterator(null);
            while (!it.isDone()) {
                int command = it.currentSegment(coords);
                switch (command) {
                    case 0: {
                        if (currNumSegments > 0) {
                            ++numCurves;
                        }
                        currNumSegments = 0;
                        break;
                    }
                    default: {
                        ++currNumSegments;
                    }
                }
                it.next();
            }
            if (currNumSegments > 0) {
                ++numCurves;
            }
            return numCurves;
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        if (this.shape instanceof Area) {
            prims.add(new AreaFace((Area)this.shape, this.lwXform, this.getWLXform(), false));
        } else {
            ShapeGeom.getCurves(prims, this.shape, this.lwXform, this.getWLXform());
        }
        return prims;
    }

    private static void getCurves(Collection<? super ICurve> curves, Shape shape, Matrix4d lwXform, Matrix4d wlXform) {
        int currNumSegments = 0;
        double[] coords = new double[6];
        Path2D.Double currCurve = new Path2D.Double();
        PathIterator it = shape.getPathIterator(null);
        while (!it.isDone()) {
            int command = it.currentSegment(coords);
            if (command == 0) {
                if (currNumSegments > 0) {
                    curves.add(new ShapeCurve(currCurve, lwXform, wlXform));
                    currCurve = new Path2D.Double();
                }
                currNumSegments = 0;
            } else {
                ++currNumSegments;
            }
            switch (command) {
                case 0: {
                    ((Path2D)currCurve).moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    ((Path2D)currCurve).lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    ((Path2D)currCurve).quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    ((Path2D)currCurve).curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    currCurve.closePath();
                }
            }
            it.next();
        }
        if (currNumSegments > 0) {
            curves.add(new ShapeCurve(currCurve, lwXform, wlXform));
        }
    }

    private static Point3d xform(Matrix4d lwXform, Point2d p) {
        Point3d p3d = new Point3d(p.x, p.y, 0.0);
        lwXform.transform(p3d);
        return p3d;
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        new GeomGroup(this.explode(new ArrayList<IGeom>())).pickBox(source, filter, region, isects);
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        for (IGeom geom : this.explode(new ArrayList<IGeom>())) {
            geom.find(test, result);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        for (IGeom geom : this.explode(new ArrayList<IGeom>())) {
            geom.getAll(result);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        new GeomGroup(this.explode(new ArrayList<IGeom>())).pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    private static void pickPoints(IPrimitive primSrc, IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester, Shape shape, Matrix4d lwXform, Matrix4d wlXform) {
        boolean faces;
        GeomType fType;
        GeomType eType;
        GeomType vType;
        if (shape instanceof Area) {
            vType = GeomType.FACE_VERTEX;
            eType = GeomType.FACE_EDGE;
            fType = GeomType.FACE;
        } else {
            vType = GeomType.EDGE_VERTEX;
            eType = GeomType.EDGE;
            fType = null;
        }
        boolean verts = filter.acceptGeomType(source, vType);
        boolean edges = filter.acceptGeomType(source, eType);
        boolean bl = faces = fType != null && filter.acceptGeomType(source, fType);
        if (!(verts || edges || faces)) {
            return;
        }
        if (edges || faces) {
            rayBegin = Util3D.xform(wlXform, rayBegin);
            rayEnd = Util3D.xform(wlXform, rayEnd);
            rayDirN = Util3D.xform(wlXform, rayDirN);
            rayDirN.normalize();
        }
        if (verts) {
            ShapeGeom.getVerts(primSrc, isects, source, vType, shape, lwXform);
        }
        if (edges) {
            ShapeGeom.getClosestToEdges(primSrc, isects, source, rayBegin, rayEnd, rayDirN, eType, shape, lwXform);
        }
        if (faces) {
            ShapeGeom.getFaceIsect((IFace)primSrc, isects, source, rayBegin, rayEnd, rayDirN, shape, lwXform);
        }
    }

    private static void getVerts(IPrimitive primSrc, IIsectCollector isects, Object source, GeomType vType, Shape shape, Matrix4d lwXform) {
        PathIterator path = shape.getPathIterator(null);
        double[] coords = new double[6];
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    isects.addNonFace(source, ShapeUtil.extract3d(lwXform, coords, 0), vType);
                }
            }
            path.next();
        }
    }

    private static void getClosestToEdges(IPrimitive primSrc, IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, GeomType eType, Shape shape, Matrix4d lwXform) {
        Point3d zIsect = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(zIsect, rayBegin, rayDirN, 0.0, 1.0E-9)) {
            return;
        }
        Point2d point = new Point2d(zIsect.x, zIsect.y);
        double[] coords = new double[6];
        Point2d firstPoint = null;
        Point2d lastPoint = null;
        PathIterator path = shape.getPathIterator(null);
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    lastPoint = firstPoint = ShapeUtil.extract2d(coords, 0);
                    break;
                }
                case 1: {
                    Point2d currPoint = ShapeUtil.extract2d(coords, 0);
                    Point2d closest = Inter2D.nearestToLineSeg(point, lastPoint, currPoint);
                    isects.addNonFace(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType);
                    lastPoint = currPoint;
                    break;
                }
                case 2: {
                    Point2d p1 = ShapeUtil.extract2d(coords, 0);
                    Point2d p2 = ShapeUtil.extract2d(coords, 2);
                    Point2d closest = ShapeGeom.nearestToQuadraticSpline(point, lastPoint, p1, p2);
                    isects.addNonFace(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType);
                    lastPoint = p2;
                    break;
                }
                case 3: {
                    Point2d p1 = ShapeUtil.extract2d(coords, 0);
                    Point2d p2 = ShapeUtil.extract2d(coords, 2);
                    Point2d p3 = ShapeUtil.extract2d(coords, 4);
                    Point2d closest = ShapeGeom.nearestToCubicSpline(point, lastPoint, p1, p2, p3);
                    isects.addNonFace(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType);
                    lastPoint = p3;
                    break;
                }
                case 4: {
                    if (lastPoint.equals(firstPoint)) break;
                    Point2d closest = Inter2D.nearestToLineSeg(point, lastPoint, firstPoint);
                    isects.addNonFace(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType);
                }
            }
            path.next();
        }
    }

    private static Point2d nearestToQuadraticSpline(Point2d tp, Point2d cp, Point2d p1, Point2d p2) {
        Spline2D.Quadratic spline = new Spline2D.Quadratic(cp, p1, p2);
        double t = spline.getClosestT(tp);
        return spline.get(t);
    }

    private static Point2d nearestToCubicSpline(Point2d tp, Point2d cp, Point2d p1, Point2d p2, Point2d p3) {
        Spline2D.Cubic spline = new Spline2D.Cubic(cp, p1, p2, p3);
        double t = spline.getClosestT(tp);
        return spline.get(t);
    }

    private static void getFaceIsect(IFace primSrc, IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, Shape shape, Matrix4d lwXform) {
        Point3d zIsect = new Point3d();
        if (Inter3D.lineZPlaneIntersection(zIsect, rayBegin, rayDirN, 0.0, 1.0E-9) && shape.contains(new Point2D.Double(zIsect.x, zIsect.y))) {
            isects.addFace(source, ShapeUtil.xform(lwXform, zIsect.x, zIsect.y), 0, () -> primSrc, () -> {
                Vector3d norm = primSrc instanceof AreaFace && ((AreaFace)iFace).flipped ? GeomConstants.VEC3D_ZNEG : GeomConstants.VEC3D_ZPOS;
                return Util3D.xform(lwXform, norm);
            });
        }
    }

    public static class ShapeCurve
    extends ShapePrimitive<Shape>
    implements ICurve {
        private static final long serialVersionUID = -7694351870829991193L;

        public ShapeCurve(Shape shape, Matrix4d lwXform, Matrix4d wlXform) {
            super(shape, lwXform, wlXform);
        }

        @Override
        protected int getPrimType() {
            return 2;
        }

        @Override
        public ICurve optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public ShapeCurve reverse() {
            return new ShapeCurve(ShapeUtil.reverseBoundary(this.shape), this.lwXform, this.wlXform);
        }

        @Override
        public Point3d project(Point3d p, double tol) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICurve transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d newXform = new Matrix4d(ti.getMatrix());
            newXform.mul(this.lwXform);
            return new ShapeCurve(this.shape, newXform, ShapeGeom.invert(newXform));
        }

        @Override
        public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
            if (filter.acceptGeomType(source, GeomType.EDGE) || filter.acceptGeomType(source, GeomType.EDGE_VERTEX)) {
                this.getSegments(0.001).pickBox(source, filter, region, isects);
            }
        }

        @Override
        public Mesh getSegments(double errorTol) {
            double[] coords = new double[6];
            Point3d firstPoint = null;
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            PathIterator path = ShapeUtil.getPathIterator(this.shape, null, errorTol);
            while (!path.isDone()) {
                int type = path.currentSegment(coords);
                switch (type) {
                    case 0: {
                        assert (points.isEmpty());
                        firstPoint = ShapeUtil.extract3d(this.lwXform, coords, 0);
                        points.add(firstPoint);
                        break;
                    }
                    case 4: {
                        points.add(firstPoint);
                        break;
                    }
                    case 1: {
                        points.add(ShapeUtil.extract3d(this.lwXform, coords, 0));
                    }
                }
                path.next();
            }
            Point3d[] verts = points.toArray(new Point3d[points.size()]);
            int numSegs = verts.length - 1;
            int[] ixes = new int[numSegs * 2];
            int ixix = 0;
            for (int m = 0; m < numSegs; ++m) {
                ixes[ixix++] = m;
                ixes[ixix++] = m + 1;
            }
            return new Mesh(verts, ixes, 1);
        }
    }

    public static class AreaFace
    extends ShapePrimitive<Area>
    implements IPlanarFace {
        private static final long serialVersionUID = 1L;
        public final boolean flipped;

        public AreaFace(Area area, Matrix4d lwXform, Matrix4d wlXform, boolean flipped) {
            super(area, lwXform, wlXform);
            this.flipped = flipped;
        }

        @Override
        public IFace optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public IFace flipOrient() {
            Area newArea = ShapeUtil.reverseBoundary((Area)this.shape);
            return new AreaFace(newArea, this.lwXform, this.wlXform, !this.flipped);
        }

        @Override
        public IPolygon toPoly(double edgeTol) {
            IPolygon poly = AreaUtil.toPoly((Area)this.shape, this.lwXform, edgeTol);
            if (this.flipped) {
                poly = poly.flipOrient();
            }
            return poly;
        }

        @Override
        public Plane3d getPlaneIfValid(boolean ccw) {
            Plane3d plane = Util.getPlane(this.lwXform);
            if (this.flipped == ccw) {
                plane = plane.negate();
            }
            return plane;
        }

        @Override
        protected int getPrimType() {
            return 1;
        }

        @Override
        public Point3d project(Point3d p) {
            return Util.getPlane(this.lwXform).projectOntoPlane(p);
        }

        @Override
        public IFace.PointClassify classify(Point3d p, double tol) {
            Matrix4d wl = this.wlXform;
            p = Util3D.xform(wl, p);
            return ((Area)this.shape).contains(p.x, p.y) ? IFace.PointClassify.INSIDE : IFace.PointClassify.OUTSIDE;
        }

        @Override
        public void getBoundary(List<ICurve> boundary) {
            ShapeGeom.getCurves(boundary, this.shape, this.lwXform, this.wlXform);
        }

        @Override
        public IFace transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d newXform = new Matrix4d(ti.getMatrix());
            newXform.mul(this.lwXform);
            return new AreaFace((Area)this.shape, newXform, ShapeGeom.invert(newXform), this.flipped);
        }

        @Override
        public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
            if (filter.acceptGeomType(source, GeomType.FACE) || filter.acceptGeomType(source, GeomType.FACE_EDGE) || filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
                IPolygon poly = AreaUtil.toPoly((Area)this.shape, this.lwXform, 0.001);
                poly.pickBox(source, filter, region, isects);
            }
        }

        @Override
        public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
            IPolygon poly = AreaUtil.toPoly((Area)this.shape, this.lwXform, errorTol);
            return poly.triangulate(errorTol, ccw);
        }
    }

    public static abstract class ShapePrimitive<T extends Shape>
    extends APrimitive {
        private static final long serialVersionUID = 7214927285832809884L;
        public final T shape;
        public final Matrix4d lwXform;
        public final Matrix4d wlXform;

        public ShapePrimitive(T shape, Matrix4d lwXform, Matrix4d wlXform) {
            this.shape = shape;
            this.lwXform = lwXform;
            this.wlXform = wlXform;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            AABox box = ShapeUtil.getBounds(this.shape, this.lwXform);
            aabb.add(box);
            return aabb;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.FREE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.FREE;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            ShapeGeom.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester, this.shape, this.lwXform, this.wlXform);
        }
    }
}

