/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class Quad
extends AFace
implements IPolygon {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;
    public final Point3d p4;

    public Quad(Point3d p1, Point3d p2, Point3d p3, Point3d p4) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
    }

    @Override
    public Quad optimize(IPointOptimizer pool) {
        Point3d np1 = pool.getExisting(this.p1);
        Point3d np2 = pool.getExisting(this.p2);
        Point3d np3 = pool.getExisting(this.p3);
        Point3d np4 = pool.getExisting(this.p4);
        return np1 != this.p1 || np2 != this.p2 || np3 != this.p3 || np4 != this.p4 ? new Quad(np1, np2, np3, np4) : this;
    }

    @Override
    public Quad flipOrient() {
        return new Quad(this.p4, this.p3, this.p2, this.p1);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.p1);
        aabb.add(this.p2);
        aabb.add(this.p3);
        aabb.add(this.p4);
        return aabb;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public Quad transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        return new Quad(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2), Util3D.xform(xform, this.p3), Util3D.xform(xform, this.p4));
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int loop) {
        return 4;
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        switch (ix) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
            case 3: {
                return this.p4;
            }
        }
        return null;
    }

    @Override
    public Plane3d getPlane(boolean ccw) {
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(this.p1, this.p2, this.p3, this.p4), ccw, 0.0);
        if (plane != null) {
            return plane;
        }
        return new Plane3d(GeomConstants.VEC3D_ZERO, this.p1);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean ccw) {
        return Util3D.simplePolygonPlane(Arrays.asList(this.p1, this.p2, this.p3, this.p4), ccw, 0.0);
    }

    @Override
    public Vector3d getNormalIfValid(boolean ccw) {
        return Util3D.simplePolygonNormal(Arrays.asList(this.p1, this.p2, this.p3, this.p4), ccw, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        Point3d[] verts = new Point3d[]{this.p1, this.p2, this.p3, this.p4};
        int[] indices = new int[]{0, 1, 3, 3, 1, 2};
        return new Pair<Mesh, Boolean>(new Mesh(verts, indices, 2), ccw);
    }
}

