/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.util.HashPool;

public class PoolOptimizer
implements IPointOptimizer {
    public final HashPool<Point3d> point3dPool;
    public final HashPool<Vector3d> vector3dPool;
    public final HashPool<Point2d> point2dPool;
    public final HashPool<Vector2d> vector2dPool;

    public PoolOptimizer() {
        this(new HashPool<Point3d>(), new HashPool<Vector3d>(), new HashPool<Point2d>(), new HashPool<Vector2d>());
    }

    public PoolOptimizer(HashPool<Point3d> point3dPool, HashPool<Vector3d> vector3dPool, HashPool<Point2d> point2dPool, HashPool<Vector2d> vector2dPool) {
        this.point2dPool = point2dPool;
        this.vector3dPool = vector3dPool;
        this.point3dPool = point3dPool;
        this.vector2dPool = vector2dPool;
    }

    @Override
    public <T extends Tuple2d> T getExisting(T p) {
        if (p instanceof Point2d) {
            return (T)((Tuple2d)this.point2dPool.getExisting((Point2d)p));
        }
        return (T)((Tuple2d)this.vector2dPool.getExisting((Vector2d)p));
    }

    @Override
    public <T extends Tuple3d> T getExisting(T p) {
        if (p instanceof Point3d) {
            return (T)((Tuple3d)this.point3dPool.getExisting((Point3d)p));
        }
        return (T)((Tuple3d)this.vector3dPool.getExisting((Vector3d)p));
    }
}

