/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class Point
extends APrimitive
implements IPrimitive,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d loc;

    public Point(Point3d location) {
        this.loc = location;
    }

    @Override
    public Point optimize(IPointOptimizer pool) {
        Point3d nloc = pool.getExisting(this.loc);
        return nloc != this.loc ? new Point(nloc) : this;
    }

    public int hashCode() {
        return 65087 + this.loc.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Point && ((Point)o).loc.equals((Tuple3d)this.loc);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.loc);
        return aabb;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IPrimitive transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        return new Point(Util3D.xform(ti.getMatrix(), this.loc));
    }

    @Override
    protected int getPrimType() {
        return 4;
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        if (filter.acceptGeomType(source, GeomType.VERTEX) && region.contains(this.loc, 1.0E-6)) {
            isects.addNonFace(source);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (filter.acceptGeomType(source, GeomType.VERTEX)) {
            isects.addNonFace(source, this.loc, GeomType.VERTEX);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private Point geom;

        public Handle(Point geom) {
            this.geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.geom);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            this.geom = new Point(newLoc);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

