/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class PlanarSurface
extends AFace {
    private static final long serialVersionUID = 1L;
    public final Plane3d plane;
    private static final AABox s_infBox = new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public PlanarSurface(Plane3d plane) {
        this.plane = plane;
    }

    @Override
    public PlanarSurface flipOrient() {
        return new PlanarSurface(this.plane.negate());
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        boolean x0 = theUtil.eq0(this.plane.x, 1.0E-9);
        boolean y0 = theUtil.eq0(this.plane.y, 1.0E-9);
        if (x0 && y0) {
            aabb.add(new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.z * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.z * this.plane.w));
            return aabb;
        }
        boolean z0 = theUtil.eq0(this.plane.z, 1.0E-9);
        if (x0 && z0) {
            aabb.add(new AABox(Double.NEGATIVE_INFINITY, -this.plane.y * this.plane.w, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.y * this.plane.w, Double.POSITIVE_INFINITY));
            return aabb;
        }
        if (y0 && z0) {
            aabb.add(new AABox(-this.plane.x * this.plane.w, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.x * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            return aabb;
        }
        aabb.add(s_infBox);
        return aabb;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IFace optimize(IPointOptimizer pool) {
        return this;
    }

    @Override
    public IFace transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        return new PlanarSurface(this.plane.transformBy(ti.getMatrix()));
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2), ccw);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        if (filter.acceptGeomType(source, GeomType.FACE)) {
            // empty if block
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Point3d p;
        if (filter.acceptGeomType(source, GeomType.FACE) && (p = Inter3D.lineSegPlaneIntersection(rayBegin, rayEnd, this.plane, 1.0E-6)) != null) {
            isects.addFace(source, p, 0, () -> this, this.plane::getNormal);
        }
    }

    @Override
    public Point3d project(Point3d p) {
        return this.plane.projectOntoPlane(p);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        return IFace.PointClassify.INSIDE;
    }
}

