/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class Mesh
implements IGeom,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte PT_POINTS = 0;
    public static final byte PT_LINESEGS = 1;
    public static final byte PT_TRIANGLES = 2;
    public static final byte PT_QUADS = 3;
    public static final int FLAG_SMOOTHNORMALS = 2;
    public static final int FLAG_SOLID = 4;
    public final byte primtype;
    public final Point3d[] vertices;
    public final int[] indices;
    public final int flags;

    public Mesh(Point3d[] vertices, int[] indices, byte primType) {
        this(vertices, indices, primType, 0);
    }

    public Mesh(Point3d[] vertices, int[] indices, byte primType, int flags) {
        assert (indices.length % Mesh.getNumVertsPerElement(primType) == 0);
        this.vertices = vertices;
        this.indices = indices;
        this.flags = flags;
        this.primtype = primType;
    }

    @Override
    public IGeom optimize(IPointOptimizer pool) {
        int numPrims = this.getNumPrims(7);
        if (numPrims == 1) {
            return this.getPrimitive(0).optimize(pool);
        }
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean changed = false;
        Point3d[] npoints = new Point3d[this.vertices.length];
        for (int m = 0; m < this.vertices.length; ++m) {
            npoints[m] = pool.getExisting(this.vertices[m]);
            changed |= npoints[m] != this.vertices[m];
        }
        return changed ? new Mesh(npoints, this.indices, this.primtype, this.flags) : this;
    }

    public Mesh toSolid() {
        if (this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags | 4);
    }

    public Mesh toShell() {
        if (!this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags & 0xFFFFFFFB);
    }

    public boolean testFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public int getNumVertsPerPrim() {
        return Mesh.getNumVertsPerElement(this.primtype);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.vertices);
        return aabb;
    }

    @Override
    public boolean getBakeTransform() {
        return this.getNumPrims(7) == 1;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        return new Mesh(GeomUtil.xformVerts(this.vertices, ti.getMatrix()), this.indices, this.primtype, this.flags);
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return !this.testFlag(4);
    }

    public static int getNumVertsPerElement(byte type) {
        switch (type) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        if ((types & 1) != 0 && (this.primtype == 2 || this.primtype == 3)) {
            return this.indices.length / Mesh.getNumVertsPerElement(this.primtype);
        }
        if ((types & 2) != 0 && this.primtype == 1) {
            return this.indices.length / 2;
        }
        if ((types & 4) != 0 && this.primtype == 0) {
            return this.indices.length;
        }
        return 0;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        Point3d[] verts = this.vertices;
        switch (this.primtype) {
            case 0: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    prims.add(new Point(p1));
                }
                break;
            }
            case 1: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    Point3d p2 = verts[this.indices[ix++]];
                    prims.add(new LineSeg(p1, p2));
                }
                break;
            }
            case 2: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    Point3d p2 = verts[this.indices[ix++]];
                    Point3d p3 = verts[this.indices[ix++]];
                    prims.add(new Triangle(p1, p2, p3));
                }
                break;
            }
            case 3: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    Point3d p2 = verts[this.indices[ix++]];
                    Point3d p3 = verts[this.indices[ix++]];
                    Point3d p4 = verts[this.indices[ix++]];
                    prims.add(new Quad(p1, p2, p3, p4));
                }
                break;
            }
        }
        return prims;
    }

    public boolean isValid() {
        for (int i : this.indices) {
            if (i < this.vertices.length && i >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        return this.testClosed().v1 == ClosedTest.CLOSED;
    }

    public Pair<ClosedTest, Object> testClosed() {
        int elCount;
        if (this.primtype != 2 && this.primtype != 3) {
            return new Pair<ClosedTest, Object>(ClosedTest.WRONG_TYPE, null);
        }
        int n = elCount = this.primtype == 2 ? 3 : 4;
        if (this.indices.length == elCount) {
            return new Pair<ClosedTest, Object>(ClosedTest.ONE_FACE, null);
        }
        LinkedHashMap<EdgeHash, Integer> edgeCounts = new LinkedHashMap<EdgeHash, Integer>();
        for (int m = 0; m < this.indices.length; m += elCount) {
            for (int n2 = 0; n2 < elCount; ++n2) {
                int e1 = this.indices[m + n2];
                int e2 = this.indices[m + (n2 + 1) % elCount];
                EdgeHash edge = new EdgeHash(e1, e2);
                Integer count = (Integer)edgeCounts.get(edge);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                edgeCounts.put(edge, count);
            }
        }
        for (Map.Entry entry : edgeCounts.entrySet()) {
            int adjCount = (Integer)entry.getValue();
            if (adjCount > 1) continue;
            Point3d e1 = this.vertices[((EdgeHash)entry.getKey()).e1];
            Point3d e2 = this.vertices[((EdgeHash)entry.getKey()).e2];
            return new Pair<ClosedTest, Point3d[]>(ClosedTest.EDGE_OPEN, new Point3d[]{e1, e2});
        }
        return new Pair<ClosedTest, Object>(ClosedTest.CLOSED, null);
    }

    public static Mesh merge(Mesh ... meshes) {
        if (meshes.length == 0) {
            return new Mesh(new Point3d[0], new int[0], 0);
        }
        byte type = meshes[0].primtype;
        LinkedHashMap<Point3d, Integer> pmap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> ixes = new ArrayList<Integer>();
        for (Mesh mesh : meshes) {
            assert (mesh.primtype == type);
            int[] vixes = new int[mesh.vertices.length];
            for (int m = 0; m < mesh.vertices.length; ++m) {
                Point3d p = mesh.vertices[m];
                Integer ix = (Integer)pmap.get(p);
                if (ix == null) {
                    ix = pmap.size();
                    pmap.put(p, ix);
                }
                vixes[m] = ix;
            }
            for (int ix : mesh.indices) {
                ixes.add(vixes[ix]);
            }
        }
        return new Mesh(pmap.keySet().toArray(new Point3d[pmap.size()]), theUtil.toIntArray(ixes), type);
    }

    public List<IPrimitive> getPrimitives() {
        return new PrimList(this);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        switch (this.primtype) {
            case 0: {
                if (!filter.acceptGeomType(source, GeomType.VERTEX)) break;
                for (int m = 0; m < this.indices.length; ++m) {
                    if (!region.contains(this.vertices[this.indices[m]])) continue;
                    isects.addNonFace(source);
                }
                break;
            }
            case 1: {
                if (filter.acceptGeomType(source, GeomType.EDGE)) {
                    int m = 0;
                    while (m < this.indices.length) {
                        Point3d p2;
                        Point3d p1;
                        if (!region.intersectsLineSeg(p1 = this.vertices[this.indices[m++]], p2 = this.vertices[this.indices[m++]], 1.0E-6)) continue;
                        isects.addNonFace(source);
                    }
                } else {
                    if (!filter.acceptGeomType(source, GeomType.EDGE_VERTEX)) break;
                    for (Point3d p : this.vertices) {
                        if (!region.contains(p, 1.0E-6)) continue;
                        isects.addNonFace(source);
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (filter.acceptGeomType(source, GeomType.FACE)) {
                    Point3d[] meshFace = new Point3d[Mesh.getNumVertsPerElement(this.primtype)];
                    int primIx = 0;
                    Plane3d plane = new Plane3d();
                    int m = 0;
                    while (m < this.indices.length) {
                        for (int n = 0; n < meshFace.length; ++n) {
                            meshFace[n] = this.vertices[this.indices[m++]];
                        }
                        plane.set(true, meshFace);
                        if (plane.isValid() && region.intersectsConvexPoly(1.0E-6, plane, meshFace)) {
                            Point3d[] face = Arrays.copyOf(meshFace, meshFace.length);
                            Vector3d normal = plane.getNormal();
                            isects.addFace(source, primIx, () -> new Pair<Point3d, Vector3d>(Util3D.simplePolygonCentroid(face), normal));
                        }
                        ++primIx;
                    }
                } else if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
                    int vertsPerPrim = Mesh.getNumVertsPerElement(this.primtype);
                    for (int m = 0; m < this.indices.length; m += vertsPerPrim) {
                        for (int n = 0; n < vertsPerPrim; ++n) {
                            Point3d p1 = this.vertices[this.indices[m + n]];
                            Point3d p2 = this.vertices[this.indices[m + (n + 1) % vertsPerPrim]];
                            if (!region.intersectsLineSeg(p1, p2, 1.0E-6)) continue;
                            isects.addNonFace(source);
                        }
                    }
                } else {
                    if (!filter.acceptGeomType(source, GeomType.FACE_VERTEX)) break;
                    for (Point3d p : this.vertices) {
                        if (!region.contains(p)) continue;
                        isects.addNonFace(source);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        GeomType vType = null;
        GeomType eType = null;
        GeomType fType = null;
        switch (this.primtype) {
            case 0: {
                vType = GeomType.VERTEX;
                break;
            }
            case 1: {
                vType = GeomType.EDGE_VERTEX;
                eType = GeomType.EDGE;
                break;
            }
            case 2: 
            case 3: {
                vType = GeomType.FACE_VERTEX;
                eType = GeomType.FACE_EDGE;
                fType = GeomType.FACE;
            }
        }
        if (vType != null && filter.acceptGeomType(source, vType)) {
            this.pickVerts(isects, source, vType);
        }
        if (eType != null && filter.acceptGeomType(source, eType)) {
            this.pickEdges(isects, source, rayBegin, rayEnd, rayDirN, tester);
        }
        if (fType != null && filter.acceptGeomType(source, fType)) {
            this.pickFaces(isects, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    private void pickVerts(IIsectCollector isects, Object source, GeomType vType) {
        for (Point3d p : this.vertices) {
            isects.addNonFace(source, p, vType);
        }
    }

    private void pickEdges(IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        AABox testBounds = new AABox();
        if (this.primtype == 1) {
            int m = 0;
            while (m < this.indices.length) {
                Point3d p1 = this.vertices[this.indices[m++]];
                Point3d p2 = this.vertices[this.indices[m++]];
                testBounds.reset();
                testBounds.add(p1, p2);
                if (!tester.test((AABox)testBounds).positive) continue;
                double[] isect = Inter3D.getNearestTLinesegLineSeg(rayBegin, rayEnd, p1, p2, 1.0E-6);
                if (isect != null) {
                    isects.addNonFace(source, Util3D.linesegPoint(p1, p2, isect[1]), GeomType.EDGE);
                    continue;
                }
                isects.getProgress().check();
            }
        } else {
            int vPerPrim = this.getNumVertsPerPrim();
            for (int m = 0; m < this.indices.length; m += vPerPrim) {
                for (int n = 0; n < vPerPrim; ++n) {
                    int i1 = this.indices[m + n];
                    int i2 = this.indices[m + (n + 1) % vPerPrim];
                    Point3d p1 = this.vertices[i1];
                    Point3d p2 = this.vertices[i2];
                    testBounds.reset();
                    testBounds.add(p1, p2);
                    if (!tester.test((AABox)testBounds).positive) continue;
                    double[] isect = Inter3D.getNearestTLinesegLineSeg(rayBegin, rayEnd, p1, p2, 1.0E-6);
                    if (isect != null) {
                        isects.addNonFace(source, Util3D.linesegPoint(p1, p2, isect[1]), GeomType.FACE_EDGE);
                        continue;
                    }
                    isects.getProgress().check();
                }
            }
        }
    }

    private void pickFaces(IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Plane3d plane = new Plane3d();
        int vPerPrim = this.getNumVertsPerPrim();
        Point3d[] parr = new Point3d[vPerPrim];
        int primIx = 0;
        int m = 0;
        while (m < this.indices.length) {
            for (int n = 0; n < vPerPrim; ++n) {
                parr[n] = this.vertices[this.indices[m + n]];
            }
            plane.set(0.0, true, parr);
            if (plane.isValid()) {
                Point3d isect = Inter3D.lineSegPlaneIntersection(rayBegin, rayEnd, plane, 1.0E-6);
                if (isect != null && Inter3D.pointInPoly(1.0E-6, isect, parr)) {
                    Vector3d normal = plane.getNormal();
                    Point3d[] points = Arrays.copyOf(parr, parr.length);
                    isects.addFace(source, isect, primIx, () -> PolyUtil.newPoly(points), () -> normal);
                } else {
                    isects.getProgress().check();
                }
            }
            m += vPerPrim;
            ++primIx;
        }
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        AABox testBox = new AABox();
        for (IGeom prim : this.explode(new ArrayList<IGeom>(this.getNumPrims(7)))) {
            testBox.reset();
            prim.getBoundingBox(testBox);
            Containment ctmt = test.test(testBox);
            if (!ctmt.positive) continue;
            result.mark((IPrimitive)prim, ctmt);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        for (IGeom prim : this.explode(new ArrayList<IGeom>(this.getNumPrims(7)))) {
            result.mark((IPrimitive)prim, Containment.INSIDE);
        }
    }

    public Fixer getFixes() {
        if (this.primtype != 3) {
            return new Fixer();
        }
        Point3d[] verts = new Point3d[4];
        Fixer fixer = new Fixer(this.indices.length);
        int primix = 0;
        int m = 0;
        while (m < this.indices.length) {
            for (int n = 0; n < 4; ++n) {
                verts[n] = this.vertices[this.indices[m++]];
            }
            boolean merged = false;
            for (int n = 0; n < 4; ++n) {
                Point3d p1 = verts[n];
                Point3d p2 = verts[GeomUtil.PLUS1MOD4[n]];
                if (!p1.equals((Tuple3d)p2)) continue;
                fixer.addMerge(primix, n);
                merged = true;
            }
            if (!merged && !Util3D.areCoplanar(1.0E-6, verts)) {
                fixer.addSplit(primix);
            }
            ++primix;
        }
        return fixer;
    }

    public Mesh fix() {
        Fixer fixer = this.getFixes();
        return fixer.fix(this);
    }

    private static int addTri(int[] ixes, int start, int i) {
        ixes[start++] = i;
        return start;
    }

    private static int addTri(int[] ixes, int start, int i1, int i2, int i3) {
        ixes[start++] = i1;
        ixes[start++] = i2;
        ixes[start++] = i3;
        return start;
    }

    public IPrimitive getPrimitive(int ix) {
        int vertsPer = Mesh.getNumVertsPerElement(this.primtype);
        int i1 = vertsPer * ix;
        switch (this.primtype) {
            case 0: {
                return new Point(this.vertices[this.indices[i1]]);
            }
            case 1: {
                Point3d p1 = this.vertices[this.indices[i1++]];
                Point3d p2 = this.vertices[this.indices[i1++]];
                return new LineSeg(p1, p2);
            }
            case 2: {
                Point3d p1 = this.vertices[this.indices[i1++]];
                Point3d p2 = this.vertices[this.indices[i1++]];
                Point3d p3 = this.vertices[this.indices[i1++]];
                return new Triangle(p1, p2, p3);
            }
            case 3: {
                Point3d p1 = this.vertices[this.indices[i1++]];
                Point3d p2 = this.vertices[this.indices[i1++]];
                Point3d p3 = this.vertices[this.indices[i1++]];
                Point3d p4 = this.vertices[this.indices[i1++]];
                return new Quad(p1, p2, p3, p4);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<VertHandle> handles = new ArrayList<VertHandle>(this.vertices.length);
        for (int m = 0; m < this.vertices.length; ++m) {
            handles.add(new VertHandle(this, m));
        }
        return handles;
    }

    private static class VertHandle
    implements IHandle {
        private Mesh d_geom;
        private final int d_vertIx;
        private Point3d[] t_verts;

        public VertHandle(Mesh geom, int vertIx) {
            this.d_geom = geom;
            this.d_vertIx = vertIx;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof VertHandle && ((VertHandle)obj).d_vertIx == this.d_vertIx;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.d_geom.vertices[this.d_vertIx]));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_verts = Arrays.copyOf(this.d_geom.vertices, this.d_geom.vertices.length);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            this.t_verts[this.d_vertIx] = newLoc;
            this.d_geom = new Mesh(this.t_verts, this.d_geom.indices, this.d_geom.primtype, this.d_geom.flags);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }

    public static class Fixer {
        private final int d_numIxes;
        private int[] d_mergePrims = null;
        private int d_numMerges = 0;

        private Fixer() {
            this(0);
        }

        private Fixer(int numIxes) {
            this.d_numIxes = numIxes;
        }

        private void addMerge(int primix, int vertix) {
            if (this.d_mergePrims == null) {
                this.d_mergePrims = new int[this.d_numIxes / 4];
                Arrays.fill(this.d_mergePrims, -1);
            }
            this.d_mergePrims[primix] = vertix;
            if (vertix != -1) {
                ++this.d_numMerges;
            }
        }

        private void addSplit(int primix) {
            this.addMerge(primix, -1);
        }

        public Mesh fix(Mesh mesh) {
            int[] newixes = this.fixMeshIndices(ElementMesh.Mapping.PER_PRIM_VERTEX, mesh.indices, null);
            if (newixes == mesh.indices) {
                return mesh;
            }
            return new Mesh(mesh.vertices, newixes, 2, mesh.flags);
        }

        public <ElemT> ElementMesh<ElemT> fixVertElements(ElementMesh<ElemT> mesh) {
            return this.fixElements(mesh, null);
        }

        public <ElemT> ElementMesh<ElemT> fixEdgeElements(ElementMesh<ElemT> mesh, IntUnaryOperator newEdgeOp) {
            return this.fixElements(mesh, newEdgeOp);
        }

        private <ElemT> ElementMesh<ElemT> fixElements(ElementMesh<ElemT> mesh, IntUnaryOperator newEdgeOp) {
            int[] newixes = this.fixMeshIndices(mesh.mapping, mesh.indices, newEdgeOp);
            if (newixes == mesh.indices) {
                return mesh;
            }
            return new ElementMesh(mesh.mapping, mesh.elements, newixes, 3);
        }

        public boolean needsMeshCorrection() {
            return this.d_mergePrims != null;
        }

        private int[] fixMeshIndices(ElementMesh.Mapping mapping, int[] indices, IntUnaryOperator newEdgeOp) {
            if (this.d_mergePrims == null || mapping == ElementMesh.Mapping.ALL_SAME) {
                return indices;
            }
            int numSplits = this.d_numIxes / 4 - this.d_numMerges;
            if (numSplits == 0 && mapping != ElementMesh.Mapping.PER_PRIM_VERTEX) {
                return indices;
            }
            assert (indices.length == this.d_numIxes || indices.length == 0);
            int numNewFaces = this.d_numMerges + numSplits * 2;
            int[] newIndices = new int[mapping == ElementMesh.Mapping.PER_PRIM ? numNewFaces : numNewFaces * 3];
            int newIxCount = 0;
            int primix = 0;
            int m = 0;
            int eix = 0;
            while (m < this.d_numIxes) {
                block0 : switch (mapping) {
                    case PER_PRIM: {
                        int i;
                        switch (indices.length) {
                            case 0: {
                                i = m++;
                                break;
                            }
                            default: {
                                i = indices[m++];
                            }
                        }
                        switch (this.d_mergePrims[primix]) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                newIxCount = Mesh.addTri(newIndices, newIxCount, i);
                                break block0;
                            }
                        }
                        newIxCount = Mesh.addTri(newIndices, newIxCount, i);
                        newIxCount = Mesh.addTri(newIndices, newIxCount, i);
                        break;
                    }
                    case PER_PRIM_VERTEX: {
                        int i4;
                        int i3;
                        int i2;
                        int i1;
                        switch (indices.length) {
                            case 0: {
                                i1 = m++;
                                i2 = m++;
                                i3 = m++;
                                i4 = m++;
                                break;
                            }
                            default: {
                                i1 = indices[m++];
                                i2 = indices[m++];
                                i3 = indices[m++];
                                i4 = indices[m++];
                            }
                        }
                        switch (this.d_mergePrims[primix]) {
                            case 0: {
                                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i3, i4);
                                break block0;
                            }
                            case 1: {
                                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i4);
                                break block0;
                            }
                            case 2: {
                                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i3);
                                break block0;
                            }
                            case 3: {
                                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i3);
                                break block0;
                            }
                        }
                        if (newEdgeOp != null) {
                            int newEdge1 = newEdgeOp.applyAsInt(eix + 2);
                            int newEdge2 = newEdgeOp.applyAsInt(eix);
                            newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, newEdge1);
                            newIxCount = Mesh.addTri(newIndices, newIxCount, newEdge2, i3, i4);
                            break;
                        }
                        newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i3);
                        newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i3, i4);
                        break;
                    }
                }
                ++primix;
                eix += 4;
            }
            assert (newIxCount == newIndices.length);
            return newIndices;
        }

        public boolean needsPropFix() {
            if (this.d_mergePrims == null) {
                return false;
            }
            int numSplits = this.d_numIxes / 4 - this.d_numMerges;
            return numSplits > 0;
        }

        public <T> void fixProps(Iterator<T> oldProps, Consumer<T> newProps) {
            int propCount = this.d_numIxes / 4;
            for (int ix = 0; oldProps.hasNext() && ix < propCount; ++ix) {
                T next = oldProps.next();
                newProps.accept(next);
                if (this.d_mergePrims == null || this.d_mergePrims[ix] != -1) continue;
                newProps.accept(next);
            }
        }
    }

    private static class PrimList
    extends AbstractList<IPrimitive> {
        public final Mesh mesh;
        public final int primCount;

        public PrimList(Mesh mesh) {
            this.mesh = mesh;
            this.primCount = mesh.getNumPrims(7);
        }

        @Override
        public int size() {
            return this.primCount;
        }

        @Override
        public IPrimitive get(int index) {
            return this.mesh.getPrimitive(index);
        }
    }

    private static class EdgeHash {
        private int e1;
        private int e2;

        public EdgeHash() {
        }

        public EdgeHash(int e1, int e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public void set(int e1, int e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public int hashCode() {
            return this.e1 + this.e2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EdgeHash)) {
                return false;
            }
            EdgeHash eh = (EdgeHash)obj;
            return obj instanceof EdgeHash && eh.e1 == this.e1 && eh.e2 == this.e2 || eh.e1 == this.e2 && eh.e2 == this.e1;
        }
    }

    public static enum ClosedTest {
        CLOSED,
        WRONG_TYPE,
        ONE_FACE,
        EDGE_OPEN;

    }
}

