/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.TaskProgress;

public class ManifoldSolid {
    public final IGeom solid;
    public final AABox bounds;
    public final RTree<IFace> search;
    private static final TaskProgress s_progress = new TaskProgress();
    private static final Object s_dummySrc = new Object();
    private static final IIsectFilter s_faceIsectFilter = new IIsectFilter(){

        @Override
        public boolean acceptPickObject(Object obj) {
            return true;
        }

        @Override
        public boolean acceptPickObjType(Class type) {
            return true;
        }

        @Override
        public boolean acceptIntersection(IsectInfo info) {
            return true;
        }

        @Override
        public boolean acceptGeomType(Object source, GeomType type) {
            return type == GeomType.FACE;
        }
    };

    public ManifoldSolid(IGeom solid, boolean calcRTree) {
        this(solid, solid.getBoundingBox(new AABox()), calcRTree);
    }

    public ManifoldSolid(IGeom solid, AABox bounds, boolean calcRTree) {
        this(solid, bounds, calcRTree ? ManifoldSolid.calcRTree(solid) : null);
    }

    public ManifoldSolid(IGeom solid, AABox bounds, RTree<IFace> search) {
        this.solid = solid;
        this.bounds = bounds;
        this.search = search;
    }

    public Collection<IFace> find(ITest<AABox> test) {
        if (this.search != null) {
            ArrayList<IFace> result = new ArrayList<IFace>();
            this.search.find(test, (f, c) -> {
                if (c.positive) {
                    result.add((IFace)f);
                }
            });
            return result;
        }
        return GeomUtil.explode(this.solid, IFace.class);
    }

    private static RTree<IFace> calcRTree(IGeom solid) {
        RTree<IFace> tree = new RTree<IFace>();
        for (IFace face : GeomUtil.explode(solid, IFace.class)) {
            AABox bounds = face.getBoundingBox(new AABox());
            if (!bounds.isValid()) continue;
            tree.insert(bounds, face);
        }
        return tree;
    }

    public PointClassify classify(Point3d p, double tol) {
        Random random = new Random(1L);
        Vector3d testVec = Util3D.newRandomVector(random);
        return ManifoldSolid.classify(this, p, testVec, tol);
    }

    private static PointClassify classify(ManifoldSolid solid, Point3d rayp, Vector3d raydir, double tol) {
        AABox bounds = solid.bounds;
        if (!bounds.contains(rayp, tol)) {
            return PointClassify.OUTSIDE;
        }
        double[] rayIsects = Inter3D.rayAABoxIsect(rayp, raydir, bounds.getMin(), bounds.getMax(), tol);
        if (rayIsects != null) {
            Collection<IFace> potFaces;
            ITest<AABox> tester;
            Point3d p2 = Util3D.linePoint(rayp, raydir, rayIsects[1]);
            if (rayp.epsilonEquals((Tuple3d)p2, tol)) {
                tester = new AABox(rayp);
                potFaces = solid.find(tester);
            } else {
                tester = new LineSegRTreeTest(rayp, p2);
                potFaces = solid.find(tester);
            }
            double p2t = Math.max(1.0, rayIsects[1] * 2.0);
            return ManifoldSolid.classify(potFaces, new LineSeg3D(rayp, Util3D.linePoint(rayp, raydir, p2t)), tester, tol);
        }
        return PointClassify.OUTSIDE;
    }

    private static PointClassify classify(Collection<IFace> faces, LineSeg3D testCurve, ITest<AABox> tester, double tol) {
        int numIsects = 0;
        final ArrayList isectPoints = new ArrayList();
        IIsectCollector isects = new IIsectCollector(){

            @Override
            public TaskProgress getProgress() {
                return s_progress;
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
            }

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                isectPoints.add(p);
            }

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type) {
                isectPoints.add(p);
            }
        };
        Vector3d testDir = testCurve.getDir();
        Util3D.safeNormalize(testDir, tol);
        for (IFace face : faces) {
            isectPoints.clear();
            face.pickPoints(isects, s_faceIsectFilter, s_dummySrc, testCurve.p1, testCurve.p2, testDir, tester);
            if (isectPoints.isEmpty()) continue;
            double mint = isectPoints.stream().mapToDouble(p -> Util3D.tOnLineSeg(lineSeg3D.p1, lineSeg3D.p2, p)).min().getAsDouble();
            if (testCurve.get(mint).epsilonEquals((Tuple3d)testCurve.p1, tol)) {
                return PointClassify.ON_BOUNDARY;
            }
            numIsects += isectPoints.size();
        }
        return numIsects % 2 != 0 ? PointClassify.INSIDE : PointClassify.OUTSIDE;
    }

    public static enum PointClassify {
        INSIDE(true),
        ON_BOUNDARY(true),
        OUTSIDE(false);

        public final boolean positive;

        private PointClassify(boolean positive) {
            this.positive = positive;
        }
    }
}

