/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IParametricCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;

public class LineSeg
extends ACurve
implements ILinearCurve,
IManipulatable,
IParametricCurve {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;

    public LineSeg(Point3d p1, Point3d p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineSeg)) {
            return false;
        }
        return this.equals((LineSeg)obj, true);
    }

    public boolean equals(LineSeg seg, boolean compareOrient) {
        if (seg == this) {
            return true;
        }
        if (!compareOrient) {
            return this.p1.equals((Tuple3d)seg.p1) && this.p2.equals((Tuple3d)seg.p2) || this.p1.equals((Tuple3d)seg.p2) && this.p2.equals((Tuple3d)seg.p1);
        }
        return this.p1.equals((Tuple3d)seg.p1) && this.p2.equals((Tuple3d)seg.p2);
    }

    @Override
    public int getNumVerts() {
        return 2;
    }

    @Override
    public Point3d getVert(int ix) {
        return ix == 0 ? this.p1 : this.p2;
    }

    public double getT(Point3d p) {
        return Util3D.tOnLineSeg(this.p1, this.p2, p);
    }

    @Override
    public Point3d get(double t) {
        return Util3D.linesegPoint(this.p1, this.p2, t);
    }

    @Override
    public LineSeg optimize(IPointOptimizer pool) {
        Point3d np1 = pool.getExisting(this.p1);
        Point3d np2 = pool.getExisting(this.p2);
        return np1 != this.p1 || np2 != this.p2 ? new LineSeg(np1, np2) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.p1);
        aabb.add(this.p2);
        return aabb;
    }

    @Override
    public Vector3d getTangent(double t, ICurve.Orient orient, boolean normalize) {
        Vector3d tan;
        switch (orient) {
            case POSITIVE: {
                tan = Util3D.vector(this.p1, this.p2);
                break;
            }
            default: {
                tan = Util3D.vector(this.p2, this.p1);
            }
        }
        if (normalize) {
            Util3D.safeNormalize(tan, 1.0E-9);
        }
        return tan;
    }

    public Point3d evaluate(double t) {
        if (t == 0.0) {
            return new Point3d(this.p1);
        }
        if (t == 1.0) {
            return new Point3d(this.p2);
        }
        return Util3D.linesegPoint(this.p1, this.p2, t);
    }

    public LineSeg negate() {
        return new LineSeg(this.p2, this.p1);
    }

    public LineSeg trim(double t1, double t2) {
        if (t1 == 0.0 && t2 == 1.0) {
            return this;
        }
        return new LineSeg(this.evaluate(t1), this.evaluate(t2));
    }

    public double length() {
        return this.p1.distance(this.p2);
    }

    public double lengthSq() {
        return this.p1.distanceSquared(this.p2);
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public LineSeg transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        return new LineSeg(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2));
    }

    @Override
    public Mesh getSegments(double errorTol) {
        Point3d[] points = new Point3d[]{this.p1, this.p2};
        return new Mesh(points, new int[]{0, 1}, 1);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        if (filter.acceptGeomType(source, GeomType.EDGE) && region.intersectsLineSeg(this.p1, this.p2, 1.0E-6)) {
            isects.addNonFace(source);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        double[] isect;
        if (filter.acceptGeomType(source, GeomType.EDGE_VERTEX)) {
            isects.addNonFace(source, this.p1, GeomType.EDGE_VERTEX);
            isects.addNonFace(source, this.p2, GeomType.EDGE_VERTEX);
        }
        if (filter.acceptGeomType(source, GeomType.EDGE) && (isect = Inter3D.getNearestTLinesegLineSeg(rayBegin, rayEnd, this.p1, this.p2, 1.0E-6)) != null) {
            Point3d ip = Util3D.linesegPoint(this.p1, this.p2, isect[1]);
            isects.addNonFace(source, ip, GeomType.EDGE);
        }
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        return Inter3D.nearestPointOnLineSeg(this.p1, this.p2, p);
    }

    @Override
    public ILinearCurve newCurve(Point3d ... points) {
        assert (points.length == 2);
        return new LineSeg(points[0], points[1]);
    }

    @Override
    public LineSeg reverse() {
        return new LineSeg(this.p2, this.p1);
    }
}

