/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.TriSurface;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;

public interface IPolygon
extends IPlanarFace,
IManipulatable {
    public int getNumLoops();

    public int getNumPoints(int var1);

    public Point3d getPoint(int var1, int var2);

    default public Vector3d getNormal(boolean ccw) {
        Vector3d normal = this.getNormalIfValid(ccw);
        if (normal != null) {
            return normal;
        }
        return GeomConstants.VEC3D_ZERO;
    }

    public Vector3d getNormalIfValid(boolean var1);

    @Override
    public IPolygon transform(TransformInfo var1, int var2);

    @Override
    public IPolygon optimize(IPointOptimizer var1);

    @Override
    public IPolygon flipOrient();

    @Override
    default public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        PolyUtil.pickBox(source, 0, this, filter, region, isects);
    }

    @Override
    default public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        PolyUtil.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    default public Point3d project(Point3d p) {
        return this.getPlane(true).projectOntoPlane(p);
    }

    @Override
    default public IFace.PointClassify classify(Point3d p, double tol) {
        return PolyUtil.classify(this, p, tol);
    }

    @Override
    default public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }

    @Override
    default public IPolygon toPoly(double edgeTol) {
        return this;
    }

    @Override
    default public void getBoundary(List<ICurve> boundary) {
        PolyUtil.getBoundary(boundary, this);
    }

    default public int getNumVerts() {
        return PolyUtil.getNumVerts(this);
    }

    @Override
    default public boolean getBakeTransform() {
        return true;
    }

    default public Supplier<Point3d> getPointGenerator(Random r) {
        Mesh tris = this.triangulate(0.0);
        TriSurface gen = new TriSurface();
        gen.addTris(tris.vertices, tris.indices);
        return gen.getPointGenerator(r);
    }

    default public Supplier<Point3d> getPointGenerator(Random r, boolean allowEdges, double tol) {
        Supplier<Point3d> gen = this.getPointGenerator(r);
        if (allowEdges) {
            return gen;
        }
        return () -> {
            for (int m = 0; m < 10; ++m) {
                IFace.PointClassify pc;
                Point3d p = (Point3d)gen.get();
                if (p == null || (pc = this.classify(p, tol)) != IFace.PointClassify.INSIDE) continue;
                return p;
            }
            return null;
        };
    }
}

