/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public interface ILinearCurve
extends ICurve,
IManipulatable {
    public int getNumVerts();

    public Point3d getVert(int var1);

    @Override
    public ILinearCurve transform(TransformInfo var1, int var2);

    @Override
    public ILinearCurve optimize(IPointOptimizer var1);

    public ILinearCurve newCurve(Point3d ... var1);

    @Override
    public ILinearCurve reverse();

    @Override
    default public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>(this.getNumVerts());
        for (int m = 0; m < this.getNumVerts(); ++m) {
            handles.add(new Handle(this, m));
        }
        return handles;
    }

    public static class Handle
    implements IHandle {
        private ILinearCurve d_geom;
        private final int d_ix;
        private Point3d[] t_verts;

        public Handle(ILinearCurve geom, int ix) {
            this.d_geom = geom;
            this.d_ix = ix;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_ix == this.d_ix;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.d_geom.getVert(this.d_ix)));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_verts = new Point3d[this.d_geom.getNumVerts()];
            for (int m = 0; m < this.t_verts.length; ++m) {
                this.t_verts[m] = this.d_geom.getVert(m);
            }
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            this.t_verts[this.d_ix] = newLoc;
            this.d_geom = this.d_geom.newCurve(this.t_verts);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }
}

