/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import thunderheadeng.Intl;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public interface IDOF {
    public static final IDOF FREE = new IDOF(){

        @Override
        public boolean accept(TransformInfo ti) {
            return true;
        }

        @Override
        public void describeRules(Set<String> rules) {
        }

        public String toString() {
            return "FREE";
        }
    };
    public static final IDOF ALIGNED = new IDOF(){

        @Override
        public boolean accept(TransformInfo ti) {
            return GeomUtil.isAxisAligned(ti, 1.0E-6);
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Rotation must be in 90 degree increments about the X, Y, or Z axis."));
        }

        public String toString() {
            return "ALIGNED";
        }
    };
    public static final IDOF NONE = new IDOF(){

        @Override
        public boolean accept(TransformInfo ti) {
            return GeomUtil.isTranslateScaleOnly(ti, 1.0E-6);
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Rotation and mirroring are not allowed."));
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final IDOF INVERTIBLE = new IDOF(){

        @Override
        public boolean accept(TransformInfo ti) {
            return ti.isInvertible();
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Transformation must be invertible."));
        }

        public String toString() {
            return "INVERTIBLE";
        }
    };

    public boolean accept(TransformInfo var1);

    public void describeRules(Set<String> var1);

    public static IDOF group(Collection<? extends IDOF> dofs) {
        if (dofs.isEmpty()) {
            return FREE;
        }
        if (dofs.size() == 1) {
            return dofs.iterator().next();
        }
        HashSet<IDOF> dofSet = new HashSet<IDOF>();
        CompositeDOF.flatten(dofs, dofSet);
        if (dofSet.isEmpty()) {
            return FREE;
        }
        if (dofSet.size() == 1) {
            return (IDOF)dofSet.iterator().next();
        }
        return new CompositeDOF(dofSet);
    }

    public static IDOF group(IDOF ... dofs) {
        return IDOF.group(Arrays.asList(dofs));
    }

    public static class CompositeDOF
    implements IDOF {
        public final Set<? extends IDOF> dofs;

        private CompositeDOF(Set<? extends IDOF> dofs) {
            this.dofs = dofs;
        }

        public static void flatten(Collection<? extends IDOF> dofs, Collection<IDOF> result) {
            for (IDOF iDOF : dofs) {
                if (iDOF instanceof CompositeDOF) {
                    CompositeDOF.flatten(((CompositeDOF)iDOF).dofs, result);
                    continue;
                }
                result.add(iDOF);
            }
        }

        public int hashCode() {
            return 0xFA923F ^ this.dofs.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            CompositeDOF dof = (CompositeDOF)obj;
            return dof.dofs.equals(this.dofs);
        }

        @Override
        public boolean accept(TransformInfo ti) {
            for (IDOF iDOF : this.dofs) {
                if (iDOF.accept(ti)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void describeRules(Set<String> rules) {
            for (IDOF iDOF : this.dofs) {
                iDOF.describeRules(rules);
            }
        }
    }
}

