/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;

public class GeomGroup
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final List<IGeom> children;

    public GeomGroup(Collection<? extends IGeom> children) {
        this.children = new ArrayList<IGeom>(children);
    }

    @Override
    public GeomGroup optimize(IPointOptimizer pool) {
        boolean modified = false;
        ArrayList<IGeom> nchildren = new ArrayList<IGeom>(this.children.size());
        for (int m = 0; m < this.children.size(); ++m) {
            IGeom child = this.children.get(m);
            IGeom nchild = child.optimize(pool);
            nchildren.add(nchild);
            modified |= child != nchild;
        }
        return modified ? new GeomGroup(nchildren) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        for (int m = 0; m < this.children.size(); ++m) {
            this.children.get(m).getBoundingBox(aabb);
        }
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        for (IGeom child : this.children) {
            dofs.add(child.getDOF());
        }
        return IDOF.group(dofs);
    }

    @Override
    public IDOF getRetainingDOF() {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        for (IGeom child : this.children) {
            dofs.add(child.getRetainingDOF());
        }
        return IDOF.group(dofs);
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        ArrayList<IGeom> newList = new ArrayList<IGeom>(this.children.size());
        for (IGeom child : this.children) {
            newList.add(child.transform(ti, options));
        }
        return new GeomGroup(newList);
    }

    @Override
    public boolean canExplode() {
        return !this.children.isEmpty();
    }

    @Override
    public int getNumPrims(int types) {
        int count = 0;
        for (int m = 0; m < this.children.size(); ++m) {
            count += this.children.get(m).getNumPrims(types);
        }
        return count;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        prims.addAll(this.children);
        return prims;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (int m = 0; m < this.children.size(); ++m) {
            if (!this.children.get(m).isShell()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, final IBoxCollector isects) throws CancelledException {
        int poffset = 0;
        for (IGeom geom : this.children) {
            final int primOffset = poffset;
            IBoxCollector childIsects = new IBoxCollector(){

                @Override
                public void addNonFace(Object obj) throws CancelledException {
                    isects.addNonFace(obj);
                }

                @Override
                public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal) throws CancelledException {
                    isects.addFace(obj, primOffset + primIx, getPointAndNormal);
                }
            };
            geom.pickBox(source, filter, region, childIsects);
            poffset += geom.getNumPrims(7);
        }
    }

    @Override
    public void pickPoints(final IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        int poffset = 0;
        AABox testBox = new AABox();
        for (IGeom geom : this.children) {
            isects.getProgress().check();
            final int primOffset = poffset;
            IIsectCollector childIsects = new IIsectCollector(){

                @Override
                public void addNonFace(Object obj, Point3d p, GeomType type) {
                    isects.addNonFace(obj, p, type);
                }

                @Override
                public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                    isects.addFace(obj, p, primOffset + primIx, getPrim, getNormal);
                }

                @Override
                public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                    isects.addInfinite(obj, p, type, prim);
                }

                @Override
                public TaskProgress getProgress() {
                    return isects.getProgress();
                }
            };
            testBox.reset();
            geom.getBoundingBox(testBox);
            if (tester.test((AABox)testBox).positive) {
                geom.pickPoints(childIsects, filter, source, rayBegin, rayEnd, rayDirN, tester);
            }
            poffset += geom.getNumPrims(7);
        }
    }

    @Override
    public void find(ITest<AABox> tester, IResult<? super IPrimitive> result) {
        AABox testBox = new AABox();
        for (IGeom geom : this.children) {
            testBox.reset();
            geom.getBoundingBox(testBox);
            if (!tester.test((AABox)testBox).positive) continue;
            geom.find(tester, result);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        for (IGeom geom : this.children) {
            geom.getAll(result);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (this.children.size() > 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Handle> handles = new ArrayList<Handle>();
        for (int m = 0; m < this.children.size(); ++m) {
            IGeom child = this.children.get(m);
            if (!(child instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)child)).generateManipHandles()) {
                handles.add(new Handle(this, m, iHandle));
            }
        }
        return handles;
    }

    private static class Handle
    implements IHandle {
        private GeomGroup d_geom;
        private final int d_ix;
        private final IHandle d_handle;
        private List<IGeom> t_children;

        public Handle(GeomGroup geom, int childIx, IHandle handle) {
            this.d_geom = geom;
            this.d_ix = childIx;
            this.d_handle = handle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_ix == this.d_ix && ((Handle)obj).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_handle.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.d_handle.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_children = new ArrayList<IGeom>(this.d_geom.children);
            this.d_handle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            Object mod = this.d_handle.modify(newLoc);
            this.d_geom = this.modify(mod);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.modify(this.d_handle.end());
            this.t_children = null;
            return this.d_geom;
        }

        private GeomGroup modify(Object mod) {
            if (mod instanceof IGeom) {
                this.t_children.set(this.d_ix, (IGeom)mod);
                return new GeomGroup(this.t_children);
            }
            return this.d_geom;
        }
    }
}

