/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACubicSpline;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class CubicBezierSpline
extends ACubicSpline {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d c1;
    public final Point3d c2;
    public final Point3d p2;

    public CubicBezierSpline(Point3d p1, Point3d c1, Point3d c2, Point3d p2) {
        super(p2.x - 3.0 * c2.x + 3.0 * c1.x - p1.x, 3.0 * c2.x - 6.0 * c1.x + 3.0 * p1.x, 3.0 * c1.x - 3.0 * p1.x, p1.x, p2.y - 3.0 * c2.y + 3.0 * c1.y - p1.y, 3.0 * c2.y - 6.0 * c1.y + 3.0 * p1.y, 3.0 * c1.y - 3.0 * p1.y, p1.y, p2.z - 3.0 * c2.z + 3.0 * c1.z - p1.z, 3.0 * c2.z - 6.0 * c1.z + 3.0 * p1.z, 3.0 * c1.z - 3.0 * p1.z, p1.z);
        this.p1 = p1;
        this.c1 = c1;
        this.c2 = c2;
        this.p2 = p2;
    }

    @Override
    public CubicBezierSpline reverse() {
        return new CubicBezierSpline(this.p2, this.c2, this.c1, this.p1);
    }

    @Override
    public Point3d get(double t) {
        if (t == 0.0) {
            return this.p1;
        }
        if (t == 1.0) {
            return this.p2;
        }
        return super.get(t);
    }

    public ACubicSpline projectToPlane(Plane3d plane, Matrix4d wlXform) {
        return new CubicBezierSpline(CubicBezierSpline.project(this.p1, plane, wlXform), CubicBezierSpline.project(this.c1, plane, wlXform), CubicBezierSpline.project(this.c2, plane, wlXform), CubicBezierSpline.project(this.p2, plane, wlXform));
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public CubicBezierSpline transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        return new CubicBezierSpline(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.c1), Util3D.xform(xform, this.c2), Util3D.xform(xform, this.p2));
    }

    @Override
    public CubicBezierSpline optimize(IPointOptimizer pool) {
        Point3d p1a = pool.getExisting(this.p1);
        Point3d c1a = pool.getExisting(this.c1);
        Point3d c2a = pool.getExisting(this.c2);
        Point3d p2a = pool.getExisting(this.p2);
        if (p1a == this.p1 && c1a == this.c1 && c2a == this.c2 && p2a == this.p2) {
            return this;
        }
        return new CubicBezierSpline(p1a, c1a, c2a, p2a);
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        return p;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.p1, this.c1, this.c2, this.p2);
        return aabb;
    }
}

