/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.awt.geom.NoninvertibleTransformException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MatrixXform;

public class BGImageXform
implements ITransform {
    private static final long serialVersionUID = 1L;
    public final Point2d anchorImage;
    public final Point3d anchorModel;
    public final Point2d aImage;
    public final Point2d bImage;
    public final double distABModel;
    public final double abAngle;

    public BGImageXform(Point2d anchorImage, Point3d anchorModel, Point2d aImage, Point2d bImage, double distABModel, double abAngle) {
        this.anchorImage = anchorImage;
        this.anchorModel = anchorModel;
        this.aImage = aImage;
        this.bImage = bImage;
        this.distABModel = distABModel;
        this.abAngle = Double.isNaN(abAngle) ? Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(aImage, bImage)) : abAngle;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BGImageXform)) {
            return false;
        }
        BGImageXform xform = (BGImageXform)obj;
        return this.anchorImage.equals((Tuple2d)xform.anchorImage) && this.anchorModel.equals((Tuple3d)xform.anchorModel) && this.aImage.equals((Tuple2d)xform.aImage) && this.bImage.equals((Tuple2d)xform.bImage) && this.distABModel == xform.distABModel && this.abAngle == xform.abAngle;
    }

    @Override
    public Matrix4d toMatrix(boolean newXform) {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        if (this.isIdentity()) {
            return xform;
        }
        xform.setTranslation(new Vector3d(this.anchorModel.x, this.anchorModel.y, this.anchorModel.z));
        double scale = BGImageXform.getBackgroundImageScale(this.aImage, this.bImage, this.distABModel);
        xform.mul(Util.scaleMat(scale, scale, 1.0));
        double angle = BGImageXform.getBGImageRotation(this.aImage, this.bImage, this.abAngle);
        xform.mul(Util.rotMat(0.0, 0.0, 1.0, angle));
        xform.mul(Util.translateMat(-this.anchorImage.x, -this.anchorImage.y, 0.0));
        return xform;
    }

    private static double getBackgroundImageScale(Point2d aImage, Point2d bImage, double distABModel) {
        double pixelDist = aImage.distance(bImage);
        return distABModel / pixelDist;
    }

    private static double getBGImageRotation(Point2d aImage, Point2d bImage, double desiredAngle) {
        Vector2d ab = Util2D.vector(aImage, bImage);
        double currAngle = Util2D.angle(new Vector2d(1.0, 0.0), ab);
        return desiredAngle - currAngle;
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return new MatrixXform(this.toMatrix(false)).invert();
    }

    @Override
    public boolean isInvertible() {
        try {
            this.invert();
            return true;
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return this;
    }

    @Override
    public boolean isIdentity() {
        return this.aImage.equals((Tuple2d)this.bImage) || this.distABModel == 0.0;
    }
}

