/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IParametricCurve;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.theMath;
import thunderheadeng.util.theUtil;

public abstract class ACubicSpline
extends ACurve
implements IParametricCurve {
    static final long serialVersionUID = 1L;
    public final double ax;
    public final double bx;
    public final double cx;
    public final double dx;
    public final double ay;
    public final double by;
    public final double cy;
    public final double dy;
    public final double az;
    public final double bz;
    public final double cz;
    public final double dz;

    public ACubicSpline(double ax, double bx, double cx, double dx, double ay, double by, double cy, double dy, double az, double bz, double cz, double dz) {
        this.ax = ax;
        this.ay = ay;
        this.az = az;
        this.bx = bx;
        this.by = by;
        this.bz = bz;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    public ACubicSpline(double[] coefficients) {
        this(coefficients[0], coefficients[1], coefficients[2], coefficients[3], coefficients[4], coefficients[5], coefficients[6], coefficients[7], coefficients[8], coefficients[9], coefficients[10], coefficients[11]);
    }

    @Override
    public abstract ACubicSpline reverse();

    @Override
    public Point3d get(double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        return new Point3d(this.ax * t3 + this.bx * t2 + this.cx * t + this.dx, this.ay * t3 + this.by * t2 + this.cy * t + this.dy, this.az * t3 + this.bz * t2 + this.cz * t + this.dz);
    }

    @Override
    public Vector3d getTangent(double t, ICurve.Orient orient, boolean normalize) {
        double t2 = t * t;
        Vector3d result = new Vector3d(3.0 * this.ax * t2 + 2.0 * this.bx * t + this.cx, 3.0 * this.ay * t2 + 2.0 * this.by * t + this.cy, 3.0 * this.az * t2 + 2.0 * this.bz * t + this.cz);
        if (orient == ICurve.Orient.NEGATIVE) {
            result.negate();
        }
        if (normalize) {
            Util3D.safeNormalize(result, 1.0E-12);
        }
        return result;
    }

    public double[] getIsects(Plane3d plane, double tol) {
        double a = plane.x * this.ax + plane.y * this.ay + plane.z * this.az;
        double b = plane.x * this.bx + plane.y * this.by + plane.z * this.bz;
        double c = plane.x * this.cx + plane.y * this.cy + plane.z * this.cz;
        double d = plane.w;
        double[] roots = theMath.solveCubic(a, b, c, d);
        ArrayList<Double> validRoots = new ArrayList<Double>(roots.length);
        for (int m = 0; m < roots.length; ++m) {
            double clamp = Util.clampTIfValid(roots[m], 0.0, 1.0, tol);
            if (Double.isNaN(clamp)) continue;
            validRoots.add(clamp);
        }
        return theUtil.toDoubleArray(validRoots);
    }

    protected static Point3d project(Point3d p, Plane3d plane, Matrix4d wlXform) {
        Point3d proj = plane.projectOntoPlane(p);
        wlXform.transform(proj);
        return proj;
    }

    @Override
    public Mesh getSegments(double errorTol) {
        int numPoints = 25;
        Point3d[] points = new Point3d[25];
        double mult = 0.041666666666666664;
        for (int m = 0; m < points.length; ++m) {
            points[m] = this.get((double)m * mult);
        }
        int[] ixes = new int[48];
        for (int m = 0; m < points.length - 1; ++m) {
            ixes[m * 2] = m;
            ixes[m * 2 + 1] = m + 1;
        }
        return new Mesh(points, ixes, 1);
    }

    public double length(double tol) {
        double len = 0.0;
        Mesh segments = this.getSegments(tol);
        for (int m = 0; m < segments.indices.length; m += 2) {
            Point3d p1 = segments.vertices[segments.indices[m]];
            Point3d p2 = segments.vertices[segments.indices[m + 1]];
            len += p1.distance(p2);
        }
        return len;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        return this.getSegments(0.001).getBoundingBox(aabb);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Mesh mesh = this.getSegments(0.001);
        mesh.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        this.getSegments(0.001).pickBox(source, filter, region, isects);
    }
}

