/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.APlaneHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class AABoxGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_X = 0;
    public static final int MAX_X = 1;
    public static final int MIN_Y = 2;
    public static final int MAX_Y = 3;
    public static final int MIN_Z = 4;
    public static final int MAX_Z = 5;
    private static final short NATURAL_SWIZZLE = AABoxGeom.encodeSwzl(0, 2, 4);
    private static final int[] NATURAL_ORDER = new int[]{0, 1, 2, 3, 4, 5};
    public final Point3d min;
    public final Point3d max;
    public final short swizzle;
    private static final int[][] s_faces = new int[][]{{2, 0, 1, 3}, {4, 6, 7, 5}, {0, 4, 5, 1}, {6, 2, 3, 7}, {0, 2, 6, 4}, {5, 7, 3, 1}};
    private static final int[][] s_edgeTests = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};

    public AABoxGeom(AABox box) {
        this(box.getMin(), box.getMax(), 0);
    }

    public AABoxGeom(Point3d min, Point3d max, int swizzle) {
        this.min = min;
        this.max = max;
        this.swizzle = swizzle == 0 ? NATURAL_SWIZZLE : (short)swizzle;
    }

    private static short encodeSwzl(int minx, int miny, int minz) {
        return (short)(minx | miny << 4 | minz << 8);
    }

    private static int[] decodeSwzl(short s) {
        return new int[]{s & 0xF, (s & 0xF0) >> 4, (s & 0xF00) >> 8};
    }

    public int hashCode() {
        return 4739 + this.min.hashCode() + this.max.hashCode() + this.swizzle;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AABoxGeom && ((AABoxGeom)obj).min.equals((Tuple3d)this.min) && ((AABoxGeom)obj).max.equals((Tuple3d)this.max) && ((AABoxGeom)obj).swizzle == this.swizzle;
    }

    public boolean isNaturallyOrdered() {
        return this.swizzle == NATURAL_SWIZZLE;
    }

    public int[] getIndexToNameFaceOrder() {
        if (this.isNaturallyOrdered()) {
            return NATURAL_ORDER;
        }
        int[] minixes = AABoxGeom.decodeSwzl(this.swizzle);
        int xmin = minixes[0];
        int xmax = AABoxGeom.oppositeix(xmin);
        int ymin = minixes[1];
        int ymax = AABoxGeom.oppositeix(ymin);
        int zmin = minixes[2];
        int zmax = AABoxGeom.oppositeix(zmin);
        int[] result = new int[]{xmin, xmax, ymin, ymax, zmin, zmax};
        return result;
    }

    public int[] getNameToIndexFaceOrder() {
        if (this.isNaturallyOrdered()) {
            return NATURAL_ORDER;
        }
        int[] minixes = AABoxGeom.decodeSwzl(this.swizzle);
        int xmin = minixes[0];
        int xmax = AABoxGeom.oppositeix(xmin);
        int ymin = minixes[1];
        int ymax = AABoxGeom.oppositeix(ymin);
        int zmin = minixes[2];
        int zmax = AABoxGeom.oppositeix(zmin);
        int[] result = new int[6];
        result[xmin] = 0;
        result[xmax] = 1;
        result[ymin] = 2;
        result[ymax] = 3;
        result[zmin] = 4;
        result[zmax] = 5;
        return result;
    }

    @Override
    public AABoxGeom optimize(IPointOptimizer pool) {
        Point3d newMin = pool.getExisting(this.min);
        Point3d newMax = pool.getExisting(this.max);
        return newMin != this.min || newMax != this.max ? new AABoxGeom(newMin, newMax, this.swizzle) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(new AABox(this.min, this.max));
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.ALIGNED;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        if (GeomUtil.test(options, 1) && ti.isAccepted(IDOF.ALIGNED)) {
            Matrix4d xform = ti.getMatrix();
            Point3d newMin = Util3D.xform(xform, this.min);
            Point3d newMax = Util3D.xform(xform, this.max);
            Util3D.rectify(newMin, newMax);
            Vector3d[] swizzleVecs = this.getMinVecs();
            for (int m = 0; m < swizzleVecs.length; ++m) {
                swizzleVecs[m] = Util3D.xform(xform, swizzleVecs[m]);
                if (swizzleVecs[m].lengthSquared() == 0.0) continue;
                swizzleVecs[m].normalize();
            }
            int axisx = this.getAxis(swizzleVecs[0]);
            int axisy = this.getAxis(swizzleVecs[1]);
            int axisz = this.getAxis(swizzleVecs[2]);
            short newSwizzle = AABoxGeom.encodeSwzl(axisx, axisy, axisz);
            return new AABoxGeom(newMin, newMax, newSwizzle);
        }
        return this.toMesh(ti);
    }

    private int getAxis(Vector3d vec) {
        Vector3d closestAxis = GeomUtil.getClosestAxis(vec);
        for (int m = 0; m < GeomUtil.AXIS_VECS.length; ++m) {
            if (!closestAxis.equals((Tuple3d)GeomUtil.AXIS_VECS[m])) continue;
            return m;
        }
        return 0;
    }

    private Vector3d[] getMinVecs() {
        int[] ivecs = AABoxGeom.decodeSwzl(this.swizzle);
        Vector3d[] vecs = new Vector3d[3];
        for (int m = 0; m < 3; ++m) {
            vecs[m] = GeomUtil.AXIS_VECS[ivecs[m]];
        }
        return vecs;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return parentXform == null || parentXform.isIdentity();
    }

    @Override
    public boolean isShell() {
        return Boolean.FALSE;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        return (types & 1) != 0 ? 6 : 0;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        prims.add(this.toMesh(null));
        return prims;
    }

    private Mesh toMesh(TransformInfo parentXform) {
        Point3d[] verts = new Point3d[]{this.min, new Point3d(this.min.x, this.min.y, this.max.z), new Point3d(this.min.x, this.max.y, this.min.z), new Point3d(this.min.x, this.max.y, this.max.z), new Point3d(this.max.x, this.min.y, this.min.z), new Point3d(this.max.x, this.min.y, this.max.z), new Point3d(this.max.x, this.max.y, this.min.z), this.max};
        if (parentXform != null) {
            Matrix4d mat = parentXform.getMatrix();
            for (int m = 1; m < 7; ++m) {
                mat.transform(verts[m]);
            }
            verts[0] = Util3D.xform(mat, verts[0]);
            verts[7] = Util3D.xform(mat, verts[7]);
        }
        int[] faceOrder = this.getIndexToNameFaceOrder();
        int[] ixes = new int[24];
        for (int m = 0; m < 6; ++m) {
            AABoxGeom.setFaces(ixes, m, s_faces[faceOrder[m]]);
        }
        return new Mesh(verts, ixes, 3, 4);
    }

    private static int oppositeix(int ix) {
        if (ix % 2 == 0) {
            return ix + 1;
        }
        return ix - 1;
    }

    private static void setFaces(int[] dstIxes, int foffset, int[] srcIxes) {
        int offset = foffset * 4;
        dstIxes[offset + 0] = srcIxes[0];
        dstIxes[offset + 1] = srcIxes[1];
        dstIxes[offset + 2] = srcIxes[2];
        dstIxes[offset + 3] = srcIxes[3];
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        block6: {
            block5: {
                if (!filter.acceptGeomType(source, GeomType.FACE)) break block5;
                if (!region.test((AABox)new AABox((Point3d)this.min, (Point3d)this.max)).positive) break block6;
                Mesh mesh = this.toMesh(null);
                mesh.pickBox(source, filter, region, isects);
                break block6;
            }
            if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
                Point3d[] boxVerts = this.getVerts();
                for (int m = 0; m < s_edgeTests.length; ++m) {
                    int[] i = s_edgeTests[m];
                    Point3d p1 = boxVerts[i[0]];
                    Point3d p2 = boxVerts[i[1]];
                    if (!region.intersectsLineSeg(p1, p2, 1.0E-6)) continue;
                    isects.addNonFace(source);
                }
            } else if (filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
                for (Point3d p : this.getVerts()) {
                    if (!region.contains(p, 1.0E-6)) continue;
                    isects.addNonFace(source);
                }
            }
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Point3d[] verts;
        boolean faces = filter.acceptGeomType(source, GeomType.FACE);
        boolean fedges = filter.acceptGeomType(source, GeomType.FACE_EDGE);
        boolean fverts = filter.acceptGeomType(source, GeomType.FACE_VERTEX);
        if (!(faces || fedges || fverts)) {
            return;
        }
        Object object = verts = fedges || fverts ? this.getVerts() : null;
        if (faces) {
            this.getFaceIsects(isects, source, rayBegin, rayEnd, rayDirN);
        }
        if (fedges) {
            this.getEdgeIsects(isects, source, verts, rayBegin, rayEnd, rayDirN);
        }
        if (fverts) {
            this.getVertIsects(isects, source, verts);
        }
    }

    private void getVertIsects(IIsectCollector isects, Object source, Point3d[] verts) {
        for (Point3d p : verts) {
            isects.addNonFace(source, p, GeomType.FACE_VERTEX);
        }
    }

    private Point3d[] getVerts() {
        AABox box = new AABox(this.min, this.max);
        return new Point3d[]{box.mmm(), box.Mmm(), box.MMm(), box.mMm(), box.mmM(), box.MmM(), box.MMM(), box.mMM()};
    }

    private void getEdgeIsects(IIsectCollector isects, Object source, Point3d[] verts, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d[] boxVerts = verts;
        Point3d isect = new Point3d();
        for (int m = 0; m < s_edgeTests.length; ++m) {
            int[] i = s_edgeTests[m];
            this.edgeIsect(isects, source, rayBegin, rayDirN, isect, boxVerts[i[0]], boxVerts[i[1]]);
        }
    }

    private void edgeIsect(IIsectCollector isects, Object source, Point3d rayBegin, Vector3d rayDirN, Point3d isect, Point3d p1, Point3d p2) {
        boolean nonParallel = Inter3D.lineLineSegProximity(null, isect, rayBegin, rayDirN, p1, p2);
        if (nonParallel) {
            isects.addNonFace(source, new Point3d(isect), GeomType.FACE_EDGE);
        }
    }

    private void getFaceIsects(IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        int m;
        double t;
        int ix;
        double maxtsq = rayBegin.distanceSquared(rayEnd);
        double[] xvals = new double[]{this.min.x, this.max.x};
        double[] yvals = new double[]{this.min.y, this.max.y};
        double[] zvals = new double[]{this.min.z, this.max.z};
        int[] nim = this.getNameToIndexFaceOrder();
        for (ix = 0; ix < 2; ++ix) {
            double x = xvals[ix];
            t = Inter3D.lineXFaceIsect(rayBegin, rayDirN, this.min.y, this.max.y, this.min.z, this.max.z, x, 1.0E-6);
            if (Double.isNaN(t) || !(t >= 0.0) || !(t * t <= maxtsq)) continue;
            m = ix;
            isects.addFace(source, Util3D.linePoint(rayBegin, rayDirN, t), m == 0 ? nim[0] : nim[1], () -> new AARectangle(0, x, this.min.y, this.min.z, this.max.y, this.max.z, m != 0), () -> m == 0 ? GeomConstants.VEC3D_XNEG : GeomConstants.VEC3D_XPOS);
        }
        for (ix = 0; ix < 2; ++ix) {
            double y = yvals[ix];
            t = Inter3D.lineYFaceIsect(rayBegin, rayDirN, this.min.x, this.max.x, this.min.z, this.max.z, y, 1.0E-6);
            if (Double.isNaN(t) || !(t >= 0.0) || !(t * t <= maxtsq)) continue;
            m = ix;
            isects.addFace(source, Util3D.linePoint(rayBegin, rayDirN, t), m == 0 ? nim[2] : nim[3], () -> new AARectangle(1, y, this.min.x, this.min.z, this.max.x, this.max.z, m != 0), () -> m == 0 ? GeomConstants.VEC3D_YNEG : GeomConstants.VEC3D_YPOS);
        }
        for (ix = 0; ix < 2; ++ix) {
            double z = zvals[ix];
            t = Inter3D.lineZFaceIsect(rayBegin, rayDirN, this.min.x, this.max.x, this.min.y, this.max.y, z, 1.0E-6);
            if (Double.isNaN(t) || !(t >= 0.0) || !(t * t <= maxtsq)) continue;
            m = ix;
            isects.addFace(source, Util3D.linePoint(rayBegin, rayDirN, t), m == 0 ? nim[4] : nim[5], () -> new AARectangle(2, z, this.min.x, this.min.y, this.max.x, this.max.y, m != 0), () -> m == 0 ? GeomConstants.VEC3D_ZNEG : GeomConstants.VEC3D_ZPOS);
        }
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        this.toMesh(null).find(test, result);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        this.toMesh(null).getAll(result);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this, 0, 2, 4), new Handle(this, 1, 2, 4), new Handle(this, 1, 3, 4), new Handle(this, 0, 3, 4), new Handle(this, 0, 2, 5), new Handle(this, 1, 2, 5), new Handle(this, 1, 3, 5), new Handle(this, 0, 3, 5), new FaceHandle(this, 0), new FaceHandle(this, 1), new FaceHandle(this, 2), new FaceHandle(this, 3), new FaceHandle(this, 4), new FaceHandle(this, 5));
    }

    private static class SettableBox {
        private final AABoxGeom d_original;
        private double[] d_coords;

        public SettableBox(AABoxGeom geom) {
            this.d_original = geom;
            this.d_coords = SettableBox.getCoords(geom.min, geom.max);
        }

        protected static double[] getCoords(Point3d min, Point3d max) {
            double[] coords = new double[6];
            coords[0] = min.x;
            coords[2] = min.y;
            coords[4] = min.z;
            coords[1] = max.x;
            coords[3] = max.y;
            coords[5] = max.z;
            return coords;
        }

        public void set(int coord, double val) {
            double minVal = -1.7976931348623157E308;
            double maxVal = Double.MAX_VALUE;
            switch (coord) {
                case 0: {
                    maxVal = this.d_coords[1];
                    break;
                }
                case 1: {
                    minVal = this.d_coords[0];
                    break;
                }
                case 2: {
                    maxVal = this.d_coords[3];
                    break;
                }
                case 3: {
                    minVal = this.d_coords[2];
                    break;
                }
                case 4: {
                    maxVal = this.d_coords[5];
                    break;
                }
                case 5: {
                    minVal = this.d_coords[4];
                }
            }
            if (val < minVal) {
                val = minVal;
            } else if (val > maxVal) {
                val = maxVal;
            }
            this.d_coords[coord] = val;
        }

        public double get(int coord) {
            return this.d_coords[coord];
        }

        public AABoxGeom toBox() {
            Point3d min = new Point3d(this.d_coords[0], this.d_coords[2], this.d_coords[4]);
            Point3d max = new Point3d(this.d_coords[1], this.d_coords[3], this.d_coords[5]);
            return new AABoxGeom(min, max, this.d_original.swizzle);
        }
    }

    private static class Handle
    implements IHandle {
        private AABoxGeom d_geom;
        private final int[] d_coords;
        private SettableBox t_box;

        public Handle(AABoxGeom geom, int mx, int my, int mz) {
            this.d_geom = geom;
            this.d_coords = new int[]{mx, my, mz};
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && Arrays.equals(((Handle)obj).d_coords, this.d_coords);
        }

        @Override
        public IGeomNode getGeom() {
            SettableBox box = new SettableBox(this.d_geom);
            Point3d p = new Point3d(box.get(this.d_coords[0]), box.get(this.d_coords[1]), box.get(this.d_coords[2]));
            return GeomNodeUtil.newNode(new Point(p));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_box = new SettableBox(this.d_geom);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            this.t_box.set(this.d_coords[0], newLoc.x);
            this.t_box.set(this.d_coords[1], newLoc.y);
            this.t_box.set(this.d_coords[2], newLoc.z);
            this.d_geom = this.t_box.toBox();
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }

    private static class FaceHandle
    extends APlaneHandle<AABoxGeom> {
        private final int d_faceIx;

        public FaceHandle(AABoxGeom geom, int face) {
            super(geom);
            this.d_faceIx = face;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof FaceHandle && ((FaceHandle)obj).d_faceIx == this.d_faceIx;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(((AABoxGeom)this.getManipGeom()).toMesh(null).getPrimitive(this.d_faceIx));
        }

        @Override
        protected Vector3d getPlaneNormal(AABoxGeom geom) {
            int[] faceOrder = geom.getIndexToNameFaceOrder();
            switch (faceOrder[this.d_faceIx]) {
                case 0: 
                case 1: {
                    return GeomConstants.VEC3D_XPOS;
                }
                case 2: 
                case 3: {
                    return GeomConstants.VEC3D_YPOS;
                }
                case 4: 
                case 5: {
                    return GeomConstants.VEC3D_ZPOS;
                }
            }
            return null;
        }

        @Override
        protected AABoxGeom modify(AABoxGeom origGeom, double offset) {
            SettableBox box = new SettableBox(origGeom);
            int[] faceOrder = origGeom.getIndexToNameFaceOrder();
            int faceIx = faceOrder[this.d_faceIx];
            box.set(faceIx, box.get(faceIx) + offset);
            return box.toBox();
        }
    }
}

