/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theUtil;

public class NmtUtil {
    public static int[] mergeGroupIds(int[] groupIds1, int ... groupIds2) {
        ArrayList<Integer> newGroupIds = new ArrayList<Integer>(groupIds2.length);
        for (int newGroupId : groupIds2) {
            if (NmtUtil.findGroup(groupIds1, newGroupId)) continue;
            newGroupIds.add(newGroupId);
        }
        return theUtil.append(groupIds1, theUtil.toIntArray(newGroupIds));
    }

    public static int[] mergeGroupIds(Collection<int[]> groupIds) {
        if (groupIds.isEmpty()) {
            return new int[0];
        }
        if (groupIds.size() == 1) {
            return groupIds.iterator().next();
        }
        if (groupIds.size() == 2) {
            Iterator<int[]> it = groupIds.iterator();
            return NmtUtil.mergeGroupIds(it.next(), it.next());
        }
        return groupIds.stream().flatMapToInt(ids -> IntStream.of(ids)).distinct().toArray();
    }

    public static boolean findGroup(int[] groupids, int groupid) {
        for (int existing : groupids) {
            if (existing != groupid) continue;
            return true;
        }
        return false;
    }

    public static boolean testGroups(int[] groupids, IntPredicate test) {
        for (int group : groupids) {
            if (!test.test(group)) continue;
            return true;
        }
        return false;
    }

    public static boolean equal(int[] ids1, int[] ids2) {
        if (ids1.length != ids2.length) {
            return false;
        }
        for (int id1 : ids1) {
            if (NmtUtil.findGroup(ids2, id1)) continue;
            return false;
        }
        return true;
    }

    public static int getFaceOrient(List<EdgeUse> loop, Plane3d plane) {
        double area = NmtUtil.loopArea(loop, plane);
        if (area > 0.0) {
            return 1;
        }
        if (area < 0.0) {
            return 2;
        }
        return 0;
    }

    public static double loopArea(List<EdgeUse> loop, Plane3d plane) {
        ArrayList<Point3d> verts = new ArrayList<Point3d>(loop.size());
        for (int m = 0; m < loop.size(); ++m) {
            verts.add(loop.get((int)m).v1().loc);
        }
        return Util3D.simplePolygonArea(verts, true, plane.getNormal());
    }

    public static Plane3d calcLoopPlane(List<EdgeUse> loop) {
        ArrayList<Point3d> verts = new ArrayList<Point3d>(loop.size());
        for (int m = 0; m < loop.size(); ++m) {
            verts.add(loop.get((int)m).v1().loc);
        }
        return Util3D.simplePolygonPlane(verts, true);
    }

    public static boolean faceInSolid(Model solid, Model faceModel, Face face) {
        Point3d testPoint = faceModel.findPointInFace(face);
        if (testPoint == null) {
            return false;
        }
        return solid.contains(testPoint);
    }

    public static List<LineSeg3D> toCurves(Point3d ... poly) {
        ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>(poly.length);
        for (int m = 0; m < poly.length; ++m) {
            Point3d p1 = poly[m];
            Point3d p2 = poly[(m + 1) % poly.length];
            curves.add(new LineSeg3D(p1, p2));
        }
        return curves;
    }

    public static boolean addFaceToModel(Model model, int id, Plane3d plane, Collection<? extends IParametric3D> boundary) {
        Point3d[] polyPoints = NmtUtil.getPolygonPoints(boundary);
        if (polyPoints != null) {
            return model.addPolygonFace(id, plane, polyPoints);
        }
        return model.addFace(id, plane, boundary);
    }

    public static Point3d[] getPolygonPoints(Collection<? extends IParametric3D> curves) {
        if (curves.size() < 3) {
            return null;
        }
        Iterator<? extends IParametric3D> it = curves.iterator();
        IParametric3D firstCurve = it.next();
        if (!firstCurve.isLinear()) {
            return null;
        }
        double tolSq = 1.0E-12;
        Point3d[] points = new Point3d[curves.size()];
        points[0] = firstCurve.get(0.0);
        Point3d prevPoint = firstCurve.get(1.0);
        for (int m = 1; m < points.length; ++m) {
            IParametric3D curve = it.next();
            if (!curve.isLinear()) {
                return null;
            }
            Point3d p1 = curve.get(0.0);
            if (prevPoint.distanceSquared(p1) > tolSq) {
                return null;
            }
            points[m] = p1;
            prevPoint = curve.get(1.0);
        }
        return prevPoint.distanceSquared(points[0]) <= tolSq ? points : null;
    }

    public static Predicate<Model.FaceClassify> acceptPointsOnFace() {
        return o -> o.on;
    }

    public static Predicate<Model.FaceClassify> acceptPointsInFace() {
        return Filters.accept(Model.FaceClassify.INSIDE);
    }

    public static Predicate<Model.FaceClassify> acceptPointsOnBoundary() {
        return Filters.accept(Model.FaceClassify.ON_EDGE);
    }
}

