/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.util.LinkedIdentityHashSet;

public class FaceLoop
implements Serializable {
    static final long serialVersionUID = 1L;
    public final ArrayList<EdgeUse> edges;
    public Vertex vert = null;

    public FaceLoop() {
        this.edges = new ArrayList();
    }

    public FaceLoop(int edgeCountHint) {
        this.edges = new ArrayList(edgeCountHint);
    }

    public FaceLoop(ArrayList<EdgeUse> edges) {
        this.edges = edges;
    }

    public void flipOrient() {
        ArrayList<EdgeUse> newEdges = new ArrayList<EdgeUse>(this.edges.size());
        for (int m = this.edges.size() - 1; m >= 0; --m) {
            EdgeUse eu = this.edges.get(m);
            newEdges.add(new EdgeUse(eu.edge, !eu.orient));
        }
        this.edges.clear();
        this.edges.addAll(newEdges);
    }

    public List<IParametric3D> getCurves() {
        ArrayList<IParametric3D> curves = new ArrayList<IParametric3D>(this.edges.size());
        for (EdgeUse eu : this.edges) {
            curves.add(eu.curve());
        }
        return curves;
    }

    public Collection<Vertex> getVerts() {
        if (this.vert != null) {
            return Arrays.asList(this.vert);
        }
        LinkedIdentityHashSet<Vertex> verts = new LinkedIdentityHashSet<Vertex>();
        for (EdgeUse eu : this.edges) {
            verts.add(eu.edge.v1);
            verts.add(eu.edge.v2);
        }
        return verts;
    }

    public boolean isValid() {
        return true;
    }

    public FaceLoop clone(CloneMap cloneMap) {
        FaceLoop loop = new FaceLoop();
        if (this.vert != null) {
            loop.vert = cloneMap.get(this.vert);
            assert (loop.vert != null);
        }
        for (EdgeUse eu : this.edges) {
            loop.edges.add(eu.clone(cloneMap));
        }
        return loop;
    }

    public void addFace(Face face) {
        if (this.vert != null) {
            this.vert.face = face;
        } else {
            for (EdgeUse eu : this.edges) {
                eu.edge.addFace(face);
            }
        }
    }

    public void removeFace(Face face) {
        if (this.vert != null) {
            this.vert.face = null;
        } else {
            for (EdgeUse eu : this.edges) {
                eu.edge.faces.remove(face);
            }
        }
    }

    public boolean isOpen() {
        if (this.vert != null) {
            return false;
        }
        IdentityHashMap<Edge, Integer> useCounts = new IdentityHashMap<Edge, Integer>();
        for (EdgeUse eu : this.edges) {
            Integer count = (Integer)useCounts.get(eu.edge);
            if (count == null) {
                useCounts.put(eu.edge, 1);
                continue;
            }
            useCounts.put(eu.edge, count + 1);
        }
        for (Integer count : useCounts.values()) {
            if (count >= 2) continue;
            return true;
        }
        return false;
    }
}

