/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class Face
extends AModelObj {
    private static final Logger LOGGER = Logger.getLogger(Face.class.getName());
    static final long serialVersionUID = 1L;
    public static final int ORIENT_NONE = 0;
    public static final int ORIENT_CCW = 1;
    public static final int ORIENT_CW = 2;
    public Plane3d plane;
    public List<FaceLoop> edgeLoops;
    private transient AABox d_cachedBounds = null;
    private transient Set<Edge> d_internalEdges = null;

    public Face(Plane3d plane, List<FaceLoop> edgeLoops, boolean calcInternalEdges) {
        this.plane = plane;
        this.edgeLoops = new ArrayList<FaceLoop>(edgeLoops);
        if (calcInternalEdges) {
            this.recalcInternalEdges();
        } else {
            this.d_internalEdges = new LinkedIdentityHashSet<Edge>();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recalcInternalEdges();
    }

    public boolean checkInternalVerts(Model model) {
        for (FaceLoop loop : this.edgeLoops) {
            if (loop.vert == null) continue;
            Point3d p = this.plane.projectOntoPlane(loop.vert.loc);
            if (!Model.compare(p, loop.vert.loc)) {
                return false;
            }
            if (model.testPointOnFace(this, p) == Model.FaceClassify.INSIDE) continue;
            return false;
        }
        return true;
    }

    public boolean isInternalEdge(Edge edge) {
        return this.getInternalEdges().contains(edge);
    }

    private Set<Edge> calcInternalEdges() {
        LinkedIdentityHashSet<Edge> internalEdges = new LinkedIdentityHashSet<Edge>();
        IdentityHashSet encounteredEdges = new IdentityHashSet();
        for (FaceLoop loop : this.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (encounteredEdges.add(eu.edge)) continue;
                internalEdges.add(eu.edge);
            }
        }
        return internalEdges;
    }

    public boolean checkInternalEdgesCorrect() {
        return this.calcInternalEdges().equals(this.d_internalEdges);
    }

    public Set<Edge> getInternalEdges() {
        return this.d_internalEdges;
    }

    public void calcPlane() {
        Plane3d newPlane = NmtUtil.calcLoopPlane(this.edgeLoops.get((int)0).edges);
        if (newPlane == null) {
            LOGGER.log(Level.WARNING, "0x83229f Could not calculate plane");
        } else {
            this.plane = newPlane;
        }
    }

    public void flipOrient() {
        this.plane = this.plane.negate();
        for (FaceLoop loop : this.edgeLoops) {
            loop.flipOrient();
        }
    }

    public double getArea() {
        double area = 0.0;
        for (FaceLoop loop : this.edgeLoops) {
            area += NmtUtil.loopArea(loop.edges, this.plane);
        }
        return Math.abs(area);
    }

    public boolean isValid(Model model) {
        return true;
    }

    private boolean validate(Model model) {
        if (!this.checkInternalEdgesCorrect()) {
            return false;
        }
        assert (!this.edgeLoops.isEmpty());
        FaceLoop outer = this.edgeLoops.get(0);
        if (outer.vert != null || outer.edges.isEmpty() || !outer.isValid() || !outer.isOpen() || NmtUtil.getFaceOrient(outer.edges, this.plane) != 1) {
            return false;
        }
        for (int m = 1; m < this.edgeLoops.size(); ++m) {
            FaceLoop loop = this.edgeLoops.get(m);
            if (!loop.isValid()) {
                return false;
            }
            if (loop.vert != null || !loop.isOpen() || NmtUtil.getFaceOrient(loop.edges, this.plane) == 2) continue;
            return false;
        }
        return model == null || this.checkInternalVerts(model);
    }

    public Face clone(CloneMap cloneMap) {
        Face clone = (Face)this.clone();
        clone.edgeLoops = new ArrayList<FaceLoop>(this.edgeLoops.size());
        for (FaceLoop loop : this.edgeLoops) {
            clone.edgeLoops.add(loop.clone(cloneMap));
        }
        clone.d_internalEdges = new LinkedIdentityHashSet<Edge>();
        for (Edge iedge : this.d_internalEdges) {
            clone.d_internalEdges.add(cloneMap.get(iedge));
        }
        return clone;
    }

    @Override
    public AABox getBounds() {
        if (this.d_cachedBounds == null) {
            AABox bb = new AABox();
            FaceLoop outerLoop = this.outerLoop();
            for (EdgeUse eu : outerLoop.edges) {
                bb.add(eu.edge.getBounds());
            }
            this.d_cachedBounds = bb;
        }
        return this.d_cachedBounds;
    }

    public AABox getLocalBounds() {
        Matrix4d wlXform = Util.getWorldToLocalXform(this.plane);
        AABox worldBounds = this.getBounds();
        AABox localBounds = new AABox();
        localBounds.add(Util3D.xform(wlXform, worldBounds.mmm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.mmM()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.mMm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.mMM()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.Mmm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.MmM()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.MMm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.MMM()));
        return localBounds;
    }

    public void invalidateBounds() {
        this.d_cachedBounds = null;
    }

    public void recalcInternalEdges() {
        this.d_internalEdges = this.calcInternalEdges();
    }

    public void addInternalEdge(Edge edge) {
        this.getInternalEdges().add(edge);
    }

    public void removeInternalEdge(Edge edge) {
        this.getInternalEdges().remove(edge);
    }

    public void clearConnections() {
        for (FaceLoop loop : this.edgeLoops) {
            loop.removeFace(this);
        }
    }

    public void buildConnections() {
        for (FaceLoop loop : this.edgeLoops) {
            loop.addFace(this);
        }
    }

    public FaceLoop outerLoop() {
        assert (!this.edgeLoops.isEmpty());
        return this.edgeLoops.get(0);
    }

    public List<EdgeUse> getEdges() {
        return this.getEdges(false);
    }

    public List<EdgeUse> getEdges(boolean copy) {
        int count = 0;
        for (int m = 0; m < this.edgeLoops.size(); ++m) {
            count += this.edgeLoops.get((int)m).edges.size();
        }
        ArrayList<EdgeUse> edges = new ArrayList<EdgeUse>(count);
        for (int m = 0; m < this.edgeLoops.size(); ++m) {
            edges.addAll(this.edgeLoops.get((int)m).edges);
        }
        return edges;
    }

    public Triangulation triangulate(double minEdgeAngleDeg) {
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> resultTris = new ArrayList<Integer>();
        this.triangulate(minEdgeAngleDeg, pointIxMap, resultTris);
        return new Triangulation(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), theUtil.toIntArray(resultTris));
    }

    public boolean triangulate(double minEdgeAngleDeg, Map<Point3d, Integer> pointIxMap, List<Integer> resultTris) {
        int m;
        int toptions;
        HashMap<Point2d, Vertex> localVertMap = new HashMap<Point2d, Vertex>();
        Matrix4d wlXform = Util.getWorldToLocalXform(this.plane);
        Matrix4d lwXform = Util.getLocalToWorldXform(this.plane);
        MeshBuilder mb = new MeshBuilder(1.0E-6);
        for (FaceLoop loop : this.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                Point2d p1 = Util3D.xform2d(wlXform, eu.v1().loc);
                Point2d p2 = Util3D.xform2d(wlXform, eu.v2().loc);
                localVertMap.put(p1, eu.v1());
                localVertMap.put(p2, eu.v2());
                mb.addEdge(p1, p2);
            }
        }
        Mesh mesh = mb.build();
        boolean triangulated = mesh.triangulateEvenOdd(toptions = minEdgeAngleDeg > 0.0 ? 1 : 0, minEdgeAngleDeg);
        if (!triangulated) {
            return false;
        }
        TriangulatorInfo result = mesh.getOutput();
        int[] localWorldIxes = new int[result.points.length];
        for (m = 0; m < result.points.length; ++m) {
            Point3d p3d;
            Point2d p2d = result.points[m];
            Vertex vert = (Vertex)localVertMap.get(p2d);
            if (vert != null) {
                p3d = vert.loc;
            } else {
                p3d = new Point3d(p2d.x, p2d.y, 0.0);
                lwXform.transform(p3d);
            }
            Integer ix = pointIxMap.get(p3d);
            if (ix == null) {
                ix = pointIxMap.size();
                pointIxMap.put(p3d, ix);
            }
            localWorldIxes[m] = ix;
        }
        for (m = 0; m < result.triangles.length; ++m) {
            result.triangles[m] = localWorldIxes[result.triangles[m]];
        }
        resultTris.addAll(Arrays.asList(theUtil.toIntArray(result.triangles)));
        return true;
    }

    public IFace toGeomFace() {
        ArrayList<Point3d> allPoints = new ArrayList<Point3d>();
        ArrayList<Integer> offsets = new ArrayList<Integer>(this.edgeLoops.size());
        for (int m = 0; m < this.edgeLoops.size(); ++m) {
            FaceLoop loop = this.edgeLoops.get(m);
            if (loop.vert != null || loop.edges.size() < 3) continue;
            offsets.add(allPoints.size());
            for (EdgeUse eu : loop.edges) {
                allPoints.add(eu.v1().loc);
            }
        }
        return PolyUtil.newPoly(allPoints.toArray(new Point3d[allPoints.size()]), theUtil.toIntArray(offsets));
    }

    public List<EdgeUse> getUses(Edge edge) {
        ArrayList<EdgeUse> uses = null;
        for (FaceLoop loop : this.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (eu.edge != edge || uses != null && uses.contains(eu)) continue;
                if (uses == null) {
                    uses = new ArrayList<EdgeUse>(2);
                }
                uses.add(eu);
                if (uses.size() != 2) continue;
                return uses;
            }
        }
        return uses == null ? Collections.emptyList() : uses;
    }
}

