/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.manip;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.util.Pair;

public abstract class APlaneHandle<T>
implements IHandle {
    private T d_geom;
    private Vector3d t_planeNormal;
    private Point3d t_pickLoc;
    private T t_origGeom;

    protected abstract Vector3d getPlaneNormal(T var1);

    protected abstract T modify(T var1, double var2);

    public APlaneHandle(T geom) {
        this.d_geom = geom;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof APlaneHandle;
    }

    public T getManipGeom() {
        return this.d_geom;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getPickFilter() {
        return null;
    }

    @Override
    public ISnapConstraint getConstraint(Point3d handleLoc) {
        Vector3d planeNormal = this.getPlaneNormal(this.d_geom);
        return new LineConstraint(handleLoc, planeNormal);
    }

    @Override
    public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        assert (constraint instanceof LineConstraint);
        LineConstraint lc = (LineConstraint)constraint;
        this.t_planeNormal = lc.dir;
        this.t_pickLoc = handleLoc;
        this.t_origGeom = this.d_geom;
    }

    @Override
    public Object modify(Point3d newLoc) throws ManipException {
        double t = Util3D.tOnLine(this.t_pickLoc, this.t_planeNormal, newLoc);
        if (Double.isNaN(t)) {
            throw new ManipException();
        }
        this.d_geom = this.modify(this.t_origGeom, t);
        return this.d_geom;
    }

    @Override
    public Object end() {
        this.t_pickLoc = null;
        this.t_planeNormal = null;
        this.t_origGeom = null;
        return this.d_geom;
    }
}

